/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.ssm.transform.MaintenanceWindowLambdaParametersMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MaintenanceWindowLambdaParameters
implements StructuredPojo,
ToCopyableBuilder<Builder, MaintenanceWindowLambdaParameters> {
    private final String clientContext;
    private final String qualifier;
    private final ByteBuffer payload;

    private MaintenanceWindowLambdaParameters(BuilderImpl builder) {
        this.clientContext = builder.clientContext;
        this.qualifier = builder.qualifier;
        this.payload = builder.payload;
    }

    public String clientContext() {
        return this.clientContext;
    }

    public String qualifier() {
        return this.qualifier;
    }

    public ByteBuffer payload() {
        return this.payload == null ? null : this.payload.asReadOnlyBuffer();
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientContext());
        hashCode = 31 * hashCode + Objects.hashCode(this.qualifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.payload());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceWindowLambdaParameters)) {
            return false;
        }
        MaintenanceWindowLambdaParameters other = (MaintenanceWindowLambdaParameters)obj;
        return Objects.equals(this.clientContext(), other.clientContext()) && Objects.equals(this.qualifier(), other.qualifier()) && Objects.equals(this.payload(), other.payload());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.clientContext() != null) {
            sb.append("ClientContext: ").append(this.clientContext()).append(",");
        }
        if (this.qualifier() != null) {
            sb.append("Qualifier: ").append(this.qualifier()).append(",");
        }
        if (this.payload() != null) {
            sb.append("Payload: ").append(this.payload()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientContext": {
                return Optional.of(clazz.cast(this.clientContext()));
            }
            case "Qualifier": {
                return Optional.of(clazz.cast(this.qualifier()));
            }
            case "Payload": {
                return Optional.of(clazz.cast(this.payload()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MaintenanceWindowLambdaParametersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String clientContext;
        private String qualifier;
        private ByteBuffer payload;

        private BuilderImpl() {
        }

        private BuilderImpl(MaintenanceWindowLambdaParameters model) {
            this.clientContext(model.clientContext);
            this.qualifier(model.qualifier);
            this.payload(model.payload);
        }

        public final String getClientContext() {
            return this.clientContext;
        }

        @Override
        public final Builder clientContext(String clientContext) {
            this.clientContext = clientContext;
            return this;
        }

        public final void setClientContext(String clientContext) {
            this.clientContext = clientContext;
        }

        public final String getQualifier() {
            return this.qualifier;
        }

        @Override
        public final Builder qualifier(String qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        public final void setQualifier(String qualifier) {
            this.qualifier = qualifier;
        }

        public final ByteBuffer getPayload() {
            return this.payload;
        }

        @Override
        public final Builder payload(ByteBuffer payload) {
            this.payload = StandardMemberCopier.copy((ByteBuffer)payload);
            return this;
        }

        public final void setPayload(ByteBuffer payload) {
            this.payload = StandardMemberCopier.copy((ByteBuffer)payload);
        }

        public MaintenanceWindowLambdaParameters build() {
            return new MaintenanceWindowLambdaParameters(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MaintenanceWindowLambdaParameters> {
        public Builder clientContext(String var1);

        public Builder qualifier(String var1);

        public Builder payload(ByteBuffer var1);
    }
}

