/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ssm.model.AutomationParameterMapCopier;
import software.amazon.awssdk.services.ssm.model.SignalType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SendAutomationSignalRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, SendAutomationSignalRequest> {
    private final String automationExecutionId;
    private final String signalType;
    private final Map<String, List<String>> payload;

    private SendAutomationSignalRequest(BuilderImpl builder) {
        this.automationExecutionId = builder.automationExecutionId;
        this.signalType = builder.signalType;
        this.payload = builder.payload;
    }

    public String automationExecutionId() {
        return this.automationExecutionId;
    }

    public SignalType signalType() {
        return SignalType.fromValue(this.signalType);
    }

    public String signalTypeString() {
        return this.signalType;
    }

    public Map<String, List<String>> payload() {
        return this.payload;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.automationExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.signalTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.payload());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendAutomationSignalRequest)) {
            return false;
        }
        SendAutomationSignalRequest other = (SendAutomationSignalRequest)((Object)obj);
        return Objects.equals(this.automationExecutionId(), other.automationExecutionId()) && Objects.equals(this.signalTypeString(), other.signalTypeString()) && Objects.equals(this.payload(), other.payload());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.automationExecutionId() != null) {
            sb.append("AutomationExecutionId: ").append(this.automationExecutionId()).append(",");
        }
        if (this.signalTypeString() != null) {
            sb.append("SignalType: ").append(this.signalTypeString()).append(",");
        }
        if (this.payload() != null) {
            sb.append("Payload: ").append(this.payload()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutomationExecutionId": {
                return Optional.of(clazz.cast(this.automationExecutionId()));
            }
            case "SignalType": {
                return Optional.of(clazz.cast(this.signalTypeString()));
            }
            case "Payload": {
                return Optional.of(clazz.cast(this.payload()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String automationExecutionId;
        private String signalType;
        private Map<String, List<String>> payload;

        private BuilderImpl() {
        }

        private BuilderImpl(SendAutomationSignalRequest model) {
            this.automationExecutionId(model.automationExecutionId);
            this.signalType(model.signalType);
            this.payload(model.payload);
        }

        public final String getAutomationExecutionId() {
            return this.automationExecutionId;
        }

        @Override
        public final Builder automationExecutionId(String automationExecutionId) {
            this.automationExecutionId = automationExecutionId;
            return this;
        }

        public final void setAutomationExecutionId(String automationExecutionId) {
            this.automationExecutionId = automationExecutionId;
        }

        public final String getSignalType() {
            return this.signalType;
        }

        @Override
        public final Builder signalType(String signalType) {
            this.signalType = signalType;
            return this;
        }

        @Override
        public final Builder signalType(SignalType signalType) {
            this.signalType(signalType.toString());
            return this;
        }

        public final void setSignalType(String signalType) {
            this.signalType = signalType;
        }

        public final Map<String, ? extends Collection<String>> getPayload() {
            return this.payload;
        }

        @Override
        public final Builder payload(Map<String, ? extends Collection<String>> payload) {
            this.payload = AutomationParameterMapCopier.copy(payload);
            return this;
        }

        public final void setPayload(Map<String, ? extends Collection<String>> payload) {
            this.payload = AutomationParameterMapCopier.copy(payload);
        }

        public SendAutomationSignalRequest build() {
            return new SendAutomationSignalRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SendAutomationSignalRequest> {
        public Builder automationExecutionId(String var1);

        public Builder signalType(String var1);

        public Builder signalType(SignalType var1);

        public Builder payload(Map<String, ? extends Collection<String>> var1);
    }
}

