/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.ssm.SSMClient;
import software.amazon.awssdk.services.ssm.model.DescribeParametersRequest;
import software.amazon.awssdk.services.ssm.model.DescribeParametersResponse;

public final class DescribeParametersPaginator
implements SdkIterable<DescribeParametersResponse> {
    private final SSMClient client;
    private final DescribeParametersRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeParametersPaginator(SSMClient client, DescribeParametersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeParametersResponseFetcher();
    }

    public Iterator<DescribeParametersResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class DescribeParametersResponseFetcher
    implements NextPageFetcher<DescribeParametersResponse> {
        private DescribeParametersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeParametersResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeParametersResponse nextPage(DescribeParametersResponse previousPage) {
            if (previousPage == null) {
                return DescribeParametersPaginator.this.client.describeParameters(DescribeParametersPaginator.this.firstRequest);
            }
            return DescribeParametersPaginator.this.client.describeParameters((DescribeParametersRequest)((Object)DescribeParametersPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

