/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowTaskRequest;

@SdkInternalApi
public class GetMaintenanceWindowTaskRequestModelMarshaller {
    private static final MarshallingInfo<String> WINDOWID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WindowId").build();
    private static final MarshallingInfo<String> WINDOWTASKID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WindowTaskId").build();
    private static final GetMaintenanceWindowTaskRequestModelMarshaller INSTANCE = new GetMaintenanceWindowTaskRequestModelMarshaller();

    public static GetMaintenanceWindowTaskRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GetMaintenanceWindowTaskRequest getMaintenanceWindowTaskRequest, ProtocolMarshaller protocolMarshaller) {
        if (getMaintenanceWindowTaskRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)getMaintenanceWindowTaskRequest.windowId(), WINDOWID_BINDING);
            protocolMarshaller.marshall((Object)getMaintenanceWindowTaskRequest.windowTaskId(), WINDOWTASKID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

