/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ssm.model.ResourceDataSyncItem;
import software.amazon.awssdk.services.ssm.transform.ResourceDataSyncS3DestinationUnmarshaller;

public class ResourceDataSyncItemUnmarshaller
implements Unmarshaller<ResourceDataSyncItem, JsonUnmarshallerContext> {
    private static final ResourceDataSyncItemUnmarshaller INSTANCE = new ResourceDataSyncItemUnmarshaller();

    public ResourceDataSyncItem unmarshall(JsonUnmarshallerContext context) throws Exception {
        ResourceDataSyncItem.Builder resourceDataSyncItemBuilder = ResourceDataSyncItem.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("SyncName", targetDepth)) {
                    context.nextToken();
                    resourceDataSyncItemBuilder.syncName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("S3Destination", targetDepth)) {
                    context.nextToken();
                    resourceDataSyncItemBuilder.s3Destination(ResourceDataSyncS3DestinationUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("LastSyncTime", targetDepth)) {
                    context.nextToken();
                    resourceDataSyncItemBuilder.lastSyncTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("LastSuccessfulSyncTime", targetDepth)) {
                    context.nextToken();
                    resourceDataSyncItemBuilder.lastSuccessfulSyncTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("LastStatus", targetDepth)) {
                    context.nextToken();
                    resourceDataSyncItemBuilder.lastStatus((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("SyncCreatedTime", targetDepth)) {
                    context.nextToken();
                    resourceDataSyncItemBuilder.syncCreatedTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ResourceDataSyncItem)resourceDataSyncItemBuilder.build();
    }

    public static ResourceDataSyncItemUnmarshaller getInstance() {
        return INSTANCE;
    }
}

