/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class AddTagsToResourceRequest extends SSMRequest implements
        ToCopyableBuilder<AddTagsToResourceRequest.Builder, AddTagsToResourceRequest> {
    private final String resourceType;

    private final String resourceId;

    private final List<Tag> tags;

    private AddTagsToResourceRequest(BuilderImpl builder) {
        super(builder);
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Specifies the type of resource you are tagging.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceTypeForTagging#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceTypeString}.
     * </p>
     * 
     * @return Specifies the type of resource you are tagging.
     * @see ResourceTypeForTagging
     */
    public ResourceTypeForTagging resourceType() {
        return ResourceTypeForTagging.fromValue(resourceType);
    }

    /**
     * <p>
     * Specifies the type of resource you are tagging.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceTypeForTagging#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceTypeString}.
     * </p>
     * 
     * @return Specifies the type of resource you are tagging.
     * @see ResourceTypeForTagging
     */
    public String resourceTypeString() {
        return resourceType;
    }

    /**
     * <p>
     * The resource ID you want to tag.
     * </p>
     * <p>
     * For the ManagedInstance, MaintenanceWindow, and PatchBaseline values, use the ID of the resource, such as
     * mw-01234361858c9b57b for a Maintenance Window.
     * </p>
     * <p>
     * For the Document and Parameter values, use the name of the resource.
     * </p>
     * 
     * @return The resource ID you want to tag.</p>
     *         <p>
     *         For the ManagedInstance, MaintenanceWindow, and PatchBaseline values, use the ID of the resource, such as
     *         mw-01234361858c9b57b for a Maintenance Window.
     *         </p>
     *         <p>
     *         For the Document and Parameter values, use the name of the resource.
     */
    public String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * One or more tags. The value parameter is required, but if you don't want the tag to have a value, specify the
     * parameter with no value, and we set the value to an empty string.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more tags. The value parameter is required, but if you don't want the tag to have a value, specify
     *         the parameter with no value, and we set the value to an empty string.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddTagsToResourceRequest)) {
            return false;
        }
        AddTagsToResourceRequest other = (AddTagsToResourceRequest) obj;
        return Objects.equals(resourceTypeString(), other.resourceTypeString())
                && Objects.equals(resourceId(), other.resourceId()) && Objects.equals(tags(), other.tags());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (resourceTypeString() != null) {
            sb.append("ResourceType: ").append(resourceTypeString()).append(",");
        }
        if (resourceId() != null) {
            sb.append("ResourceId: ").append(resourceId()).append(",");
        }
        if (tags() != null) {
            sb.append("Tags: ").append(tags()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceType":
            return Optional.of(clazz.cast(resourceTypeString()));
        case "ResourceId":
            return Optional.of(clazz.cast(resourceId()));
        case "Tags":
            return Optional.of(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SSMRequest.Builder, CopyableBuilder<Builder, AddTagsToResourceRequest> {
        /**
         * <p>
         * Specifies the type of resource you are tagging.
         * </p>
         * 
         * @param resourceType
         *        Specifies the type of resource you are tagging.
         * @see ResourceTypeForTagging
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceTypeForTagging
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * Specifies the type of resource you are tagging.
         * </p>
         * 
         * @param resourceType
         *        Specifies the type of resource you are tagging.
         * @see ResourceTypeForTagging
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceTypeForTagging
         */
        Builder resourceType(ResourceTypeForTagging resourceType);

        /**
         * <p>
         * The resource ID you want to tag.
         * </p>
         * <p>
         * For the ManagedInstance, MaintenanceWindow, and PatchBaseline values, use the ID of the resource, such as
         * mw-01234361858c9b57b for a Maintenance Window.
         * </p>
         * <p>
         * For the Document and Parameter values, use the name of the resource.
         * </p>
         * 
         * @param resourceId
         *        The resource ID you want to tag.</p>
         *        <p>
         *        For the ManagedInstance, MaintenanceWindow, and PatchBaseline values, use the ID of the resource, such
         *        as mw-01234361858c9b57b for a Maintenance Window.
         *        </p>
         *        <p>
         *        For the Document and Parameter values, use the name of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * One or more tags. The value parameter is required, but if you don't want the tag to have a value, specify the
         * parameter with no value, and we set the value to an empty string.
         * </p>
         * 
         * @param tags
         *        One or more tags. The value parameter is required, but if you don't want the tag to have a value,
         *        specify the parameter with no value, and we set the value to an empty string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * One or more tags. The value parameter is required, but if you don't want the tag to have a value, specify the
         * parameter with no value, and we set the value to an empty string.
         * </p>
         * 
         * @param tags
         *        One or more tags. The value parameter is required, but if you don't want the tag to have a value,
         *        specify the parameter with no value, and we set the value to an empty string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends SSMRequest.BuilderImpl implements Builder {
        private String resourceType;

        private String resourceId;

        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(AddTagsToResourceRequest model) {
            resourceType(model.resourceType);
            resourceId(model.resourceId);
            tags(model.tags);
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceTypeForTagging resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public AddTagsToResourceRequest build() {
            return new AddTagsToResourceRequest(this);
        }
    }
}
