/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.AutomationExecutionMetadataMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a specific Automation execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AutomationExecutionMetadata implements StructuredPojo,
        ToCopyableBuilder<AutomationExecutionMetadata.Builder, AutomationExecutionMetadata> {
    private final String automationExecutionId;

    private final String documentName;

    private final String documentVersion;

    private final String automationExecutionStatus;

    private final Instant executionStartTime;

    private final Instant executionEndTime;

    private final String executedBy;

    private final String logFile;

    private final Map<String, List<String>> outputs;

    private AutomationExecutionMetadata(BuilderImpl builder) {
        this.automationExecutionId = builder.automationExecutionId;
        this.documentName = builder.documentName;
        this.documentVersion = builder.documentVersion;
        this.automationExecutionStatus = builder.automationExecutionStatus;
        this.executionStartTime = builder.executionStartTime;
        this.executionEndTime = builder.executionEndTime;
        this.executedBy = builder.executedBy;
        this.logFile = builder.logFile;
        this.outputs = builder.outputs;
    }

    /**
     * <p>
     * The execution ID.
     * </p>
     * 
     * @return The execution ID.
     */
    public String automationExecutionId() {
        return automationExecutionId;
    }

    /**
     * <p>
     * The name of the Automation document used during execution.
     * </p>
     * 
     * @return The name of the Automation document used during execution.
     */
    public String documentName() {
        return documentName;
    }

    /**
     * <p>
     * The document version used during the execution.
     * </p>
     * 
     * @return The document version used during the execution.
     */
    public String documentVersion() {
        return documentVersion;
    }

    /**
     * <p>
     * The status of the execution. Valid values include: Running, Succeeded, Failed, Timed out, or Cancelled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #automationExecutionStatus} will return {@link AutomationExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #automationExecutionStatusString}.
     * </p>
     * 
     * @return The status of the execution. Valid values include: Running, Succeeded, Failed, Timed out, or Cancelled.
     * @see AutomationExecutionStatus
     */
    public AutomationExecutionStatus automationExecutionStatus() {
        return AutomationExecutionStatus.fromValue(automationExecutionStatus);
    }

    /**
     * <p>
     * The status of the execution. Valid values include: Running, Succeeded, Failed, Timed out, or Cancelled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #automationExecutionStatus} will return {@link AutomationExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #automationExecutionStatusString}.
     * </p>
     * 
     * @return The status of the execution. Valid values include: Running, Succeeded, Failed, Timed out, or Cancelled.
     * @see AutomationExecutionStatus
     */
    public String automationExecutionStatusString() {
        return automationExecutionStatus;
    }

    /**
     * <p>
     * The time the execution started.&gt;
     * </p>
     * 
     * @return The time the execution started.&gt;
     */
    public Instant executionStartTime() {
        return executionStartTime;
    }

    /**
     * <p>
     * The time the execution finished. This is not populated if the execution is still in progress.
     * </p>
     * 
     * @return The time the execution finished. This is not populated if the execution is still in progress.
     */
    public Instant executionEndTime() {
        return executionEndTime;
    }

    /**
     * <p>
     * The IAM role ARN of the user who executed the Automation.
     * </p>
     * 
     * @return The IAM role ARN of the user who executed the Automation.
     */
    public String executedBy() {
        return executedBy;
    }

    /**
     * <p>
     * An Amazon S3 bucket where execution information is stored.
     * </p>
     * 
     * @return An Amazon S3 bucket where execution information is stored.
     */
    public String logFile() {
        return logFile;
    }

    /**
     * <p>
     * The list of execution outputs as defined in the Automation document.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of execution outputs as defined in the Automation document.
     */
    public Map<String, List<String>> outputs() {
        return outputs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(automationExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(documentName());
        hashCode = 31 * hashCode + Objects.hashCode(documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(automationExecutionStatusString());
        hashCode = 31 * hashCode + Objects.hashCode(executionStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(executionEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(executedBy());
        hashCode = 31 * hashCode + Objects.hashCode(logFile());
        hashCode = 31 * hashCode + Objects.hashCode(outputs());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomationExecutionMetadata)) {
            return false;
        }
        AutomationExecutionMetadata other = (AutomationExecutionMetadata) obj;
        return Objects.equals(automationExecutionId(), other.automationExecutionId())
                && Objects.equals(documentName(), other.documentName())
                && Objects.equals(documentVersion(), other.documentVersion())
                && Objects.equals(automationExecutionStatusString(), other.automationExecutionStatusString())
                && Objects.equals(executionStartTime(), other.executionStartTime())
                && Objects.equals(executionEndTime(), other.executionEndTime())
                && Objects.equals(executedBy(), other.executedBy()) && Objects.equals(logFile(), other.logFile())
                && Objects.equals(outputs(), other.outputs());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (automationExecutionId() != null) {
            sb.append("AutomationExecutionId: ").append(automationExecutionId()).append(",");
        }
        if (documentName() != null) {
            sb.append("DocumentName: ").append(documentName()).append(",");
        }
        if (documentVersion() != null) {
            sb.append("DocumentVersion: ").append(documentVersion()).append(",");
        }
        if (automationExecutionStatusString() != null) {
            sb.append("AutomationExecutionStatus: ").append(automationExecutionStatusString()).append(",");
        }
        if (executionStartTime() != null) {
            sb.append("ExecutionStartTime: ").append(executionStartTime()).append(",");
        }
        if (executionEndTime() != null) {
            sb.append("ExecutionEndTime: ").append(executionEndTime()).append(",");
        }
        if (executedBy() != null) {
            sb.append("ExecutedBy: ").append(executedBy()).append(",");
        }
        if (logFile() != null) {
            sb.append("LogFile: ").append(logFile()).append(",");
        }
        if (outputs() != null) {
            sb.append("Outputs: ").append(outputs()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutomationExecutionId":
            return Optional.of(clazz.cast(automationExecutionId()));
        case "DocumentName":
            return Optional.of(clazz.cast(documentName()));
        case "DocumentVersion":
            return Optional.of(clazz.cast(documentVersion()));
        case "AutomationExecutionStatus":
            return Optional.of(clazz.cast(automationExecutionStatusString()));
        case "ExecutionStartTime":
            return Optional.of(clazz.cast(executionStartTime()));
        case "ExecutionEndTime":
            return Optional.of(clazz.cast(executionEndTime()));
        case "ExecutedBy":
            return Optional.of(clazz.cast(executedBy()));
        case "LogFile":
            return Optional.of(clazz.cast(logFile()));
        case "Outputs":
            return Optional.of(clazz.cast(outputs()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AutomationExecutionMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, AutomationExecutionMetadata> {
        /**
         * <p>
         * The execution ID.
         * </p>
         * 
         * @param automationExecutionId
         *        The execution ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automationExecutionId(String automationExecutionId);

        /**
         * <p>
         * The name of the Automation document used during execution.
         * </p>
         * 
         * @param documentName
         *        The name of the Automation document used during execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentName(String documentName);

        /**
         * <p>
         * The document version used during the execution.
         * </p>
         * 
         * @param documentVersion
         *        The document version used during the execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentVersion(String documentVersion);

        /**
         * <p>
         * The status of the execution. Valid values include: Running, Succeeded, Failed, Timed out, or Cancelled.
         * </p>
         * 
         * @param automationExecutionStatus
         *        The status of the execution. Valid values include: Running, Succeeded, Failed, Timed out, or
         *        Cancelled.
         * @see AutomationExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomationExecutionStatus
         */
        Builder automationExecutionStatus(String automationExecutionStatus);

        /**
         * <p>
         * The status of the execution. Valid values include: Running, Succeeded, Failed, Timed out, or Cancelled.
         * </p>
         * 
         * @param automationExecutionStatus
         *        The status of the execution. Valid values include: Running, Succeeded, Failed, Timed out, or
         *        Cancelled.
         * @see AutomationExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomationExecutionStatus
         */
        Builder automationExecutionStatus(AutomationExecutionStatus automationExecutionStatus);

        /**
         * <p>
         * The time the execution started.&gt;
         * </p>
         * 
         * @param executionStartTime
         *        The time the execution started.&gt;
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionStartTime(Instant executionStartTime);

        /**
         * <p>
         * The time the execution finished. This is not populated if the execution is still in progress.
         * </p>
         * 
         * @param executionEndTime
         *        The time the execution finished. This is not populated if the execution is still in progress.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionEndTime(Instant executionEndTime);

        /**
         * <p>
         * The IAM role ARN of the user who executed the Automation.
         * </p>
         * 
         * @param executedBy
         *        The IAM role ARN of the user who executed the Automation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executedBy(String executedBy);

        /**
         * <p>
         * An Amazon S3 bucket where execution information is stored.
         * </p>
         * 
         * @param logFile
         *        An Amazon S3 bucket where execution information is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logFile(String logFile);

        /**
         * <p>
         * The list of execution outputs as defined in the Automation document.
         * </p>
         * 
         * @param outputs
         *        The list of execution outputs as defined in the Automation document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Map<String, ? extends Collection<String>> outputs);
    }

    static final class BuilderImpl implements Builder {
        private String automationExecutionId;

        private String documentName;

        private String documentVersion;

        private String automationExecutionStatus;

        private Instant executionStartTime;

        private Instant executionEndTime;

        private String executedBy;

        private String logFile;

        private Map<String, List<String>> outputs;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomationExecutionMetadata model) {
            automationExecutionId(model.automationExecutionId);
            documentName(model.documentName);
            documentVersion(model.documentVersion);
            automationExecutionStatus(model.automationExecutionStatus);
            executionStartTime(model.executionStartTime);
            executionEndTime(model.executionEndTime);
            executedBy(model.executedBy);
            logFile(model.logFile);
            outputs(model.outputs);
        }

        public final String getAutomationExecutionId() {
            return automationExecutionId;
        }

        @Override
        public final Builder automationExecutionId(String automationExecutionId) {
            this.automationExecutionId = automationExecutionId;
            return this;
        }

        public final void setAutomationExecutionId(String automationExecutionId) {
            this.automationExecutionId = automationExecutionId;
        }

        public final String getDocumentName() {
            return documentName;
        }

        @Override
        public final Builder documentName(String documentName) {
            this.documentName = documentName;
            return this;
        }

        public final void setDocumentName(String documentName) {
            this.documentName = documentName;
        }

        public final String getDocumentVersion() {
            return documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        public final String getAutomationExecutionStatus() {
            return automationExecutionStatus;
        }

        @Override
        public final Builder automationExecutionStatus(String automationExecutionStatus) {
            this.automationExecutionStatus = automationExecutionStatus;
            return this;
        }

        @Override
        public final Builder automationExecutionStatus(AutomationExecutionStatus automationExecutionStatus) {
            this.automationExecutionStatus(automationExecutionStatus.toString());
            return this;
        }

        public final void setAutomationExecutionStatus(String automationExecutionStatus) {
            this.automationExecutionStatus = automationExecutionStatus;
        }

        public final Instant getExecutionStartTime() {
            return executionStartTime;
        }

        @Override
        public final Builder executionStartTime(Instant executionStartTime) {
            this.executionStartTime = executionStartTime;
            return this;
        }

        public final void setExecutionStartTime(Instant executionStartTime) {
            this.executionStartTime = executionStartTime;
        }

        public final Instant getExecutionEndTime() {
            return executionEndTime;
        }

        @Override
        public final Builder executionEndTime(Instant executionEndTime) {
            this.executionEndTime = executionEndTime;
            return this;
        }

        public final void setExecutionEndTime(Instant executionEndTime) {
            this.executionEndTime = executionEndTime;
        }

        public final String getExecutedBy() {
            return executedBy;
        }

        @Override
        public final Builder executedBy(String executedBy) {
            this.executedBy = executedBy;
            return this;
        }

        public final void setExecutedBy(String executedBy) {
            this.executedBy = executedBy;
        }

        public final String getLogFile() {
            return logFile;
        }

        @Override
        public final Builder logFile(String logFile) {
            this.logFile = logFile;
            return this;
        }

        public final void setLogFile(String logFile) {
            this.logFile = logFile;
        }

        public final Map<String, ? extends Collection<String>> getOutputs() {
            return outputs;
        }

        @Override
        public final Builder outputs(Map<String, ? extends Collection<String>> outputs) {
            this.outputs = AutomationParameterMapCopier.copy(outputs);
            return this;
        }

        public final void setOutputs(Map<String, ? extends Collection<String>> outputs) {
            this.outputs = AutomationParameterMapCopier.copy(outputs);
        }

        @Override
        public AutomationExecutionMetadata build() {
            return new AutomationExecutionMetadata(this);
        }
    }
}
