/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateDocumentRequest extends SSMRequest implements
        ToCopyableBuilder<CreateDocumentRequest.Builder, CreateDocumentRequest> {
    private final String content;

    private final String name;

    private final String documentType;

    private CreateDocumentRequest(BuilderImpl builder) {
        super(builder);
        this.content = builder.content;
        this.name = builder.name;
        this.documentType = builder.documentType;
    }

    /**
     * <p>
     * A valid JSON string.
     * </p>
     * 
     * @return A valid JSON string.
     */
    public String content() {
        return content;
    }

    /**
     * <p>
     * A name for the Systems Manager document.
     * </p>
     * 
     * @return A name for the Systems Manager document.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The type of document to create. Valid document types include: Policy, Automation, and Command.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #documentType} will
     * return {@link DocumentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #documentTypeString}.
     * </p>
     * 
     * @return The type of document to create. Valid document types include: Policy, Automation, and Command.
     * @see DocumentType
     */
    public DocumentType documentType() {
        return DocumentType.fromValue(documentType);
    }

    /**
     * <p>
     * The type of document to create. Valid document types include: Policy, Automation, and Command.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #documentType} will
     * return {@link DocumentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #documentTypeString}.
     * </p>
     * 
     * @return The type of document to create. Valid document types include: Policy, Automation, and Command.
     * @see DocumentType
     */
    public String documentTypeString() {
        return documentType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(documentTypeString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDocumentRequest)) {
            return false;
        }
        CreateDocumentRequest other = (CreateDocumentRequest) obj;
        return Objects.equals(content(), other.content()) && Objects.equals(name(), other.name())
                && Objects.equals(documentTypeString(), other.documentTypeString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (content() != null) {
            sb.append("Content: ").append(content()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (documentTypeString() != null) {
            sb.append("DocumentType: ").append(documentTypeString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Content":
            return Optional.of(clazz.cast(content()));
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "DocumentType":
            return Optional.of(clazz.cast(documentTypeString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SSMRequest.Builder, CopyableBuilder<Builder, CreateDocumentRequest> {
        /**
         * <p>
         * A valid JSON string.
         * </p>
         * 
         * @param content
         *        A valid JSON string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);

        /**
         * <p>
         * A name for the Systems Manager document.
         * </p>
         * 
         * @param name
         *        A name for the Systems Manager document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of document to create. Valid document types include: Policy, Automation, and Command.
         * </p>
         * 
         * @param documentType
         *        The type of document to create. Valid document types include: Policy, Automation, and Command.
         * @see DocumentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentType
         */
        Builder documentType(String documentType);

        /**
         * <p>
         * The type of document to create. Valid document types include: Policy, Automation, and Command.
         * </p>
         * 
         * @param documentType
         *        The type of document to create. Valid document types include: Policy, Automation, and Command.
         * @see DocumentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentType
         */
        Builder documentType(DocumentType documentType);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends SSMRequest.BuilderImpl implements Builder {
        private String content;

        private String name;

        private String documentType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDocumentRequest model) {
            content(model.content);
            name(model.name);
            documentType(model.documentType);
        }

        public final String getContent() {
            return content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDocumentType() {
            return documentType;
        }

        @Override
        public final Builder documentType(String documentType) {
            this.documentType = documentType;
            return this;
        }

        @Override
        public final Builder documentType(DocumentType documentType) {
            this.documentType(documentType.toString());
            return this;
        }

        public final void setDocumentType(String documentType) {
            this.documentType = documentType;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateDocumentRequest build() {
            return new CreateDocumentRequest(this);
        }
    }
}
