/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteParametersRequest extends SSMRequest implements
        ToCopyableBuilder<DeleteParametersRequest.Builder, DeleteParametersRequest> {
    private final List<String> names;

    private DeleteParametersRequest(BuilderImpl builder) {
        super(builder);
        this.names = builder.names;
    }

    /**
     * <p>
     * The names of the parameters to delete.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The names of the parameters to delete.
     */
    public List<String> names() {
        return names;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(names());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteParametersRequest)) {
            return false;
        }
        DeleteParametersRequest other = (DeleteParametersRequest) obj;
        return Objects.equals(names(), other.names());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (names() != null) {
            sb.append("Names: ").append(names()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Names":
            return Optional.of(clazz.cast(names()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SSMRequest.Builder, CopyableBuilder<Builder, DeleteParametersRequest> {
        /**
         * <p>
         * The names of the parameters to delete.
         * </p>
         * 
         * @param names
         *        The names of the parameters to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder names(Collection<String> names);

        /**
         * <p>
         * The names of the parameters to delete.
         * </p>
         * 
         * @param names
         *        The names of the parameters to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder names(String... names);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends SSMRequest.BuilderImpl implements Builder {
        private List<String> names;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteParametersRequest model) {
            names(model.names);
        }

        public final Collection<String> getNames() {
            return names;
        }

        @Override
        public final Builder names(Collection<String> names) {
            this.names = ParameterNameListCopier.copy(names);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder names(String... names) {
            names(Arrays.asList(names));
            return this;
        }

        public final void setNames(Collection<String> names) {
            this.names = ParameterNameListCopier.copy(names);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteParametersRequest build() {
            return new DeleteParametersRequest(this);
        }
    }
}
