/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteResourceDataSyncRequest extends SSMRequest implements
        ToCopyableBuilder<DeleteResourceDataSyncRequest.Builder, DeleteResourceDataSyncRequest> {
    private final String syncName;

    private DeleteResourceDataSyncRequest(BuilderImpl builder) {
        super(builder);
        this.syncName = builder.syncName;
    }

    /**
     * <p>
     * The name of the configuration to delete.
     * </p>
     * 
     * @return The name of the configuration to delete.
     */
    public String syncName() {
        return syncName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(syncName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteResourceDataSyncRequest)) {
            return false;
        }
        DeleteResourceDataSyncRequest other = (DeleteResourceDataSyncRequest) obj;
        return Objects.equals(syncName(), other.syncName());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (syncName() != null) {
            sb.append("SyncName: ").append(syncName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SyncName":
            return Optional.of(clazz.cast(syncName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SSMRequest.Builder, CopyableBuilder<Builder, DeleteResourceDataSyncRequest> {
        /**
         * <p>
         * The name of the configuration to delete.
         * </p>
         * 
         * @param syncName
         *        The name of the configuration to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syncName(String syncName);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends SSMRequest.BuilderImpl implements Builder {
        private String syncName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteResourceDataSyncRequest model) {
            syncName(model.syncName);
        }

        public final String getSyncName() {
            return syncName;
        }

        @Override
        public final Builder syncName(String syncName) {
            this.syncName = syncName;
            return this;
        }

        public final void setSyncName(String syncName) {
            this.syncName = syncName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteResourceDataSyncRequest build() {
            return new DeleteResourceDataSyncRequest(this);
        }
    }
}
