/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeregisterTargetFromMaintenanceWindowResponse extends SSMResponse implements
        ToCopyableBuilder<DeregisterTargetFromMaintenanceWindowResponse.Builder, DeregisterTargetFromMaintenanceWindowResponse> {
    private final String windowId;

    private final String windowTargetId;

    private DeregisterTargetFromMaintenanceWindowResponse(BuilderImpl builder) {
        super(builder);
        this.windowId = builder.windowId;
        this.windowTargetId = builder.windowTargetId;
    }

    /**
     * <p>
     * The ID of the Maintenance Window the target was removed from.
     * </p>
     * 
     * @return The ID of the Maintenance Window the target was removed from.
     */
    public String windowId() {
        return windowId;
    }

    /**
     * <p>
     * The ID of the removed target definition.
     * </p>
     * 
     * @return The ID of the removed target definition.
     */
    public String windowTargetId() {
        return windowTargetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(windowId());
        hashCode = 31 * hashCode + Objects.hashCode(windowTargetId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeregisterTargetFromMaintenanceWindowResponse)) {
            return false;
        }
        DeregisterTargetFromMaintenanceWindowResponse other = (DeregisterTargetFromMaintenanceWindowResponse) obj;
        return Objects.equals(windowId(), other.windowId()) && Objects.equals(windowTargetId(), other.windowTargetId());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (windowId() != null) {
            sb.append("WindowId: ").append(windowId()).append(",");
        }
        if (windowTargetId() != null) {
            sb.append("WindowTargetId: ").append(windowTargetId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WindowId":
            return Optional.of(clazz.cast(windowId()));
        case "WindowTargetId":
            return Optional.of(clazz.cast(windowTargetId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SSMResponse.Builder, CopyableBuilder<Builder, DeregisterTargetFromMaintenanceWindowResponse> {
        /**
         * <p>
         * The ID of the Maintenance Window the target was removed from.
         * </p>
         * 
         * @param windowId
         *        The ID of the Maintenance Window the target was removed from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowId(String windowId);

        /**
         * <p>
         * The ID of the removed target definition.
         * </p>
         * 
         * @param windowTargetId
         *        The ID of the removed target definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowTargetId(String windowTargetId);
    }

    static final class BuilderImpl extends SSMResponse.BuilderImpl implements Builder {
        private String windowId;

        private String windowTargetId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeregisterTargetFromMaintenanceWindowResponse model) {
            windowId(model.windowId);
            windowTargetId(model.windowTargetId);
        }

        public final String getWindowId() {
            return windowId;
        }

        @Override
        public final Builder windowId(String windowId) {
            this.windowId = windowId;
            return this;
        }

        public final void setWindowId(String windowId) {
            this.windowId = windowId;
        }

        public final String getWindowTargetId() {
            return windowTargetId;
        }

        @Override
        public final Builder windowTargetId(String windowTargetId) {
            this.windowTargetId = windowTargetId;
            return this;
        }

        public final void setWindowTargetId(String windowTargetId) {
            this.windowTargetId = windowTargetId;
        }

        @Override
        public DeregisterTargetFromMaintenanceWindowResponse build() {
            return new DeregisterTargetFromMaintenanceWindowResponse(this);
        }
    }
}
