/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeAssociationRequest extends SSMRequest implements
        ToCopyableBuilder<DescribeAssociationRequest.Builder, DescribeAssociationRequest> {
    private final String name;

    private final String instanceId;

    private final String associationId;

    private final String associationVersion;

    private DescribeAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.instanceId = builder.instanceId;
        this.associationId = builder.associationId;
        this.associationVersion = builder.associationVersion;
    }

    /**
     * <p>
     * The name of the Systems Manager document.
     * </p>
     * 
     * @return The name of the Systems Manager document.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The instance ID.
     * </p>
     * 
     * @return The instance ID.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The association ID for which you want information.
     * </p>
     * 
     * @return The association ID for which you want information.
     */
    public String associationId() {
        return associationId;
    }

    /**
     * <p>
     * Specify the association version to retrieve. To view the latest version, either specify <code>$LATEST</code> for
     * this parameter, or omit this parameter. To view a list of all associations for an instance, use
     * ListInstanceAssociations. To get a list of versions for a specific association, use ListAssociationVersions.
     * </p>
     * 
     * @return Specify the association version to retrieve. To view the latest version, either specify
     *         <code>$LATEST</code> for this parameter, or omit this parameter. To view a list of all associations for
     *         an instance, use ListInstanceAssociations. To get a list of versions for a specific association, use
     *         ListAssociationVersions.
     */
    public String associationVersion() {
        return associationVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(associationId());
        hashCode = 31 * hashCode + Objects.hashCode(associationVersion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAssociationRequest)) {
            return false;
        }
        DescribeAssociationRequest other = (DescribeAssociationRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(associationId(), other.associationId())
                && Objects.equals(associationVersion(), other.associationVersion());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (associationId() != null) {
            sb.append("AssociationId: ").append(associationId()).append(",");
        }
        if (associationVersion() != null) {
            sb.append("AssociationVersion: ").append(associationVersion()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "InstanceId":
            return Optional.of(clazz.cast(instanceId()));
        case "AssociationId":
            return Optional.of(clazz.cast(associationId()));
        case "AssociationVersion":
            return Optional.of(clazz.cast(associationVersion()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SSMRequest.Builder, CopyableBuilder<Builder, DescribeAssociationRequest> {
        /**
         * <p>
         * The name of the Systems Manager document.
         * </p>
         * 
         * @param name
         *        The name of the Systems Manager document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The instance ID.
         * </p>
         * 
         * @param instanceId
         *        The instance ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The association ID for which you want information.
         * </p>
         * 
         * @param associationId
         *        The association ID for which you want information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationId(String associationId);

        /**
         * <p>
         * Specify the association version to retrieve. To view the latest version, either specify <code>$LATEST</code>
         * for this parameter, or omit this parameter. To view a list of all associations for an instance, use
         * ListInstanceAssociations. To get a list of versions for a specific association, use ListAssociationVersions.
         * </p>
         * 
         * @param associationVersion
         *        Specify the association version to retrieve. To view the latest version, either specify
         *        <code>$LATEST</code> for this parameter, or omit this parameter. To view a list of all associations
         *        for an instance, use ListInstanceAssociations. To get a list of versions for a specific association,
         *        use ListAssociationVersions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationVersion(String associationVersion);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends SSMRequest.BuilderImpl implements Builder {
        private String name;

        private String instanceId;

        private String associationId;

        private String associationVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAssociationRequest model) {
            name(model.name);
            instanceId(model.instanceId);
            associationId(model.associationId);
            associationVersion(model.associationVersion);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getAssociationId() {
            return associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        public final String getAssociationVersion() {
            return associationVersion;
        }

        @Override
        public final Builder associationVersion(String associationVersion) {
            this.associationVersion = associationVersion;
            return this;
        }

        public final void setAssociationVersion(String associationVersion) {
            this.associationVersion = associationVersion;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeAssociationRequest build() {
            return new DescribeAssociationRequest(this);
        }
    }
}
