/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeAutomationExecutionsResponse extends SSMResponse implements
        ToCopyableBuilder<DescribeAutomationExecutionsResponse.Builder, DescribeAutomationExecutionsResponse> {
    private final List<AutomationExecutionMetadata> automationExecutionMetadataList;

    private final String nextToken;

    private DescribeAutomationExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.automationExecutionMetadataList = builder.automationExecutionMetadataList;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The list of details about each automation execution which has occurred which matches the filter specification, if
     * any.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of details about each automation execution which has occurred which matches the filter
     *         specification, if any.
     */
    public List<AutomationExecutionMetadata> automationExecutionMetadataList() {
        return automationExecutionMetadataList;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(automationExecutionMetadataList());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAutomationExecutionsResponse)) {
            return false;
        }
        DescribeAutomationExecutionsResponse other = (DescribeAutomationExecutionsResponse) obj;
        return Objects.equals(automationExecutionMetadataList(), other.automationExecutionMetadataList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (automationExecutionMetadataList() != null) {
            sb.append("AutomationExecutionMetadataList: ").append(automationExecutionMetadataList()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutomationExecutionMetadataList":
            return Optional.of(clazz.cast(automationExecutionMetadataList()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SSMResponse.Builder, CopyableBuilder<Builder, DescribeAutomationExecutionsResponse> {
        /**
         * <p>
         * The list of details about each automation execution which has occurred which matches the filter
         * specification, if any.
         * </p>
         * 
         * @param automationExecutionMetadataList
         *        The list of details about each automation execution which has occurred which matches the filter
         *        specification, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automationExecutionMetadataList(Collection<AutomationExecutionMetadata> automationExecutionMetadataList);

        /**
         * <p>
         * The list of details about each automation execution which has occurred which matches the filter
         * specification, if any.
         * </p>
         * 
         * @param automationExecutionMetadataList
         *        The list of details about each automation execution which has occurred which matches the filter
         *        specification, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automationExecutionMetadataList(AutomationExecutionMetadata... automationExecutionMetadataList);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SSMResponse.BuilderImpl implements Builder {
        private List<AutomationExecutionMetadata> automationExecutionMetadataList;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAutomationExecutionsResponse model) {
            automationExecutionMetadataList(model.automationExecutionMetadataList);
            nextToken(model.nextToken);
        }

        public final Collection<AutomationExecutionMetadata.Builder> getAutomationExecutionMetadataList() {
            return automationExecutionMetadataList != null ? automationExecutionMetadataList.stream()
                    .map(AutomationExecutionMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder automationExecutionMetadataList(
                Collection<AutomationExecutionMetadata> automationExecutionMetadataList) {
            this.automationExecutionMetadataList = AutomationExecutionMetadataListCopier.copy(automationExecutionMetadataList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder automationExecutionMetadataList(AutomationExecutionMetadata... automationExecutionMetadataList) {
            automationExecutionMetadataList(Arrays.asList(automationExecutionMetadataList));
            return this;
        }

        public final void setAutomationExecutionMetadataList(
                Collection<AutomationExecutionMetadata.BuilderImpl> automationExecutionMetadataList) {
            this.automationExecutionMetadataList = AutomationExecutionMetadataListCopier
                    .copyFromBuilder(automationExecutionMetadataList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeAutomationExecutionsResponse build() {
            return new DescribeAutomationExecutionsResponse(this);
        }
    }
}
