/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeInstanceAssociationsStatusResponse extends SSMResponse implements
        ToCopyableBuilder<DescribeInstanceAssociationsStatusResponse.Builder, DescribeInstanceAssociationsStatusResponse> {
    private final List<InstanceAssociationStatusInfo> instanceAssociationStatusInfos;

    private final String nextToken;

    private DescribeInstanceAssociationsStatusResponse(BuilderImpl builder) {
        super(builder);
        this.instanceAssociationStatusInfos = builder.instanceAssociationStatusInfos;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Status information about the association.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Status information about the association.
     */
    public List<InstanceAssociationStatusInfo> instanceAssociationStatusInfos() {
        return instanceAssociationStatusInfos;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceAssociationStatusInfos());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceAssociationsStatusResponse)) {
            return false;
        }
        DescribeInstanceAssociationsStatusResponse other = (DescribeInstanceAssociationsStatusResponse) obj;
        return Objects.equals(instanceAssociationStatusInfos(), other.instanceAssociationStatusInfos())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (instanceAssociationStatusInfos() != null) {
            sb.append("InstanceAssociationStatusInfos: ").append(instanceAssociationStatusInfos()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceAssociationStatusInfos":
            return Optional.of(clazz.cast(instanceAssociationStatusInfos()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SSMResponse.Builder, CopyableBuilder<Builder, DescribeInstanceAssociationsStatusResponse> {
        /**
         * <p>
         * Status information about the association.
         * </p>
         * 
         * @param instanceAssociationStatusInfos
         *        Status information about the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceAssociationStatusInfos(Collection<InstanceAssociationStatusInfo> instanceAssociationStatusInfos);

        /**
         * <p>
         * Status information about the association.
         * </p>
         * 
         * @param instanceAssociationStatusInfos
         *        Status information about the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceAssociationStatusInfos(InstanceAssociationStatusInfo... instanceAssociationStatusInfos);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SSMResponse.BuilderImpl implements Builder {
        private List<InstanceAssociationStatusInfo> instanceAssociationStatusInfos;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstanceAssociationsStatusResponse model) {
            instanceAssociationStatusInfos(model.instanceAssociationStatusInfos);
            nextToken(model.nextToken);
        }

        public final Collection<InstanceAssociationStatusInfo.Builder> getInstanceAssociationStatusInfos() {
            return instanceAssociationStatusInfos != null ? instanceAssociationStatusInfos.stream()
                    .map(InstanceAssociationStatusInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceAssociationStatusInfos(
                Collection<InstanceAssociationStatusInfo> instanceAssociationStatusInfos) {
            this.instanceAssociationStatusInfos = InstanceAssociationStatusInfosCopier.copy(instanceAssociationStatusInfos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceAssociationStatusInfos(InstanceAssociationStatusInfo... instanceAssociationStatusInfos) {
            instanceAssociationStatusInfos(Arrays.asList(instanceAssociationStatusInfos));
            return this;
        }

        public final void setInstanceAssociationStatusInfos(
                Collection<InstanceAssociationStatusInfo.BuilderImpl> instanceAssociationStatusInfos) {
            this.instanceAssociationStatusInfos = InstanceAssociationStatusInfosCopier
                    .copyFromBuilder(instanceAssociationStatusInfos);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeInstanceAssociationsStatusResponse build() {
            return new DescribeInstanceAssociationsStatusResponse(this);
        }
    }
}
