/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.FailedCreateAssociationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a failed association.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class FailedCreateAssociation implements StructuredPojo,
        ToCopyableBuilder<FailedCreateAssociation.Builder, FailedCreateAssociation> {
    private final CreateAssociationBatchRequestEntry entry;

    private final String message;

    private final String fault;

    private FailedCreateAssociation(BuilderImpl builder) {
        this.entry = builder.entry;
        this.message = builder.message;
        this.fault = builder.fault;
    }

    /**
     * <p>
     * The association.
     * </p>
     * 
     * @return The association.
     */
    public CreateAssociationBatchRequestEntry entry() {
        return entry;
    }

    /**
     * <p>
     * A description of the failure.
     * </p>
     * 
     * @return A description of the failure.
     */
    public String message() {
        return message;
    }

    /**
     * <p>
     * The source of the failure.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fault} will return
     * {@link Fault#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #faultString}.
     * </p>
     * 
     * @return The source of the failure.
     * @see Fault
     */
    public Fault fault() {
        return Fault.fromValue(fault);
    }

    /**
     * <p>
     * The source of the failure.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fault} will return
     * {@link Fault#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #faultString}.
     * </p>
     * 
     * @return The source of the failure.
     * @see Fault
     */
    public String faultString() {
        return fault;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(entry());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(faultString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailedCreateAssociation)) {
            return false;
        }
        FailedCreateAssociation other = (FailedCreateAssociation) obj;
        return Objects.equals(entry(), other.entry()) && Objects.equals(message(), other.message())
                && Objects.equals(faultString(), other.faultString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (entry() != null) {
            sb.append("Entry: ").append(entry()).append(",");
        }
        if (message() != null) {
            sb.append("Message: ").append(message()).append(",");
        }
        if (faultString() != null) {
            sb.append("Fault: ").append(faultString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Entry":
            return Optional.of(clazz.cast(entry()));
        case "Message":
            return Optional.of(clazz.cast(message()));
        case "Fault":
            return Optional.of(clazz.cast(faultString()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FailedCreateAssociationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, FailedCreateAssociation> {
        /**
         * <p>
         * The association.
         * </p>
         * 
         * @param entry
         *        The association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entry(CreateAssociationBatchRequestEntry entry);

        /**
         * <p>
         * The association.
         * </p>
         * This is a convenience that creates an instance of the {@link CreateAssociationBatchRequestEntry.Builder}
         * avoiding the need to create one manually via {@link CreateAssociationBatchRequestEntry#builder()}.
         *
         * When the {@link Consumer} completes, {@link CreateAssociationBatchRequestEntry.Builder#build()} is called
         * immediately and its result is passed to {@link #entry(CreateAssociationBatchRequestEntry)}.
         * 
         * @param entry
         *        a consumer that will call methods on {@link CreateAssociationBatchRequestEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entry(CreateAssociationBatchRequestEntry)
         */
        default Builder entry(Consumer<CreateAssociationBatchRequestEntry.Builder> entry) {
            return entry(CreateAssociationBatchRequestEntry.builder().apply(entry).build());
        }

        /**
         * <p>
         * A description of the failure.
         * </p>
         * 
         * @param message
         *        A description of the failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The source of the failure.
         * </p>
         * 
         * @param fault
         *        The source of the failure.
         * @see Fault
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Fault
         */
        Builder fault(String fault);

        /**
         * <p>
         * The source of the failure.
         * </p>
         * 
         * @param fault
         *        The source of the failure.
         * @see Fault
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Fault
         */
        Builder fault(Fault fault);
    }

    static final class BuilderImpl implements Builder {
        private CreateAssociationBatchRequestEntry entry;

        private String message;

        private String fault;

        private BuilderImpl() {
        }

        private BuilderImpl(FailedCreateAssociation model) {
            entry(model.entry);
            message(model.message);
            fault(model.fault);
        }

        public final CreateAssociationBatchRequestEntry.Builder getEntry() {
            return entry != null ? entry.toBuilder() : null;
        }

        @Override
        public final Builder entry(CreateAssociationBatchRequestEntry entry) {
            this.entry = entry;
            return this;
        }

        public final void setEntry(CreateAssociationBatchRequestEntry.BuilderImpl entry) {
            this.entry = entry != null ? entry.build() : null;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getFault() {
            return fault;
        }

        @Override
        public final Builder fault(String fault) {
            this.fault = fault;
            return this;
        }

        @Override
        public final Builder fault(Fault fault) {
            this.fault(fault.toString());
            return this;
        }

        public final void setFault(String fault) {
            this.fault = fault;
        }

        @Override
        public FailedCreateAssociation build() {
            return new FailedCreateAssociation(this);
        }
    }
}
