/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.FailureDetailsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an Automation failure.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class FailureDetails implements StructuredPojo, ToCopyableBuilder<FailureDetails.Builder, FailureDetails> {
    private final String failureStage;

    private final String failureType;

    private final Map<String, List<String>> details;

    private FailureDetails(BuilderImpl builder) {
        this.failureStage = builder.failureStage;
        this.failureType = builder.failureType;
        this.details = builder.details;
    }

    /**
     * <p>
     * The stage of the Automation execution when the failure occurred. The stages include the following:
     * InputValidation, PreVerification, Invocation, PostVerification.
     * </p>
     * 
     * @return The stage of the Automation execution when the failure occurred. The stages include the following:
     *         InputValidation, PreVerification, Invocation, PostVerification.
     */
    public String failureStage() {
        return failureStage;
    }

    /**
     * <p>
     * The type of Automation failure. Failure types include the following: Action, Permission, Throttling,
     * Verification, Internal.
     * </p>
     * 
     * @return The type of Automation failure. Failure types include the following: Action, Permission, Throttling,
     *         Verification, Internal.
     */
    public String failureType() {
        return failureType;
    }

    /**
     * <p>
     * Detailed information about the Automation step failure.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Detailed information about the Automation step failure.
     */
    public Map<String, List<String>> details() {
        return details;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(failureStage());
        hashCode = 31 * hashCode + Objects.hashCode(failureType());
        hashCode = 31 * hashCode + Objects.hashCode(details());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailureDetails)) {
            return false;
        }
        FailureDetails other = (FailureDetails) obj;
        return Objects.equals(failureStage(), other.failureStage()) && Objects.equals(failureType(), other.failureType())
                && Objects.equals(details(), other.details());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (failureStage() != null) {
            sb.append("FailureStage: ").append(failureStage()).append(",");
        }
        if (failureType() != null) {
            sb.append("FailureType: ").append(failureType()).append(",");
        }
        if (details() != null) {
            sb.append("Details: ").append(details()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FailureStage":
            return Optional.of(clazz.cast(failureStage()));
        case "FailureType":
            return Optional.of(clazz.cast(failureType()));
        case "Details":
            return Optional.of(clazz.cast(details()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FailureDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, FailureDetails> {
        /**
         * <p>
         * The stage of the Automation execution when the failure occurred. The stages include the following:
         * InputValidation, PreVerification, Invocation, PostVerification.
         * </p>
         * 
         * @param failureStage
         *        The stage of the Automation execution when the failure occurred. The stages include the following:
         *        InputValidation, PreVerification, Invocation, PostVerification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureStage(String failureStage);

        /**
         * <p>
         * The type of Automation failure. Failure types include the following: Action, Permission, Throttling,
         * Verification, Internal.
         * </p>
         * 
         * @param failureType
         *        The type of Automation failure. Failure types include the following: Action, Permission, Throttling,
         *        Verification, Internal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureType(String failureType);

        /**
         * <p>
         * Detailed information about the Automation step failure.
         * </p>
         * 
         * @param details
         *        Detailed information about the Automation step failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(Map<String, ? extends Collection<String>> details);
    }

    static final class BuilderImpl implements Builder {
        private String failureStage;

        private String failureType;

        private Map<String, List<String>> details;

        private BuilderImpl() {
        }

        private BuilderImpl(FailureDetails model) {
            failureStage(model.failureStage);
            failureType(model.failureType);
            details(model.details);
        }

        public final String getFailureStage() {
            return failureStage;
        }

        @Override
        public final Builder failureStage(String failureStage) {
            this.failureStage = failureStage;
            return this;
        }

        public final void setFailureStage(String failureStage) {
            this.failureStage = failureStage;
        }

        public final String getFailureType() {
            return failureType;
        }

        @Override
        public final Builder failureType(String failureType) {
            this.failureType = failureType;
            return this;
        }

        public final void setFailureType(String failureType) {
            this.failureType = failureType;
        }

        public final Map<String, ? extends Collection<String>> getDetails() {
            return details;
        }

        @Override
        public final Builder details(Map<String, ? extends Collection<String>> details) {
            this.details = AutomationParameterMapCopier.copy(details);
            return this;
        }

        public final void setDetails(Map<String, ? extends Collection<String>> details) {
            this.details = AutomationParameterMapCopier.copy(details);
        }

        @Override
        public FailureDetails build() {
            return new FailureDetails(this);
        }
    }
}
