/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetInventoryRequest extends SSMRequest implements
        ToCopyableBuilder<GetInventoryRequest.Builder, GetInventoryRequest> {
    private final List<InventoryFilter> filters;

    private final List<InventoryAggregator> aggregators;

    private final List<ResultAttribute> resultAttributes;

    private final String nextToken;

    private final Integer maxResults;

    private GetInventoryRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.aggregators = builder.aggregators;
        this.resultAttributes = builder.resultAttributes;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * One or more filters. Use a filter to return a more specific list of results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters. Use a filter to return a more specific list of results.
     */
    public List<InventoryFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * Returns counts of inventory types based on one or more expressions. For example, if you aggregate by using an
     * expression that uses the <code>AWS:InstanceInformation.PlatformType</code> type, you can see a count of how many
     * Windows and Linux instances exist in your inventoried fleet.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Returns counts of inventory types based on one or more expressions. For example, if you aggregate by
     *         using an expression that uses the <code>AWS:InstanceInformation.PlatformType</code> type, you can see a
     *         count of how many Windows and Linux instances exist in your inventoried fleet.
     */
    public List<InventoryAggregator> aggregators() {
        return aggregators;
    }

    /**
     * <p>
     * The list of inventory item types to return.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of inventory item types to return.
     */
    public List<ResultAttribute> resultAttributes() {
        return resultAttributes;
    }

    /**
     * <p>
     * The token for the next set of items to return. (You received this token from a previous call.)
     * </p>
     * 
     * @return The token for the next set of items to return. (You received this token from a previous call.)
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items to return for this call. The call also returns a token that you can specify in a
     * subsequent call to get the next set of results.
     * </p>
     * 
     * @return The maximum number of items to return for this call. The call also returns a token that you can specify
     *         in a subsequent call to get the next set of results.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(aggregators());
        hashCode = 31 * hashCode + Objects.hashCode(resultAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInventoryRequest)) {
            return false;
        }
        GetInventoryRequest other = (GetInventoryRequest) obj;
        return Objects.equals(filters(), other.filters()) && Objects.equals(aggregators(), other.aggregators())
                && Objects.equals(resultAttributes(), other.resultAttributes()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (filters() != null) {
            sb.append("Filters: ").append(filters()).append(",");
        }
        if (aggregators() != null) {
            sb.append("Aggregators: ").append(aggregators()).append(",");
        }
        if (resultAttributes() != null) {
            sb.append("ResultAttributes: ").append(resultAttributes()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (maxResults() != null) {
            sb.append("MaxResults: ").append(maxResults()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.of(clazz.cast(filters()));
        case "Aggregators":
            return Optional.of(clazz.cast(aggregators()));
        case "ResultAttributes":
            return Optional.of(clazz.cast(resultAttributes()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.of(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SSMRequest.Builder, CopyableBuilder<Builder, GetInventoryRequest> {
        /**
         * <p>
         * One or more filters. Use a filter to return a more specific list of results.
         * </p>
         * 
         * @param filters
         *        One or more filters. Use a filter to return a more specific list of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<InventoryFilter> filters);

        /**
         * <p>
         * One or more filters. Use a filter to return a more specific list of results.
         * </p>
         * 
         * @param filters
         *        One or more filters. Use a filter to return a more specific list of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(InventoryFilter... filters);

        /**
         * <p>
         * Returns counts of inventory types based on one or more expressions. For example, if you aggregate by using an
         * expression that uses the <code>AWS:InstanceInformation.PlatformType</code> type, you can see a count of how
         * many Windows and Linux instances exist in your inventoried fleet.
         * </p>
         * 
         * @param aggregators
         *        Returns counts of inventory types based on one or more expressions. For example, if you aggregate by
         *        using an expression that uses the <code>AWS:InstanceInformation.PlatformType</code> type, you can see
         *        a count of how many Windows and Linux instances exist in your inventoried fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregators(Collection<InventoryAggregator> aggregators);

        /**
         * <p>
         * Returns counts of inventory types based on one or more expressions. For example, if you aggregate by using an
         * expression that uses the <code>AWS:InstanceInformation.PlatformType</code> type, you can see a count of how
         * many Windows and Linux instances exist in your inventoried fleet.
         * </p>
         * 
         * @param aggregators
         *        Returns counts of inventory types based on one or more expressions. For example, if you aggregate by
         *        using an expression that uses the <code>AWS:InstanceInformation.PlatformType</code> type, you can see
         *        a count of how many Windows and Linux instances exist in your inventoried fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregators(InventoryAggregator... aggregators);

        /**
         * <p>
         * The list of inventory item types to return.
         * </p>
         * 
         * @param resultAttributes
         *        The list of inventory item types to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultAttributes(Collection<ResultAttribute> resultAttributes);

        /**
         * <p>
         * The list of inventory item types to return.
         * </p>
         * 
         * @param resultAttributes
         *        The list of inventory item types to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultAttributes(ResultAttribute... resultAttributes);

        /**
         * <p>
         * The token for the next set of items to return. (You received this token from a previous call.)
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. (You received this token from a previous call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items to return for this call. The call also returns a token that you can specify in a
         * subsequent call to get the next set of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return for this call. The call also returns a token that you can
         *        specify in a subsequent call to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends SSMRequest.BuilderImpl implements Builder {
        private List<InventoryFilter> filters;

        private List<InventoryAggregator> aggregators;

        private List<ResultAttribute> resultAttributes;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInventoryRequest model) {
            filters(model.filters);
            aggregators(model.aggregators);
            resultAttributes(model.resultAttributes);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final Collection<InventoryFilter.Builder> getFilters() {
            return filters != null ? filters.stream().map(InventoryFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<InventoryFilter> filters) {
            this.filters = InventoryFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(InventoryFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<InventoryFilter.BuilderImpl> filters) {
            this.filters = InventoryFilterListCopier.copyFromBuilder(filters);
        }

        public final Collection<InventoryAggregator.Builder> getAggregators() {
            return aggregators != null ? aggregators.stream().map(InventoryAggregator::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder aggregators(Collection<InventoryAggregator> aggregators) {
            this.aggregators = InventoryAggregatorListCopier.copy(aggregators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregators(InventoryAggregator... aggregators) {
            aggregators(Arrays.asList(aggregators));
            return this;
        }

        public final void setAggregators(Collection<InventoryAggregator.BuilderImpl> aggregators) {
            this.aggregators = InventoryAggregatorListCopier.copyFromBuilder(aggregators);
        }

        public final Collection<ResultAttribute.Builder> getResultAttributes() {
            return resultAttributes != null ? resultAttributes.stream().map(ResultAttribute::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resultAttributes(Collection<ResultAttribute> resultAttributes) {
            this.resultAttributes = ResultAttributeListCopier.copy(resultAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultAttributes(ResultAttribute... resultAttributes) {
            resultAttributes(Arrays.asList(resultAttributes));
            return this;
        }

        public final void setResultAttributes(Collection<ResultAttribute.BuilderImpl> resultAttributes) {
            this.resultAttributes = ResultAttributeListCopier.copyFromBuilder(resultAttributes);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetInventoryRequest build() {
            return new GetInventoryRequest(this);
        }
    }
}
