/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetMaintenanceWindowExecutionTaskResponse extends SSMResponse implements
        ToCopyableBuilder<GetMaintenanceWindowExecutionTaskResponse.Builder, GetMaintenanceWindowExecutionTaskResponse> {
    private final String windowExecutionId;

    private final String taskExecutionId;

    private final String taskArn;

    private final String serviceRole;

    private final String type;

    private final List<Map<String, MaintenanceWindowTaskParameterValueExpression>> taskParameters;

    private final Integer priority;

    private final String maxConcurrency;

    private final String maxErrors;

    private final String status;

    private final String statusDetails;

    private final Instant startTime;

    private final Instant endTime;

    private GetMaintenanceWindowExecutionTaskResponse(BuilderImpl builder) {
        super(builder);
        this.windowExecutionId = builder.windowExecutionId;
        this.taskExecutionId = builder.taskExecutionId;
        this.taskArn = builder.taskArn;
        this.serviceRole = builder.serviceRole;
        this.type = builder.type;
        this.taskParameters = builder.taskParameters;
        this.priority = builder.priority;
        this.maxConcurrency = builder.maxConcurrency;
        this.maxErrors = builder.maxErrors;
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    /**
     * <p>
     * The ID of the Maintenance Window execution that includes the task.
     * </p>
     * 
     * @return The ID of the Maintenance Window execution that includes the task.
     */
    public String windowExecutionId() {
        return windowExecutionId;
    }

    /**
     * <p>
     * The ID of the specific task execution in the Maintenance Window task that was retrieved.
     * </p>
     * 
     * @return The ID of the specific task execution in the Maintenance Window task that was retrieved.
     */
    public String taskExecutionId() {
        return taskExecutionId;
    }

    /**
     * <p>
     * The ARN of the executed task.
     * </p>
     * 
     * @return The ARN of the executed task.
     */
    public String taskArn() {
        return taskArn;
    }

    /**
     * <p>
     * The role that was assumed when executing the task.
     * </p>
     * 
     * @return The role that was assumed when executing the task.
     */
    public String serviceRole() {
        return serviceRole;
    }

    /**
     * <p>
     * The type of task executed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link MaintenanceWindowTaskType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return The type of task executed.
     * @see MaintenanceWindowTaskType
     */
    public MaintenanceWindowTaskType type() {
        return MaintenanceWindowTaskType.fromValue(type);
    }

    /**
     * <p>
     * The type of task executed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link MaintenanceWindowTaskType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return The type of task executed.
     * @see MaintenanceWindowTaskType
     */
    public String typeString() {
        return type;
    }

    /**
     * <p>
     * The parameters passed to the task when it was executed. The map has the following format:
     * </p>
     * <p>
     * Key: string, between 1 and 255 characters
     * </p>
     * <p>
     * Value: an array of strings, each string is between 1 and 255 characters
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The parameters passed to the task when it was executed. The map has the following format:</p>
     *         <p>
     *         Key: string, between 1 and 255 characters
     *         </p>
     *         <p>
     *         Value: an array of strings, each string is between 1 and 255 characters
     */
    public List<Map<String, MaintenanceWindowTaskParameterValueExpression>> taskParameters() {
        return taskParameters;
    }

    /**
     * <p>
     * The priority of the task.
     * </p>
     * 
     * @return The priority of the task.
     */
    public Integer priority() {
        return priority;
    }

    /**
     * <p>
     * The defined maximum number of task executions that could be run in parallel.
     * </p>
     * 
     * @return The defined maximum number of task executions that could be run in parallel.
     */
    public String maxConcurrency() {
        return maxConcurrency;
    }

    /**
     * <p>
     * The defined maximum number of task execution errors allowed before scheduling of the task execution would have
     * been stopped.
     * </p>
     * 
     * @return The defined maximum number of task execution errors allowed before scheduling of the task execution would
     *         have been stopped.
     */
    public String maxErrors() {
        return maxErrors;
    }

    /**
     * <p>
     * The status of the task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MaintenanceWindowExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusString}.
     * </p>
     * 
     * @return The status of the task.
     * @see MaintenanceWindowExecutionStatus
     */
    public MaintenanceWindowExecutionStatus status() {
        return MaintenanceWindowExecutionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MaintenanceWindowExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusString}.
     * </p>
     * 
     * @return The status of the task.
     * @see MaintenanceWindowExecutionStatus
     */
    public String statusString() {
        return status;
    }

    /**
     * <p>
     * The details explaining the Status. Only available for certain status values.
     * </p>
     * 
     * @return The details explaining the Status. Only available for certain status values.
     */
    public String statusDetails() {
        return statusDetails;
    }

    /**
     * <p>
     * The time the task execution started.
     * </p>
     * 
     * @return The time the task execution started.
     */
    public Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The time the task execution completed.
     * </p>
     * 
     * @return The time the task execution completed.
     */
    public Instant endTime() {
        return endTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(windowExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(taskExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(taskArn());
        hashCode = 31 * hashCode + Objects.hashCode(serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(typeString());
        hashCode = 31 * hashCode + Objects.hashCode(taskParameters());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(maxConcurrency());
        hashCode = 31 * hashCode + Objects.hashCode(maxErrors());
        hashCode = 31 * hashCode + Objects.hashCode(statusString());
        hashCode = 31 * hashCode + Objects.hashCode(statusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMaintenanceWindowExecutionTaskResponse)) {
            return false;
        }
        GetMaintenanceWindowExecutionTaskResponse other = (GetMaintenanceWindowExecutionTaskResponse) obj;
        return Objects.equals(windowExecutionId(), other.windowExecutionId())
                && Objects.equals(taskExecutionId(), other.taskExecutionId()) && Objects.equals(taskArn(), other.taskArn())
                && Objects.equals(serviceRole(), other.serviceRole()) && Objects.equals(typeString(), other.typeString())
                && Objects.equals(taskParameters(), other.taskParameters()) && Objects.equals(priority(), other.priority())
                && Objects.equals(maxConcurrency(), other.maxConcurrency()) && Objects.equals(maxErrors(), other.maxErrors())
                && Objects.equals(statusString(), other.statusString()) && Objects.equals(statusDetails(), other.statusDetails())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (windowExecutionId() != null) {
            sb.append("WindowExecutionId: ").append(windowExecutionId()).append(",");
        }
        if (taskExecutionId() != null) {
            sb.append("TaskExecutionId: ").append(taskExecutionId()).append(",");
        }
        if (taskArn() != null) {
            sb.append("TaskArn: ").append(taskArn()).append(",");
        }
        if (serviceRole() != null) {
            sb.append("ServiceRole: ").append(serviceRole()).append(",");
        }
        if (typeString() != null) {
            sb.append("Type: ").append(typeString()).append(",");
        }
        if (taskParameters() != null) {
            sb.append("TaskParameters: ").append(taskParameters()).append(",");
        }
        if (priority() != null) {
            sb.append("Priority: ").append(priority()).append(",");
        }
        if (maxConcurrency() != null) {
            sb.append("MaxConcurrency: ").append(maxConcurrency()).append(",");
        }
        if (maxErrors() != null) {
            sb.append("MaxErrors: ").append(maxErrors()).append(",");
        }
        if (statusString() != null) {
            sb.append("Status: ").append(statusString()).append(",");
        }
        if (statusDetails() != null) {
            sb.append("StatusDetails: ").append(statusDetails()).append(",");
        }
        if (startTime() != null) {
            sb.append("StartTime: ").append(startTime()).append(",");
        }
        if (endTime() != null) {
            sb.append("EndTime: ").append(endTime()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WindowExecutionId":
            return Optional.of(clazz.cast(windowExecutionId()));
        case "TaskExecutionId":
            return Optional.of(clazz.cast(taskExecutionId()));
        case "TaskArn":
            return Optional.of(clazz.cast(taskArn()));
        case "ServiceRole":
            return Optional.of(clazz.cast(serviceRole()));
        case "Type":
            return Optional.of(clazz.cast(typeString()));
        case "TaskParameters":
            return Optional.of(clazz.cast(taskParameters()));
        case "Priority":
            return Optional.of(clazz.cast(priority()));
        case "MaxConcurrency":
            return Optional.of(clazz.cast(maxConcurrency()));
        case "MaxErrors":
            return Optional.of(clazz.cast(maxErrors()));
        case "Status":
            return Optional.of(clazz.cast(statusString()));
        case "StatusDetails":
            return Optional.of(clazz.cast(statusDetails()));
        case "StartTime":
            return Optional.of(clazz.cast(startTime()));
        case "EndTime":
            return Optional.of(clazz.cast(endTime()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SSMResponse.Builder, CopyableBuilder<Builder, GetMaintenanceWindowExecutionTaskResponse> {
        /**
         * <p>
         * The ID of the Maintenance Window execution that includes the task.
         * </p>
         * 
         * @param windowExecutionId
         *        The ID of the Maintenance Window execution that includes the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowExecutionId(String windowExecutionId);

        /**
         * <p>
         * The ID of the specific task execution in the Maintenance Window task that was retrieved.
         * </p>
         * 
         * @param taskExecutionId
         *        The ID of the specific task execution in the Maintenance Window task that was retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskExecutionId(String taskExecutionId);

        /**
         * <p>
         * The ARN of the executed task.
         * </p>
         * 
         * @param taskArn
         *        The ARN of the executed task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskArn(String taskArn);

        /**
         * <p>
         * The role that was assumed when executing the task.
         * </p>
         * 
         * @param serviceRole
         *        The role that was assumed when executing the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRole(String serviceRole);

        /**
         * <p>
         * The type of task executed.
         * </p>
         * 
         * @param type
         *        The type of task executed.
         * @see MaintenanceWindowTaskType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceWindowTaskType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of task executed.
         * </p>
         * 
         * @param type
         *        The type of task executed.
         * @see MaintenanceWindowTaskType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceWindowTaskType
         */
        Builder type(MaintenanceWindowTaskType type);

        /**
         * <p>
         * The parameters passed to the task when it was executed. The map has the following format:
         * </p>
         * <p>
         * Key: string, between 1 and 255 characters
         * </p>
         * <p>
         * Value: an array of strings, each string is between 1 and 255 characters
         * </p>
         * 
         * @param taskParameters
         *        The parameters passed to the task when it was executed. The map has the following format:</p>
         *        <p>
         *        Key: string, between 1 and 255 characters
         *        </p>
         *        <p>
         *        Value: an array of strings, each string is between 1 and 255 characters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskParameters(Collection<Map<String, MaintenanceWindowTaskParameterValueExpression>> taskParameters);

        /**
         * <p>
         * The parameters passed to the task when it was executed. The map has the following format:
         * </p>
         * <p>
         * Key: string, between 1 and 255 characters
         * </p>
         * <p>
         * Value: an array of strings, each string is between 1 and 255 characters
         * </p>
         * 
         * @param taskParameters
         *        The parameters passed to the task when it was executed. The map has the following format:</p>
         *        <p>
         *        Key: string, between 1 and 255 characters
         *        </p>
         *        <p>
         *        Value: an array of strings, each string is between 1 and 255 characters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskParameters(Map<String, MaintenanceWindowTaskParameterValueExpression>... taskParameters);

        /**
         * <p>
         * The priority of the task.
         * </p>
         * 
         * @param priority
         *        The priority of the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * The defined maximum number of task executions that could be run in parallel.
         * </p>
         * 
         * @param maxConcurrency
         *        The defined maximum number of task executions that could be run in parallel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxConcurrency(String maxConcurrency);

        /**
         * <p>
         * The defined maximum number of task execution errors allowed before scheduling of the task execution would
         * have been stopped.
         * </p>
         * 
         * @param maxErrors
         *        The defined maximum number of task execution errors allowed before scheduling of the task execution
         *        would have been stopped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxErrors(String maxErrors);

        /**
         * <p>
         * The status of the task.
         * </p>
         * 
         * @param status
         *        The status of the task.
         * @see MaintenanceWindowExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceWindowExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the task.
         * </p>
         * 
         * @param status
         *        The status of the task.
         * @see MaintenanceWindowExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceWindowExecutionStatus
         */
        Builder status(MaintenanceWindowExecutionStatus status);

        /**
         * <p>
         * The details explaining the Status. Only available for certain status values.
         * </p>
         * 
         * @param statusDetails
         *        The details explaining the Status. Only available for certain status values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusDetails(String statusDetails);

        /**
         * <p>
         * The time the task execution started.
         * </p>
         * 
         * @param startTime
         *        The time the task execution started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The time the task execution completed.
         * </p>
         * 
         * @param endTime
         *        The time the task execution completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);
    }

    static final class BuilderImpl extends SSMResponse.BuilderImpl implements Builder {
        private String windowExecutionId;

        private String taskExecutionId;

        private String taskArn;

        private String serviceRole;

        private String type;

        private List<Map<String, MaintenanceWindowTaskParameterValueExpression>> taskParameters;

        private Integer priority;

        private String maxConcurrency;

        private String maxErrors;

        private String status;

        private String statusDetails;

        private Instant startTime;

        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMaintenanceWindowExecutionTaskResponse model) {
            windowExecutionId(model.windowExecutionId);
            taskExecutionId(model.taskExecutionId);
            taskArn(model.taskArn);
            serviceRole(model.serviceRole);
            type(model.type);
            taskParameters(model.taskParameters);
            priority(model.priority);
            maxConcurrency(model.maxConcurrency);
            maxErrors(model.maxErrors);
            status(model.status);
            statusDetails(model.statusDetails);
            startTime(model.startTime);
            endTime(model.endTime);
        }

        public final String getWindowExecutionId() {
            return windowExecutionId;
        }

        @Override
        public final Builder windowExecutionId(String windowExecutionId) {
            this.windowExecutionId = windowExecutionId;
            return this;
        }

        public final void setWindowExecutionId(String windowExecutionId) {
            this.windowExecutionId = windowExecutionId;
        }

        public final String getTaskExecutionId() {
            return taskExecutionId;
        }

        @Override
        public final Builder taskExecutionId(String taskExecutionId) {
            this.taskExecutionId = taskExecutionId;
            return this;
        }

        public final void setTaskExecutionId(String taskExecutionId) {
            this.taskExecutionId = taskExecutionId;
        }

        public final String getTaskArn() {
            return taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        public final String getServiceRole() {
            return serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(MaintenanceWindowTaskType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Collection<Map<String, MaintenanceWindowTaskParameterValueExpression>> getTaskParameters() {
            return taskParameters;
        }

        @Override
        public final Builder taskParameters(Collection<Map<String, MaintenanceWindowTaskParameterValueExpression>> taskParameters) {
            this.taskParameters = MaintenanceWindowTaskParametersListCopier.copy(taskParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskParameters(Map<String, MaintenanceWindowTaskParameterValueExpression>... taskParameters) {
            taskParameters(Arrays.asList(taskParameters));
            return this;
        }

        public final void setTaskParameters(Collection<Map<String, MaintenanceWindowTaskParameterValueExpression>> taskParameters) {
            this.taskParameters = MaintenanceWindowTaskParametersListCopier.copy(taskParameters);
        }

        public final Integer getPriority() {
            return priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public final String getMaxConcurrency() {
            return maxConcurrency;
        }

        @Override
        public final Builder maxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public final void setMaxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
        }

        public final String getMaxErrors() {
            return maxErrors;
        }

        @Override
        public final Builder maxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
            return this;
        }

        public final void setMaxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MaintenanceWindowExecutionStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusDetails() {
            return statusDetails;
        }

        @Override
        public final Builder statusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final void setStatusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public GetMaintenanceWindowExecutionTaskResponse build() {
            return new GetMaintenanceWindowExecutionTaskResponse(this);
        }
    }
}
