/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListComplianceItemsResponse extends SSMResponse implements
        ToCopyableBuilder<ListComplianceItemsResponse.Builder, ListComplianceItemsResponse> {
    private final List<ComplianceItem> complianceItems;

    private final String nextToken;

    private ListComplianceItemsResponse(BuilderImpl builder) {
        super(builder);
        this.complianceItems = builder.complianceItems;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of compliance information for the specified resource ID.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of compliance information for the specified resource ID.
     */
    public List<ComplianceItem> complianceItems() {
        return complianceItems;
    }

    /**
     * <p>
     * The token for the next set of items to return. Use this token to get the next set of results.
     * </p>
     * 
     * @return The token for the next set of items to return. Use this token to get the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(complianceItems());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListComplianceItemsResponse)) {
            return false;
        }
        ListComplianceItemsResponse other = (ListComplianceItemsResponse) obj;
        return Objects.equals(complianceItems(), other.complianceItems()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (complianceItems() != null) {
            sb.append("ComplianceItems: ").append(complianceItems()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComplianceItems":
            return Optional.of(clazz.cast(complianceItems()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SSMResponse.Builder, CopyableBuilder<Builder, ListComplianceItemsResponse> {
        /**
         * <p>
         * A list of compliance information for the specified resource ID.
         * </p>
         * 
         * @param complianceItems
         *        A list of compliance information for the specified resource ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceItems(Collection<ComplianceItem> complianceItems);

        /**
         * <p>
         * A list of compliance information for the specified resource ID.
         * </p>
         * 
         * @param complianceItems
         *        A list of compliance information for the specified resource ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceItems(ComplianceItem... complianceItems);

        /**
         * <p>
         * The token for the next set of items to return. Use this token to get the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. Use this token to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SSMResponse.BuilderImpl implements Builder {
        private List<ComplianceItem> complianceItems;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListComplianceItemsResponse model) {
            complianceItems(model.complianceItems);
            nextToken(model.nextToken);
        }

        public final Collection<ComplianceItem.Builder> getComplianceItems() {
            return complianceItems != null ? complianceItems.stream().map(ComplianceItem::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder complianceItems(Collection<ComplianceItem> complianceItems) {
            this.complianceItems = ComplianceItemListCopier.copy(complianceItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceItems(ComplianceItem... complianceItems) {
            complianceItems(Arrays.asList(complianceItems));
            return this;
        }

        public final void setComplianceItems(Collection<ComplianceItem.BuilderImpl> complianceItems) {
            this.complianceItems = ComplianceItemListCopier.copyFromBuilder(complianceItems);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListComplianceItemsResponse build() {
            return new ListComplianceItemsResponse(this);
        }
    }
}
