/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListDocumentsRequest extends SSMRequest implements
        ToCopyableBuilder<ListDocumentsRequest.Builder, ListDocumentsRequest> {
    private final List<DocumentFilter> documentFilterList;

    private final List<DocumentKeyValuesFilter> filters;

    private final Integer maxResults;

    private final String nextToken;

    private ListDocumentsRequest(BuilderImpl builder) {
        super(builder);
        this.documentFilterList = builder.documentFilterList;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * One or more filters. Use a filter to return a more specific list of results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters. Use a filter to return a more specific list of results.
     */
    public List<DocumentFilter> documentFilterList() {
        return documentFilterList;
    }

    /**
     * <p>
     * One or more filters. Use a filter to return a more specific list of results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters. Use a filter to return a more specific list of results.
     */
    public List<DocumentKeyValuesFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of items to return for this call. The call also returns a token that you can specify in a
     * subsequent call to get the next set of results.
     * </p>
     * 
     * @return The maximum number of items to return for this call. The call also returns a token that you can specify
     *         in a subsequent call to get the next set of results.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next set of items to return. (You received this token from a previous call.)
     * </p>
     * 
     * @return The token for the next set of items to return. (You received this token from a previous call.)
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(documentFilterList());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDocumentsRequest)) {
            return false;
        }
        ListDocumentsRequest other = (ListDocumentsRequest) obj;
        return Objects.equals(documentFilterList(), other.documentFilterList()) && Objects.equals(filters(), other.filters())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (documentFilterList() != null) {
            sb.append("DocumentFilterList: ").append(documentFilterList()).append(",");
        }
        if (filters() != null) {
            sb.append("Filters: ").append(filters()).append(",");
        }
        if (maxResults() != null) {
            sb.append("MaxResults: ").append(maxResults()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DocumentFilterList":
            return Optional.of(clazz.cast(documentFilterList()));
        case "Filters":
            return Optional.of(clazz.cast(filters()));
        case "MaxResults":
            return Optional.of(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SSMRequest.Builder, CopyableBuilder<Builder, ListDocumentsRequest> {
        /**
         * <p>
         * One or more filters. Use a filter to return a more specific list of results.
         * </p>
         * 
         * @param documentFilterList
         *        One or more filters. Use a filter to return a more specific list of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentFilterList(Collection<DocumentFilter> documentFilterList);

        /**
         * <p>
         * One or more filters. Use a filter to return a more specific list of results.
         * </p>
         * 
         * @param documentFilterList
         *        One or more filters. Use a filter to return a more specific list of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentFilterList(DocumentFilter... documentFilterList);

        /**
         * <p>
         * One or more filters. Use a filter to return a more specific list of results.
         * </p>
         * 
         * @param filters
         *        One or more filters. Use a filter to return a more specific list of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<DocumentKeyValuesFilter> filters);

        /**
         * <p>
         * One or more filters. Use a filter to return a more specific list of results.
         * </p>
         * 
         * @param filters
         *        One or more filters. Use a filter to return a more specific list of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(DocumentKeyValuesFilter... filters);

        /**
         * <p>
         * The maximum number of items to return for this call. The call also returns a token that you can specify in a
         * subsequent call to get the next set of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return for this call. The call also returns a token that you can
         *        specify in a subsequent call to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next set of items to return. (You received this token from a previous call.)
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. (You received this token from a previous call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends SSMRequest.BuilderImpl implements Builder {
        private List<DocumentFilter> documentFilterList;

        private List<DocumentKeyValuesFilter> filters;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDocumentsRequest model) {
            documentFilterList(model.documentFilterList);
            filters(model.filters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Collection<DocumentFilter.Builder> getDocumentFilterList() {
            return documentFilterList != null ? documentFilterList.stream().map(DocumentFilter::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder documentFilterList(Collection<DocumentFilter> documentFilterList) {
            this.documentFilterList = DocumentFilterListCopier.copy(documentFilterList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentFilterList(DocumentFilter... documentFilterList) {
            documentFilterList(Arrays.asList(documentFilterList));
            return this;
        }

        public final void setDocumentFilterList(Collection<DocumentFilter.BuilderImpl> documentFilterList) {
            this.documentFilterList = DocumentFilterListCopier.copyFromBuilder(documentFilterList);
        }

        public final Collection<DocumentKeyValuesFilter.Builder> getFilters() {
            return filters != null ? filters.stream().map(DocumentKeyValuesFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<DocumentKeyValuesFilter> filters) {
            this.filters = DocumentKeyValuesFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(DocumentKeyValuesFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<DocumentKeyValuesFilter.BuilderImpl> filters) {
            this.filters = DocumentKeyValuesFilterListCopier.copyFromBuilder(filters);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListDocumentsRequest build() {
            return new ListDocumentsRequest(this);
        }
    }
}
