/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListInventoryEntriesRequest extends SSMRequest implements
        ToCopyableBuilder<ListInventoryEntriesRequest.Builder, ListInventoryEntriesRequest> {
    private final String instanceId;

    private final String typeName;

    private final List<InventoryFilter> filters;

    private final String nextToken;

    private final Integer maxResults;

    private ListInventoryEntriesRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.typeName = builder.typeName;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The instance ID for which you want inventory information.
     * </p>
     * 
     * @return The instance ID for which you want inventory information.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The type of inventory item for which you want information.
     * </p>
     * 
     * @return The type of inventory item for which you want information.
     */
    public String typeName() {
        return typeName;
    }

    /**
     * <p>
     * One or more filters. Use a filter to return a more specific list of results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters. Use a filter to return a more specific list of results.
     */
    public List<InventoryFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * The token for the next set of items to return. (You received this token from a previous call.)
     * </p>
     * 
     * @return The token for the next set of items to return. (You received this token from a previous call.)
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items to return for this call. The call also returns a token that you can specify in a
     * subsequent call to get the next set of results.
     * </p>
     * 
     * @return The maximum number of items to return for this call. The call also returns a token that you can specify
     *         in a subsequent call to get the next set of results.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(typeName());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInventoryEntriesRequest)) {
            return false;
        }
        ListInventoryEntriesRequest other = (ListInventoryEntriesRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(typeName(), other.typeName())
                && Objects.equals(filters(), other.filters()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (typeName() != null) {
            sb.append("TypeName: ").append(typeName()).append(",");
        }
        if (filters() != null) {
            sb.append("Filters: ").append(filters()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (maxResults() != null) {
            sb.append("MaxResults: ").append(maxResults()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.of(clazz.cast(instanceId()));
        case "TypeName":
            return Optional.of(clazz.cast(typeName()));
        case "Filters":
            return Optional.of(clazz.cast(filters()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.of(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SSMRequest.Builder, CopyableBuilder<Builder, ListInventoryEntriesRequest> {
        /**
         * <p>
         * The instance ID for which you want inventory information.
         * </p>
         * 
         * @param instanceId
         *        The instance ID for which you want inventory information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The type of inventory item for which you want information.
         * </p>
         * 
         * @param typeName
         *        The type of inventory item for which you want information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);

        /**
         * <p>
         * One or more filters. Use a filter to return a more specific list of results.
         * </p>
         * 
         * @param filters
         *        One or more filters. Use a filter to return a more specific list of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<InventoryFilter> filters);

        /**
         * <p>
         * One or more filters. Use a filter to return a more specific list of results.
         * </p>
         * 
         * @param filters
         *        One or more filters. Use a filter to return a more specific list of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(InventoryFilter... filters);

        /**
         * <p>
         * The token for the next set of items to return. (You received this token from a previous call.)
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. (You received this token from a previous call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items to return for this call. The call also returns a token that you can specify in a
         * subsequent call to get the next set of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return for this call. The call also returns a token that you can
         *        specify in a subsequent call to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends SSMRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String typeName;

        private List<InventoryFilter> filters;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInventoryEntriesRequest model) {
            instanceId(model.instanceId);
            typeName(model.typeName);
            filters(model.filters);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getTypeName() {
            return typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public final Collection<InventoryFilter.Builder> getFilters() {
            return filters != null ? filters.stream().map(InventoryFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<InventoryFilter> filters) {
            this.filters = InventoryFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(InventoryFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<InventoryFilter.BuilderImpl> filters) {
            this.filters = InventoryFilterListCopier.copyFromBuilder(filters);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListInventoryEntriesRequest build() {
            return new ListInventoryEntriesRequest(this);
        }
    }
}
