/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListResourceComplianceSummariesResponse extends SSMResponse implements
        ToCopyableBuilder<ListResourceComplianceSummariesResponse.Builder, ListResourceComplianceSummariesResponse> {
    private final List<ResourceComplianceSummaryItem> resourceComplianceSummaryItems;

    private final String nextToken;

    private ListResourceComplianceSummariesResponse(BuilderImpl builder) {
        super(builder);
        this.resourceComplianceSummaryItems = builder.resourceComplianceSummaryItems;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A summary count for specified or targeted managed instances. Summary count includes information about compliant
     * and non-compliant State Manager associations, patch status, or custom items according to the filter criteria that
     * you specify.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A summary count for specified or targeted managed instances. Summary count includes information about
     *         compliant and non-compliant State Manager associations, patch status, or custom items according to the
     *         filter criteria that you specify.
     */
    public List<ResourceComplianceSummaryItem> resourceComplianceSummaryItems() {
        return resourceComplianceSummaryItems;
    }

    /**
     * <p>
     * The token for the next set of items to return. Use this token to get the next set of results.
     * </p>
     * 
     * @return The token for the next set of items to return. Use this token to get the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceComplianceSummaryItems());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceComplianceSummariesResponse)) {
            return false;
        }
        ListResourceComplianceSummariesResponse other = (ListResourceComplianceSummariesResponse) obj;
        return Objects.equals(resourceComplianceSummaryItems(), other.resourceComplianceSummaryItems())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (resourceComplianceSummaryItems() != null) {
            sb.append("ResourceComplianceSummaryItems: ").append(resourceComplianceSummaryItems()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceComplianceSummaryItems":
            return Optional.of(clazz.cast(resourceComplianceSummaryItems()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SSMResponse.Builder, CopyableBuilder<Builder, ListResourceComplianceSummariesResponse> {
        /**
         * <p>
         * A summary count for specified or targeted managed instances. Summary count includes information about
         * compliant and non-compliant State Manager associations, patch status, or custom items according to the filter
         * criteria that you specify.
         * </p>
         * 
         * @param resourceComplianceSummaryItems
         *        A summary count for specified or targeted managed instances. Summary count includes information about
         *        compliant and non-compliant State Manager associations, patch status, or custom items according to the
         *        filter criteria that you specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceComplianceSummaryItems(Collection<ResourceComplianceSummaryItem> resourceComplianceSummaryItems);

        /**
         * <p>
         * A summary count for specified or targeted managed instances. Summary count includes information about
         * compliant and non-compliant State Manager associations, patch status, or custom items according to the filter
         * criteria that you specify.
         * </p>
         * 
         * @param resourceComplianceSummaryItems
         *        A summary count for specified or targeted managed instances. Summary count includes information about
         *        compliant and non-compliant State Manager associations, patch status, or custom items according to the
         *        filter criteria that you specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceComplianceSummaryItems(ResourceComplianceSummaryItem... resourceComplianceSummaryItems);

        /**
         * <p>
         * The token for the next set of items to return. Use this token to get the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. Use this token to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SSMResponse.BuilderImpl implements Builder {
        private List<ResourceComplianceSummaryItem> resourceComplianceSummaryItems;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceComplianceSummariesResponse model) {
            resourceComplianceSummaryItems(model.resourceComplianceSummaryItems);
            nextToken(model.nextToken);
        }

        public final Collection<ResourceComplianceSummaryItem.Builder> getResourceComplianceSummaryItems() {
            return resourceComplianceSummaryItems != null ? resourceComplianceSummaryItems.stream()
                    .map(ResourceComplianceSummaryItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceComplianceSummaryItems(
                Collection<ResourceComplianceSummaryItem> resourceComplianceSummaryItems) {
            this.resourceComplianceSummaryItems = ResourceComplianceSummaryItemListCopier.copy(resourceComplianceSummaryItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceComplianceSummaryItems(ResourceComplianceSummaryItem... resourceComplianceSummaryItems) {
            resourceComplianceSummaryItems(Arrays.asList(resourceComplianceSummaryItems));
            return this;
        }

        public final void setResourceComplianceSummaryItems(
                Collection<ResourceComplianceSummaryItem.BuilderImpl> resourceComplianceSummaryItems) {
            this.resourceComplianceSummaryItems = ResourceComplianceSummaryItemListCopier
                    .copyFromBuilder(resourceComplianceSummaryItems);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListResourceComplianceSummariesResponse build() {
            return new ListResourceComplianceSummariesResponse(this);
        }
    }
}
