/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.MaintenanceWindowTaskInvocationParametersMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parameters for task execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class MaintenanceWindowTaskInvocationParameters implements StructuredPojo,
        ToCopyableBuilder<MaintenanceWindowTaskInvocationParameters.Builder, MaintenanceWindowTaskInvocationParameters> {
    private final MaintenanceWindowRunCommandParameters runCommand;

    private final MaintenanceWindowAutomationParameters automation;

    private final MaintenanceWindowStepFunctionsParameters stepFunctions;

    private final MaintenanceWindowLambdaParameters lambda;

    private MaintenanceWindowTaskInvocationParameters(BuilderImpl builder) {
        this.runCommand = builder.runCommand;
        this.automation = builder.automation;
        this.stepFunctions = builder.stepFunctions;
        this.lambda = builder.lambda;
    }

    /**
     * <p>
     * The parameters for a RUN_COMMAND task type.
     * </p>
     * 
     * @return The parameters for a RUN_COMMAND task type.
     */
    public MaintenanceWindowRunCommandParameters runCommand() {
        return runCommand;
    }

    /**
     * <p>
     * The parameters for a AUTOMATION task type.
     * </p>
     * 
     * @return The parameters for a AUTOMATION task type.
     */
    public MaintenanceWindowAutomationParameters automation() {
        return automation;
    }

    /**
     * <p>
     * The parameters for a STEP_FUNCTION task type.
     * </p>
     * 
     * @return The parameters for a STEP_FUNCTION task type.
     */
    public MaintenanceWindowStepFunctionsParameters stepFunctions() {
        return stepFunctions;
    }

    /**
     * <p>
     * The parameters for a LAMBDA task type.
     * </p>
     * 
     * @return The parameters for a LAMBDA task type.
     */
    public MaintenanceWindowLambdaParameters lambda() {
        return lambda;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(runCommand());
        hashCode = 31 * hashCode + Objects.hashCode(automation());
        hashCode = 31 * hashCode + Objects.hashCode(stepFunctions());
        hashCode = 31 * hashCode + Objects.hashCode(lambda());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceWindowTaskInvocationParameters)) {
            return false;
        }
        MaintenanceWindowTaskInvocationParameters other = (MaintenanceWindowTaskInvocationParameters) obj;
        return Objects.equals(runCommand(), other.runCommand()) && Objects.equals(automation(), other.automation())
                && Objects.equals(stepFunctions(), other.stepFunctions()) && Objects.equals(lambda(), other.lambda());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (runCommand() != null) {
            sb.append("RunCommand: ").append(runCommand()).append(",");
        }
        if (automation() != null) {
            sb.append("Automation: ").append(automation()).append(",");
        }
        if (stepFunctions() != null) {
            sb.append("StepFunctions: ").append(stepFunctions()).append(",");
        }
        if (lambda() != null) {
            sb.append("Lambda: ").append(lambda()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RunCommand":
            return Optional.of(clazz.cast(runCommand()));
        case "Automation":
            return Optional.of(clazz.cast(automation()));
        case "StepFunctions":
            return Optional.of(clazz.cast(stepFunctions()));
        case "Lambda":
            return Optional.of(clazz.cast(lambda()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MaintenanceWindowTaskInvocationParametersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, MaintenanceWindowTaskInvocationParameters> {
        /**
         * <p>
         * The parameters for a RUN_COMMAND task type.
         * </p>
         * 
         * @param runCommand
         *        The parameters for a RUN_COMMAND task type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runCommand(MaintenanceWindowRunCommandParameters runCommand);

        /**
         * <p>
         * The parameters for a RUN_COMMAND task type.
         * </p>
         * This is a convenience that creates an instance of the {@link MaintenanceWindowRunCommandParameters.Builder}
         * avoiding the need to create one manually via {@link MaintenanceWindowRunCommandParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link MaintenanceWindowRunCommandParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #runCommand(MaintenanceWindowRunCommandParameters)}.
         * 
         * @param runCommand
         *        a consumer that will call methods on {@link MaintenanceWindowRunCommandParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #runCommand(MaintenanceWindowRunCommandParameters)
         */
        default Builder runCommand(Consumer<MaintenanceWindowRunCommandParameters.Builder> runCommand) {
            return runCommand(MaintenanceWindowRunCommandParameters.builder().apply(runCommand).build());
        }

        /**
         * <p>
         * The parameters for a AUTOMATION task type.
         * </p>
         * 
         * @param automation
         *        The parameters for a AUTOMATION task type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automation(MaintenanceWindowAutomationParameters automation);

        /**
         * <p>
         * The parameters for a AUTOMATION task type.
         * </p>
         * This is a convenience that creates an instance of the {@link MaintenanceWindowAutomationParameters.Builder}
         * avoiding the need to create one manually via {@link MaintenanceWindowAutomationParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link MaintenanceWindowAutomationParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #automation(MaintenanceWindowAutomationParameters)}.
         * 
         * @param automation
         *        a consumer that will call methods on {@link MaintenanceWindowAutomationParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #automation(MaintenanceWindowAutomationParameters)
         */
        default Builder automation(Consumer<MaintenanceWindowAutomationParameters.Builder> automation) {
            return automation(MaintenanceWindowAutomationParameters.builder().apply(automation).build());
        }

        /**
         * <p>
         * The parameters for a STEP_FUNCTION task type.
         * </p>
         * 
         * @param stepFunctions
         *        The parameters for a STEP_FUNCTION task type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepFunctions(MaintenanceWindowStepFunctionsParameters stepFunctions);

        /**
         * <p>
         * The parameters for a STEP_FUNCTION task type.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link MaintenanceWindowStepFunctionsParameters.Builder} avoiding the need to create one manually via
         * {@link MaintenanceWindowStepFunctionsParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link MaintenanceWindowStepFunctionsParameters.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #stepFunctions(MaintenanceWindowStepFunctionsParameters)}.
         * 
         * @param stepFunctions
         *        a consumer that will call methods on {@link MaintenanceWindowStepFunctionsParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stepFunctions(MaintenanceWindowStepFunctionsParameters)
         */
        default Builder stepFunctions(Consumer<MaintenanceWindowStepFunctionsParameters.Builder> stepFunctions) {
            return stepFunctions(MaintenanceWindowStepFunctionsParameters.builder().apply(stepFunctions).build());
        }

        /**
         * <p>
         * The parameters for a LAMBDA task type.
         * </p>
         * 
         * @param lambda
         *        The parameters for a LAMBDA task type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambda(MaintenanceWindowLambdaParameters lambda);

        /**
         * <p>
         * The parameters for a LAMBDA task type.
         * </p>
         * This is a convenience that creates an instance of the {@link MaintenanceWindowLambdaParameters.Builder}
         * avoiding the need to create one manually via {@link MaintenanceWindowLambdaParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link MaintenanceWindowLambdaParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #lambda(MaintenanceWindowLambdaParameters)}.
         * 
         * @param lambda
         *        a consumer that will call methods on {@link MaintenanceWindowLambdaParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambda(MaintenanceWindowLambdaParameters)
         */
        default Builder lambda(Consumer<MaintenanceWindowLambdaParameters.Builder> lambda) {
            return lambda(MaintenanceWindowLambdaParameters.builder().apply(lambda).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private MaintenanceWindowRunCommandParameters runCommand;

        private MaintenanceWindowAutomationParameters automation;

        private MaintenanceWindowStepFunctionsParameters stepFunctions;

        private MaintenanceWindowLambdaParameters lambda;

        private BuilderImpl() {
        }

        private BuilderImpl(MaintenanceWindowTaskInvocationParameters model) {
            runCommand(model.runCommand);
            automation(model.automation);
            stepFunctions(model.stepFunctions);
            lambda(model.lambda);
        }

        public final MaintenanceWindowRunCommandParameters.Builder getRunCommand() {
            return runCommand != null ? runCommand.toBuilder() : null;
        }

        @Override
        public final Builder runCommand(MaintenanceWindowRunCommandParameters runCommand) {
            this.runCommand = runCommand;
            return this;
        }

        public final void setRunCommand(MaintenanceWindowRunCommandParameters.BuilderImpl runCommand) {
            this.runCommand = runCommand != null ? runCommand.build() : null;
        }

        public final MaintenanceWindowAutomationParameters.Builder getAutomation() {
            return automation != null ? automation.toBuilder() : null;
        }

        @Override
        public final Builder automation(MaintenanceWindowAutomationParameters automation) {
            this.automation = automation;
            return this;
        }

        public final void setAutomation(MaintenanceWindowAutomationParameters.BuilderImpl automation) {
            this.automation = automation != null ? automation.build() : null;
        }

        public final MaintenanceWindowStepFunctionsParameters.Builder getStepFunctions() {
            return stepFunctions != null ? stepFunctions.toBuilder() : null;
        }

        @Override
        public final Builder stepFunctions(MaintenanceWindowStepFunctionsParameters stepFunctions) {
            this.stepFunctions = stepFunctions;
            return this;
        }

        public final void setStepFunctions(MaintenanceWindowStepFunctionsParameters.BuilderImpl stepFunctions) {
            this.stepFunctions = stepFunctions != null ? stepFunctions.build() : null;
        }

        public final MaintenanceWindowLambdaParameters.Builder getLambda() {
            return lambda != null ? lambda.toBuilder() : null;
        }

        @Override
        public final Builder lambda(MaintenanceWindowLambdaParameters lambda) {
            this.lambda = lambda;
            return this;
        }

        public final void setLambda(MaintenanceWindowLambdaParameters.BuilderImpl lambda) {
            this.lambda = lambda != null ? lambda.build() : null;
        }

        @Override
        public MaintenanceWindowTaskInvocationParameters build() {
            return new MaintenanceWindowTaskInvocationParameters(this);
        }
    }
}
