/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.PatchRuleGroupMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A set of rules defining the approval rules for a patch baseline.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class PatchRuleGroup implements StructuredPojo, ToCopyableBuilder<PatchRuleGroup.Builder, PatchRuleGroup> {
    private final List<PatchRule> patchRules;

    private PatchRuleGroup(BuilderImpl builder) {
        this.patchRules = builder.patchRules;
    }

    /**
     * <p>
     * The rules that make up the rule group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The rules that make up the rule group.
     */
    public List<PatchRule> patchRules() {
        return patchRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(patchRules());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PatchRuleGroup)) {
            return false;
        }
        PatchRuleGroup other = (PatchRuleGroup) obj;
        return Objects.equals(patchRules(), other.patchRules());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (patchRules() != null) {
            sb.append("PatchRules: ").append(patchRules()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PatchRules":
            return Optional.of(clazz.cast(patchRules()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PatchRuleGroupMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, PatchRuleGroup> {
        /**
         * <p>
         * The rules that make up the rule group.
         * </p>
         * 
         * @param patchRules
         *        The rules that make up the rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patchRules(Collection<PatchRule> patchRules);

        /**
         * <p>
         * The rules that make up the rule group.
         * </p>
         * 
         * @param patchRules
         *        The rules that make up the rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patchRules(PatchRule... patchRules);
    }

    static final class BuilderImpl implements Builder {
        private List<PatchRule> patchRules;

        private BuilderImpl() {
        }

        private BuilderImpl(PatchRuleGroup model) {
            patchRules(model.patchRules);
        }

        public final Collection<PatchRule.Builder> getPatchRules() {
            return patchRules != null ? patchRules.stream().map(PatchRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder patchRules(Collection<PatchRule> patchRules) {
            this.patchRules = PatchRuleListCopier.copy(patchRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patchRules(PatchRule... patchRules) {
            patchRules(Arrays.asList(patchRules));
            return this;
        }

        public final void setPatchRules(Collection<PatchRule.BuilderImpl> patchRules) {
            this.patchRules = PatchRuleListCopier.copyFromBuilder(patchRules);
        }

        @Override
        public PatchRuleGroup build() {
            return new PatchRuleGroup(this);
        }
    }
}
