/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PutInventoryRequest extends SSMRequest implements
        ToCopyableBuilder<PutInventoryRequest.Builder, PutInventoryRequest> {
    private final String instanceId;

    private final List<InventoryItem> items;

    private PutInventoryRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.items = builder.items;
    }

    /**
     * <p>
     * One or more instance IDs where you want to add or update inventory items.
     * </p>
     * 
     * @return One or more instance IDs where you want to add or update inventory items.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The inventory items that you want to add or update on instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The inventory items that you want to add or update on instances.
     */
    public List<InventoryItem> items() {
        return items;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(items());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutInventoryRequest)) {
            return false;
        }
        PutInventoryRequest other = (PutInventoryRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(items(), other.items());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (items() != null) {
            sb.append("Items: ").append(items()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.of(clazz.cast(instanceId()));
        case "Items":
            return Optional.of(clazz.cast(items()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SSMRequest.Builder, CopyableBuilder<Builder, PutInventoryRequest> {
        /**
         * <p>
         * One or more instance IDs where you want to add or update inventory items.
         * </p>
         * 
         * @param instanceId
         *        One or more instance IDs where you want to add or update inventory items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The inventory items that you want to add or update on instances.
         * </p>
         * 
         * @param items
         *        The inventory items that you want to add or update on instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<InventoryItem> items);

        /**
         * <p>
         * The inventory items that you want to add or update on instances.
         * </p>
         * 
         * @param items
         *        The inventory items that you want to add or update on instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(InventoryItem... items);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends SSMRequest.BuilderImpl implements Builder {
        private String instanceId;

        private List<InventoryItem> items;

        private BuilderImpl() {
        }

        private BuilderImpl(PutInventoryRequest model) {
            instanceId(model.instanceId);
            items(model.items);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Collection<InventoryItem.Builder> getItems() {
            return items != null ? items.stream().map(InventoryItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder items(Collection<InventoryItem> items) {
            this.items = InventoryItemListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(InventoryItem... items) {
            items(Arrays.asList(items));
            return this;
        }

        public final void setItems(Collection<InventoryItem.BuilderImpl> items) {
            this.items = InventoryItemListCopier.copyFromBuilder(items);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public PutInventoryRequest build() {
            return new PutInventoryRequest(this);
        }
    }
}
