/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PutParameterRequest extends SSMRequest implements
        ToCopyableBuilder<PutParameterRequest.Builder, PutParameterRequest> {
    private final String name;

    private final String description;

    private final String value;

    private final String type;

    private final String keyId;

    private final Boolean overwrite;

    private final String allowedPattern;

    private PutParameterRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.value = builder.value;
        this.type = builder.type;
        this.keyId = builder.keyId;
        this.overwrite = builder.overwrite;
        this.allowedPattern = builder.allowedPattern;
    }

    /**
     * <p>
     * The fully qualified name of the parameter that you want to add to the system. The fully qualified name includes
     * the complete hierarchy of the parameter path and name. For example: <code>/Dev/DBServer/MySQL/db-string13</code>
     * </p>
     * <note>
     * <p>
     * The maximum length constraint listed below includes capacity for additional system attributes that are not part
     * of the name. The maximum length for the fully qualified parameter name is 1011 characters.
     * </p>
     * </note>
     * 
     * @return The fully qualified name of the parameter that you want to add to the system. The fully qualified name
     *         includes the complete hierarchy of the parameter path and name. For example:
     *         <code>/Dev/DBServer/MySQL/db-string13</code> </p> <note>
     *         <p>
     *         The maximum length constraint listed below includes capacity for additional system attributes that are
     *         not part of the name. The maximum length for the fully qualified parameter name is 1011 characters.
     *         </p>
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * Information about the parameter that you want to add to the system.
     * </p>
     * 
     * @return Information about the parameter that you want to add to the system.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The parameter value that you want to add to the system.
     * </p>
     * 
     * @return The parameter value that you want to add to the system.
     */
    public String value() {
        return value;
    }

    /**
     * <p>
     * The type of parameter that you want to add to the system.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ParameterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return The type of parameter that you want to add to the system.
     * @see ParameterType
     */
    public ParameterType type() {
        return ParameterType.fromValue(type);
    }

    /**
     * <p>
     * The type of parameter that you want to add to the system.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ParameterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return The type of parameter that you want to add to the system.
     * @see ParameterType
     */
    public String typeString() {
        return type;
    }

    /**
     * <p>
     * The KMS Key ID that you want to use to encrypt a parameter when you choose the SecureString data type. If you
     * don't specify a key ID, the system uses the default key associated with your AWS account.
     * </p>
     * 
     * @return The KMS Key ID that you want to use to encrypt a parameter when you choose the SecureString data type. If
     *         you don't specify a key ID, the system uses the default key associated with your AWS account.
     */
    public String keyId() {
        return keyId;
    }

    /**
     * <p>
     * Overwrite an existing parameter. If not specified, will default to "false".
     * </p>
     * 
     * @return Overwrite an existing parameter. If not specified, will default to "false".
     */
    public Boolean overwrite() {
        return overwrite;
    }

    /**
     * <p>
     * A regular expression used to validate the parameter value. For example, for String types with values restricted
     * to numbers, you can specify the following: AllowedPattern=^\d+$
     * </p>
     * 
     * @return A regular expression used to validate the parameter value. For example, for String types with values
     *         restricted to numbers, you can specify the following: AllowedPattern=^\d+$
     */
    public String allowedPattern() {
        return allowedPattern;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(typeString());
        hashCode = 31 * hashCode + Objects.hashCode(keyId());
        hashCode = 31 * hashCode + Objects.hashCode(overwrite());
        hashCode = 31 * hashCode + Objects.hashCode(allowedPattern());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutParameterRequest)) {
            return false;
        }
        PutParameterRequest other = (PutParameterRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(value(), other.value()) && Objects.equals(typeString(), other.typeString())
                && Objects.equals(keyId(), other.keyId()) && Objects.equals(overwrite(), other.overwrite())
                && Objects.equals(allowedPattern(), other.allowedPattern());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (value() != null) {
            sb.append("Value: ").append(value()).append(",");
        }
        if (typeString() != null) {
            sb.append("Type: ").append(typeString()).append(",");
        }
        if (keyId() != null) {
            sb.append("KeyId: ").append(keyId()).append(",");
        }
        if (overwrite() != null) {
            sb.append("Overwrite: ").append(overwrite()).append(",");
        }
        if (allowedPattern() != null) {
            sb.append("AllowedPattern: ").append(allowedPattern()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "Value":
            return Optional.of(clazz.cast(value()));
        case "Type":
            return Optional.of(clazz.cast(typeString()));
        case "KeyId":
            return Optional.of(clazz.cast(keyId()));
        case "Overwrite":
            return Optional.of(clazz.cast(overwrite()));
        case "AllowedPattern":
            return Optional.of(clazz.cast(allowedPattern()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SSMRequest.Builder, CopyableBuilder<Builder, PutParameterRequest> {
        /**
         * <p>
         * The fully qualified name of the parameter that you want to add to the system. The fully qualified name
         * includes the complete hierarchy of the parameter path and name. For example:
         * <code>/Dev/DBServer/MySQL/db-string13</code>
         * </p>
         * <note>
         * <p>
         * The maximum length constraint listed below includes capacity for additional system attributes that are not
         * part of the name. The maximum length for the fully qualified parameter name is 1011 characters.
         * </p>
         * </note>
         * 
         * @param name
         *        The fully qualified name of the parameter that you want to add to the system. The fully qualified name
         *        includes the complete hierarchy of the parameter path and name. For example:
         *        <code>/Dev/DBServer/MySQL/db-string13</code> </p> <note>
         *        <p>
         *        The maximum length constraint listed below includes capacity for additional system attributes that are
         *        not part of the name. The maximum length for the fully qualified parameter name is 1011 characters.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Information about the parameter that you want to add to the system.
         * </p>
         * 
         * @param description
         *        Information about the parameter that you want to add to the system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The parameter value that you want to add to the system.
         * </p>
         * 
         * @param value
         *        The parameter value that you want to add to the system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * The type of parameter that you want to add to the system.
         * </p>
         * 
         * @param type
         *        The type of parameter that you want to add to the system.
         * @see ParameterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParameterType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of parameter that you want to add to the system.
         * </p>
         * 
         * @param type
         *        The type of parameter that you want to add to the system.
         * @see ParameterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParameterType
         */
        Builder type(ParameterType type);

        /**
         * <p>
         * The KMS Key ID that you want to use to encrypt a parameter when you choose the SecureString data type. If you
         * don't specify a key ID, the system uses the default key associated with your AWS account.
         * </p>
         * 
         * @param keyId
         *        The KMS Key ID that you want to use to encrypt a parameter when you choose the SecureString data type.
         *        If you don't specify a key ID, the system uses the default key associated with your AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyId(String keyId);

        /**
         * <p>
         * Overwrite an existing parameter. If not specified, will default to "false".
         * </p>
         * 
         * @param overwrite
         *        Overwrite an existing parameter. If not specified, will default to "false".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overwrite(Boolean overwrite);

        /**
         * <p>
         * A regular expression used to validate the parameter value. For example, for String types with values
         * restricted to numbers, you can specify the following: AllowedPattern=^\d+$
         * </p>
         * 
         * @param allowedPattern
         *        A regular expression used to validate the parameter value. For example, for String types with values
         *        restricted to numbers, you can specify the following: AllowedPattern=^\d+$
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedPattern(String allowedPattern);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends SSMRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private String value;

        private String type;

        private String keyId;

        private Boolean overwrite;

        private String allowedPattern;

        private BuilderImpl() {
        }

        private BuilderImpl(PutParameterRequest model) {
            name(model.name);
            description(model.description);
            value(model.value);
            type(model.type);
            keyId(model.keyId);
            overwrite(model.overwrite);
            allowedPattern(model.allowedPattern);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ParameterType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getKeyId() {
            return keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final Boolean getOverwrite() {
            return overwrite;
        }

        @Override
        public final Builder overwrite(Boolean overwrite) {
            this.overwrite = overwrite;
            return this;
        }

        public final void setOverwrite(Boolean overwrite) {
            this.overwrite = overwrite;
        }

        public final String getAllowedPattern() {
            return allowedPattern;
        }

        @Override
        public final Builder allowedPattern(String allowedPattern) {
            this.allowedPattern = allowedPattern;
            return this;
        }

        public final void setAllowedPattern(String allowedPattern) {
            this.allowedPattern = allowedPattern;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public PutParameterRequest build() {
            return new PutParameterRequest(this);
        }
    }
}
