/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A sync configuration with the same name already exists.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ResourceDataSyncAlreadyExistsException extends SSMException implements
        ToCopyableBuilder<ResourceDataSyncAlreadyExistsException.Builder, ResourceDataSyncAlreadyExistsException> {
    private final String syncName;

    private ResourceDataSyncAlreadyExistsException(BuilderImpl builder) {
        super(builder.message);
        this.syncName = builder.syncName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Returns the value of the SyncName property for this object.
     * 
     * @return The value of the SyncName property for this object.
     */
    public String syncName() {
        return syncName;
    }

    public interface Builder extends CopyableBuilder<Builder, ResourceDataSyncAlreadyExistsException> {
        /**
         * Sets the value of the SyncName property for this object.
         *
         * @param syncName
         *        The new value for the SyncName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syncName(String syncName);

        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String syncName;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceDataSyncAlreadyExistsException model) {
            syncName(model.syncName);
            this.message = model.getMessage();
        }

        public final String getSyncName() {
            return syncName;
        }

        @Override
        public final Builder syncName(String syncName) {
            this.syncName = syncName;
            return this;
        }

        @JsonProperty("SyncName")
        public final void setSyncName(String syncName) {
            this.syncName = syncName;
        }

        public String getMessage() {
            return message;
        }

        public String message() {
            return message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public ResourceDataSyncAlreadyExistsException build() {
            return new ResourceDataSyncAlreadyExistsException(this);
        }
    }
}
