/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateDocumentDefaultVersionResponse extends SSMResponse implements
        ToCopyableBuilder<UpdateDocumentDefaultVersionResponse.Builder, UpdateDocumentDefaultVersionResponse> {
    private final DocumentDefaultVersionDescription description;

    private UpdateDocumentDefaultVersionResponse(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
    }

    /**
     * <p>
     * The description of a custom document that you want to set as the default version.
     * </p>
     * 
     * @return The description of a custom document that you want to set as the default version.
     */
    public DocumentDefaultVersionDescription description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDocumentDefaultVersionResponse)) {
            return false;
        }
        UpdateDocumentDefaultVersionResponse other = (UpdateDocumentDefaultVersionResponse) obj;
        return Objects.equals(description(), other.description());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.of(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SSMResponse.Builder, CopyableBuilder<Builder, UpdateDocumentDefaultVersionResponse> {
        /**
         * <p>
         * The description of a custom document that you want to set as the default version.
         * </p>
         * 
         * @param description
         *        The description of a custom document that you want to set as the default version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(DocumentDefaultVersionDescription description);

        /**
         * <p>
         * The description of a custom document that you want to set as the default version.
         * </p>
         * This is a convenience that creates an instance of the {@link DocumentDefaultVersionDescription.Builder}
         * avoiding the need to create one manually via {@link DocumentDefaultVersionDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link DocumentDefaultVersionDescription.Builder#build()} is called
         * immediately and its result is passed to {@link #description(DocumentDefaultVersionDescription)}.
         * 
         * @param description
         *        a consumer that will call methods on {@link DocumentDefaultVersionDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #description(DocumentDefaultVersionDescription)
         */
        default Builder description(Consumer<DocumentDefaultVersionDescription.Builder> description) {
            return description(DocumentDefaultVersionDescription.builder().apply(description).build());
        }
    }

    static final class BuilderImpl extends SSMResponse.BuilderImpl implements Builder {
        private DocumentDefaultVersionDescription description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDocumentDefaultVersionResponse model) {
            description(model.description);
        }

        public final DocumentDefaultVersionDescription.Builder getDescription() {
            return description != null ? description.toBuilder() : null;
        }

        @Override
        public final Builder description(DocumentDefaultVersionDescription description) {
            this.description = description;
            return this;
        }

        public final void setDescription(DocumentDefaultVersionDescription.BuilderImpl description) {
            this.description = description != null ? description.build() : null;
        }

        @Override
        public UpdateDocumentDefaultVersionResponse build() {
            return new UpdateDocumentDefaultVersionResponse(this);
        }
    }
}
