/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateMaintenanceWindowTargetResponse extends SSMResponse implements
        ToCopyableBuilder<UpdateMaintenanceWindowTargetResponse.Builder, UpdateMaintenanceWindowTargetResponse> {
    private final String windowId;

    private final String windowTargetId;

    private final List<Target> targets;

    private final String ownerInformation;

    private final String name;

    private final String description;

    private UpdateMaintenanceWindowTargetResponse(BuilderImpl builder) {
        super(builder);
        this.windowId = builder.windowId;
        this.windowTargetId = builder.windowTargetId;
        this.targets = builder.targets;
        this.ownerInformation = builder.ownerInformation;
        this.name = builder.name;
        this.description = builder.description;
    }

    /**
     * <p>
     * The Maintenance Window ID specified in the update request.
     * </p>
     * 
     * @return The Maintenance Window ID specified in the update request.
     */
    public String windowId() {
        return windowId;
    }

    /**
     * <p>
     * The target ID specified in the update request.
     * </p>
     * 
     * @return The target ID specified in the update request.
     */
    public String windowTargetId() {
        return windowTargetId;
    }

    /**
     * <p>
     * The updated targets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The updated targets.
     */
    public List<Target> targets() {
        return targets;
    }

    /**
     * <p>
     * The updated owner.
     * </p>
     * 
     * @return The updated owner.
     */
    public String ownerInformation() {
        return ownerInformation;
    }

    /**
     * <p>
     * The updated name.
     * </p>
     * 
     * @return The updated name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The updated description.
     * </p>
     * 
     * @return The updated description.
     */
    public String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(windowId());
        hashCode = 31 * hashCode + Objects.hashCode(windowTargetId());
        hashCode = 31 * hashCode + Objects.hashCode(targets());
        hashCode = 31 * hashCode + Objects.hashCode(ownerInformation());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMaintenanceWindowTargetResponse)) {
            return false;
        }
        UpdateMaintenanceWindowTargetResponse other = (UpdateMaintenanceWindowTargetResponse) obj;
        return Objects.equals(windowId(), other.windowId()) && Objects.equals(windowTargetId(), other.windowTargetId())
                && Objects.equals(targets(), other.targets()) && Objects.equals(ownerInformation(), other.ownerInformation())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (windowId() != null) {
            sb.append("WindowId: ").append(windowId()).append(",");
        }
        if (windowTargetId() != null) {
            sb.append("WindowTargetId: ").append(windowTargetId()).append(",");
        }
        if (targets() != null) {
            sb.append("Targets: ").append(targets()).append(",");
        }
        if (ownerInformation() != null) {
            sb.append("OwnerInformation: ").append(ownerInformation()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WindowId":
            return Optional.of(clazz.cast(windowId()));
        case "WindowTargetId":
            return Optional.of(clazz.cast(windowTargetId()));
        case "Targets":
            return Optional.of(clazz.cast(targets()));
        case "OwnerInformation":
            return Optional.of(clazz.cast(ownerInformation()));
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SSMResponse.Builder, CopyableBuilder<Builder, UpdateMaintenanceWindowTargetResponse> {
        /**
         * <p>
         * The Maintenance Window ID specified in the update request.
         * </p>
         * 
         * @param windowId
         *        The Maintenance Window ID specified in the update request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowId(String windowId);

        /**
         * <p>
         * The target ID specified in the update request.
         * </p>
         * 
         * @param windowTargetId
         *        The target ID specified in the update request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowTargetId(String windowTargetId);

        /**
         * <p>
         * The updated targets.
         * </p>
         * 
         * @param targets
         *        The updated targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Collection<Target> targets);

        /**
         * <p>
         * The updated targets.
         * </p>
         * 
         * @param targets
         *        The updated targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Target... targets);

        /**
         * <p>
         * The updated owner.
         * </p>
         * 
         * @param ownerInformation
         *        The updated owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerInformation(String ownerInformation);

        /**
         * <p>
         * The updated name.
         * </p>
         * 
         * @param name
         *        The updated name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The updated description.
         * </p>
         * 
         * @param description
         *        The updated description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl extends SSMResponse.BuilderImpl implements Builder {
        private String windowId;

        private String windowTargetId;

        private List<Target> targets;

        private String ownerInformation;

        private String name;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMaintenanceWindowTargetResponse model) {
            windowId(model.windowId);
            windowTargetId(model.windowTargetId);
            targets(model.targets);
            ownerInformation(model.ownerInformation);
            name(model.name);
            description(model.description);
        }

        public final String getWindowId() {
            return windowId;
        }

        @Override
        public final Builder windowId(String windowId) {
            this.windowId = windowId;
            return this;
        }

        public final void setWindowId(String windowId) {
            this.windowId = windowId;
        }

        public final String getWindowTargetId() {
            return windowTargetId;
        }

        @Override
        public final Builder windowTargetId(String windowTargetId) {
            this.windowTargetId = windowTargetId;
            return this;
        }

        public final void setWindowTargetId(String windowTargetId) {
            this.windowTargetId = windowTargetId;
        }

        public final Collection<Target.Builder> getTargets() {
            return targets != null ? targets.stream().map(Target::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target... targets) {
            targets(Arrays.asList(targets));
            return this;
        }

        public final void setTargets(Collection<Target.BuilderImpl> targets) {
            this.targets = TargetsCopier.copyFromBuilder(targets);
        }

        public final String getOwnerInformation() {
            return ownerInformation;
        }

        @Override
        public final Builder ownerInformation(String ownerInformation) {
            this.ownerInformation = ownerInformation;
            return this;
        }

        public final void setOwnerInformation(String ownerInformation) {
            this.ownerInformation = ownerInformation;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public UpdateMaintenanceWindowTargetResponse build() {
            return new UpdateMaintenanceWindowTargetResponse(this);
        }
    }
}
