/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.transform;

import java.util.List;
import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.ssm.model.*;

import software.amazon.awssdk.core.protocol.*;
import software.amazon.awssdk.annotations.SdkInternalApi;

/**
 * CommandInvocationMarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class CommandInvocationMarshaller {

    private static final MarshallingInfo<String> COMMANDID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CommandId").build();
    private static final MarshallingInfo<String> INSTANCEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceId").build();
    private static final MarshallingInfo<String> INSTANCENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceName").build();
    private static final MarshallingInfo<String> COMMENT_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Comment").build();
    private static final MarshallingInfo<String> DOCUMENTNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentName").build();
    private static final MarshallingInfo<java.time.Instant> REQUESTEDDATETIME_BINDING = MarshallingInfo
            .builder(MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("RequestedDateTime").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<String> STATUSDETAILS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StatusDetails").build();
    private static final MarshallingInfo<String> TRACEOUTPUT_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TraceOutput").build();
    private static final MarshallingInfo<String> STANDARDOUTPUTURL_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StandardOutputUrl").build();
    private static final MarshallingInfo<String> STANDARDERRORURL_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StandardErrorUrl").build();
    private static final MarshallingInfo<List> COMMANDPLUGINS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CommandPlugins").build();
    private static final MarshallingInfo<String> SERVICEROLE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceRole").build();
    private static final MarshallingInfo<StructuredPojo> NOTIFICATIONCONFIG_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("NotificationConfig").build();

    private static final CommandInvocationMarshaller INSTANCE = new CommandInvocationMarshaller();

    public static CommandInvocationMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(CommandInvocation commandInvocation, ProtocolMarshaller protocolMarshaller) {

        if (commandInvocation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {

            protocolMarshaller.marshall(commandInvocation.commandId(), COMMANDID_BINDING);

            protocolMarshaller.marshall(commandInvocation.instanceId(), INSTANCEID_BINDING);

            protocolMarshaller.marshall(commandInvocation.instanceName(), INSTANCENAME_BINDING);

            protocolMarshaller.marshall(commandInvocation.comment(), COMMENT_BINDING);

            protocolMarshaller.marshall(commandInvocation.documentName(), DOCUMENTNAME_BINDING);

            protocolMarshaller.marshall(commandInvocation.requestedDateTime(), REQUESTEDDATETIME_BINDING);

            protocolMarshaller.marshall(commandInvocation.statusString(), STATUS_BINDING);

            protocolMarshaller.marshall(commandInvocation.statusDetails(), STATUSDETAILS_BINDING);

            protocolMarshaller.marshall(commandInvocation.traceOutput(), TRACEOUTPUT_BINDING);

            protocolMarshaller.marshall(commandInvocation.standardOutputUrl(), STANDARDOUTPUTURL_BINDING);

            protocolMarshaller.marshall(commandInvocation.standardErrorUrl(), STANDARDERRORURL_BINDING);

            protocolMarshaller.marshall(commandInvocation.commandPlugins(), COMMANDPLUGINS_BINDING);

            protocolMarshaller.marshall(commandInvocation.serviceRole(), SERVICEROLE_BINDING);

            protocolMarshaller.marshall(commandInvocation.notificationConfig(), NOTIFICATIONCONFIG_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
