/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.ssm.model.*;

import software.amazon.awssdk.core.protocol.*;
import software.amazon.awssdk.annotations.SdkInternalApi;

/**
 * ResourceDataSyncItemMarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class ResourceDataSyncItemMarshaller {

    private static final MarshallingInfo<String> SYNCNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SyncName").build();
    private static final MarshallingInfo<StructuredPojo> S3DESTINATION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Destination")
            .build();
    private static final MarshallingInfo<java.time.Instant> LASTSYNCTIME_BINDING = MarshallingInfo
            .builder(MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastSyncTime")
            .build();
    private static final MarshallingInfo<java.time.Instant> LASTSUCCESSFULSYNCTIME_BINDING = MarshallingInfo
            .builder(MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("LastSuccessfulSyncTime").build();
    private static final MarshallingInfo<String> LASTSTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastStatus").build();
    private static final MarshallingInfo<java.time.Instant> SYNCCREATEDTIME_BINDING = MarshallingInfo
            .builder(MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SyncCreatedTime")
            .build();

    private static final ResourceDataSyncItemMarshaller INSTANCE = new ResourceDataSyncItemMarshaller();

    public static ResourceDataSyncItemMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(ResourceDataSyncItem resourceDataSyncItem, ProtocolMarshaller protocolMarshaller) {

        if (resourceDataSyncItem == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {

            protocolMarshaller.marshall(resourceDataSyncItem.syncName(), SYNCNAME_BINDING);

            protocolMarshaller.marshall(resourceDataSyncItem.s3Destination(), S3DESTINATION_BINDING);

            protocolMarshaller.marshall(resourceDataSyncItem.lastSyncTime(), LASTSYNCTIME_BINDING);

            protocolMarshaller.marshall(resourceDataSyncItem.lastSuccessfulSyncTime(), LASTSUCCESSFULSYNCTIME_BINDING);

            protocolMarshaller.marshall(resourceDataSyncItem.lastStatusString(), LASTSTATUS_BINDING);

            protocolMarshaller.marshall(resourceDataSyncItem.syncCreatedTime(), SYNCCREATEDTIME_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
