/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.ssm.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * UpdateMaintenanceWindowTaskResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class UpdateMaintenanceWindowTaskResponseUnmarshaller implements
        Unmarshaller<UpdateMaintenanceWindowTaskResponse, JsonUnmarshallerContext> {

    public UpdateMaintenanceWindowTaskResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        UpdateMaintenanceWindowTaskResponse.Builder updateMaintenanceWindowTaskResponseBuilder = UpdateMaintenanceWindowTaskResponse
                .builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return updateMaintenanceWindowTaskResponseBuilder.build();
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("WindowId", targetDepth)) {
                    context.nextToken();
                    updateMaintenanceWindowTaskResponseBuilder
                            .windowId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("WindowTaskId", targetDepth)) {
                    context.nextToken();
                    updateMaintenanceWindowTaskResponseBuilder.windowTaskId(context.getUnmarshaller(String.class).unmarshall(
                            context));
                }
                if (context.testExpression("Targets", targetDepth)) {
                    context.nextToken();
                    updateMaintenanceWindowTaskResponseBuilder.targets(new ListUnmarshaller<Target>(TargetUnmarshaller
                            .getInstance()).unmarshall(context));
                }
                if (context.testExpression("TaskArn", targetDepth)) {
                    context.nextToken();
                    updateMaintenanceWindowTaskResponseBuilder.taskArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ServiceRoleArn", targetDepth)) {
                    context.nextToken();
                    updateMaintenanceWindowTaskResponseBuilder.serviceRoleArn(context.getUnmarshaller(String.class).unmarshall(
                            context));
                }
                if (context.testExpression("TaskParameters", targetDepth)) {
                    context.nextToken();
                    updateMaintenanceWindowTaskResponseBuilder
                            .taskParameters(new MapUnmarshaller<String, MaintenanceWindowTaskParameterValueExpression>(context
                                    .getUnmarshaller(String.class), MaintenanceWindowTaskParameterValueExpressionUnmarshaller
                                    .getInstance()).unmarshall(context));
                }
                if (context.testExpression("TaskInvocationParameters", targetDepth)) {
                    context.nextToken();
                    updateMaintenanceWindowTaskResponseBuilder
                            .taskInvocationParameters(MaintenanceWindowTaskInvocationParametersUnmarshaller.getInstance()
                                    .unmarshall(context));
                }
                if (context.testExpression("Priority", targetDepth)) {
                    context.nextToken();
                    updateMaintenanceWindowTaskResponseBuilder.priority(context.getUnmarshaller(Integer.class)
                            .unmarshall(context));
                }
                if (context.testExpression("MaxConcurrency", targetDepth)) {
                    context.nextToken();
                    updateMaintenanceWindowTaskResponseBuilder.maxConcurrency(context.getUnmarshaller(String.class).unmarshall(
                            context));
                }
                if (context.testExpression("MaxErrors", targetDepth)) {
                    context.nextToken();
                    updateMaintenanceWindowTaskResponseBuilder.maxErrors(context.getUnmarshaller(String.class)
                            .unmarshall(context));
                }
                if (context.testExpression("LoggingInfo", targetDepth)) {
                    context.nextToken();
                    updateMaintenanceWindowTaskResponseBuilder.loggingInfo(LoggingInfoUnmarshaller.getInstance().unmarshall(
                            context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    updateMaintenanceWindowTaskResponseBuilder.name(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Description", targetDepth)) {
                    context.nextToken();
                    updateMaintenanceWindowTaskResponseBuilder.description(context.getUnmarshaller(String.class).unmarshall(
                            context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return updateMaintenanceWindowTaskResponseBuilder.build();
    }

    private static final UpdateMaintenanceWindowTaskResponseUnmarshaller INSTANCE = new UpdateMaintenanceWindowTaskResponseUnmarshaller();

    public static UpdateMaintenanceWindowTaskResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
