/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ssm.model.SSMResponse;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetDeployablePatchSnapshotForInstanceResponse
extends SSMResponse
implements ToCopyableBuilder<Builder, GetDeployablePatchSnapshotForInstanceResponse> {
    private final String instanceId;
    private final String snapshotId;
    private final String snapshotDownloadUrl;
    private final String product;

    private GetDeployablePatchSnapshotForInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.snapshotId = builder.snapshotId;
        this.snapshotDownloadUrl = builder.snapshotDownloadUrl;
        this.product = builder.product;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String snapshotId() {
        return this.snapshotId;
    }

    public String snapshotDownloadUrl() {
        return this.snapshotDownloadUrl;
    }

    public String product() {
        return this.product;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotDownloadUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.product());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeployablePatchSnapshotForInstanceResponse)) {
            return false;
        }
        GetDeployablePatchSnapshotForInstanceResponse other = (GetDeployablePatchSnapshotForInstanceResponse)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.snapshotId(), other.snapshotId()) && Objects.equals(this.snapshotDownloadUrl(), other.snapshotDownloadUrl()) && Objects.equals(this.product(), other.product());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.snapshotId() != null) {
            sb.append("SnapshotId: ").append(this.snapshotId()).append(",");
        }
        if (this.snapshotDownloadUrl() != null) {
            sb.append("SnapshotDownloadUrl: ").append(this.snapshotDownloadUrl()).append(",");
        }
        if (this.product() != null) {
            sb.append("Product: ").append(this.product()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "SnapshotId": {
                return Optional.of(clazz.cast(this.snapshotId()));
            }
            case "SnapshotDownloadUrl": {
                return Optional.of(clazz.cast(this.snapshotDownloadUrl()));
            }
            case "Product": {
                return Optional.of(clazz.cast(this.product()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SSMResponse.BuilderImpl
    implements Builder {
        private String instanceId;
        private String snapshotId;
        private String snapshotDownloadUrl;
        private String product;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeployablePatchSnapshotForInstanceResponse model) {
            this.instanceId(model.instanceId);
            this.snapshotId(model.snapshotId);
            this.snapshotDownloadUrl(model.snapshotDownloadUrl);
            this.product(model.product);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        public final String getSnapshotDownloadUrl() {
            return this.snapshotDownloadUrl;
        }

        @Override
        public final Builder snapshotDownloadUrl(String snapshotDownloadUrl) {
            this.snapshotDownloadUrl = snapshotDownloadUrl;
            return this;
        }

        public final void setSnapshotDownloadUrl(String snapshotDownloadUrl) {
            this.snapshotDownloadUrl = snapshotDownloadUrl;
        }

        public final String getProduct() {
            return this.product;
        }

        @Override
        public final Builder product(String product) {
            this.product = product;
            return this;
        }

        public final void setProduct(String product) {
            this.product = product;
        }

        @Override
        public GetDeployablePatchSnapshotForInstanceResponse build() {
            return new GetDeployablePatchSnapshotForInstanceResponse(this);
        }
    }

    public static interface Builder
    extends SSMResponse.Builder,
    CopyableBuilder<Builder, GetDeployablePatchSnapshotForInstanceResponse> {
        public Builder instanceId(String var1);

        public Builder snapshotId(String var1);

        public Builder snapshotDownloadUrl(String var1);

        public Builder product(String var1);
    }
}

