/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ssm.model.SSMRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetMaintenanceWindowTaskRequest
extends SSMRequest
implements ToCopyableBuilder<Builder, GetMaintenanceWindowTaskRequest> {
    private final String windowId;
    private final String windowTaskId;

    private GetMaintenanceWindowTaskRequest(BuilderImpl builder) {
        super(builder);
        this.windowId = builder.windowId;
        this.windowTaskId = builder.windowTaskId;
    }

    public String windowId() {
        return this.windowId;
    }

    public String windowTaskId() {
        return this.windowTaskId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.windowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.windowTaskId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMaintenanceWindowTaskRequest)) {
            return false;
        }
        GetMaintenanceWindowTaskRequest other = (GetMaintenanceWindowTaskRequest)((Object)obj);
        return Objects.equals(this.windowId(), other.windowId()) && Objects.equals(this.windowTaskId(), other.windowTaskId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.windowId() != null) {
            sb.append("WindowId: ").append(this.windowId()).append(",");
        }
        if (this.windowTaskId() != null) {
            sb.append("WindowTaskId: ").append(this.windowTaskId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WindowId": {
                return Optional.of(clazz.cast(this.windowId()));
            }
            case "WindowTaskId": {
                return Optional.of(clazz.cast(this.windowTaskId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SSMRequest.BuilderImpl
    implements Builder {
        private String windowId;
        private String windowTaskId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMaintenanceWindowTaskRequest model) {
            this.windowId(model.windowId);
            this.windowTaskId(model.windowTaskId);
        }

        public final String getWindowId() {
            return this.windowId;
        }

        @Override
        public final Builder windowId(String windowId) {
            this.windowId = windowId;
            return this;
        }

        public final void setWindowId(String windowId) {
            this.windowId = windowId;
        }

        public final String getWindowTaskId() {
            return this.windowTaskId;
        }

        @Override
        public final Builder windowTaskId(String windowTaskId) {
            this.windowTaskId = windowTaskId;
            return this;
        }

        public final void setWindowTaskId(String windowTaskId) {
            this.windowTaskId = windowTaskId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetMaintenanceWindowTaskRequest build() {
            return new GetMaintenanceWindowTaskRequest(this);
        }
    }

    public static interface Builder
    extends SSMRequest.Builder,
    CopyableBuilder<Builder, GetMaintenanceWindowTaskRequest> {
        public Builder windowId(String var1);

        public Builder windowTaskId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

