/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.ssm.model.OperatingSystem;
import software.amazon.awssdk.services.ssm.model.PatchComplianceLevel;
import software.amazon.awssdk.services.ssm.model.PatchFilterGroup;
import software.amazon.awssdk.services.ssm.model.PatchGroupListCopier;
import software.amazon.awssdk.services.ssm.model.PatchIdListCopier;
import software.amazon.awssdk.services.ssm.model.PatchRuleGroup;
import software.amazon.awssdk.services.ssm.model.SSMResponse;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetPatchBaselineResponse
extends SSMResponse
implements ToCopyableBuilder<Builder, GetPatchBaselineResponse> {
    private final String baselineId;
    private final String name;
    private final String operatingSystem;
    private final PatchFilterGroup globalFilters;
    private final PatchRuleGroup approvalRules;
    private final List<String> approvedPatches;
    private final String approvedPatchesComplianceLevel;
    private final List<String> rejectedPatches;
    private final List<String> patchGroups;
    private final Instant createdDate;
    private final Instant modifiedDate;
    private final String description;

    private GetPatchBaselineResponse(BuilderImpl builder) {
        super(builder);
        this.baselineId = builder.baselineId;
        this.name = builder.name;
        this.operatingSystem = builder.operatingSystem;
        this.globalFilters = builder.globalFilters;
        this.approvalRules = builder.approvalRules;
        this.approvedPatches = builder.approvedPatches;
        this.approvedPatchesComplianceLevel = builder.approvedPatchesComplianceLevel;
        this.rejectedPatches = builder.rejectedPatches;
        this.patchGroups = builder.patchGroups;
        this.createdDate = builder.createdDate;
        this.modifiedDate = builder.modifiedDate;
        this.description = builder.description;
    }

    public String baselineId() {
        return this.baselineId;
    }

    public String name() {
        return this.name;
    }

    public OperatingSystem operatingSystem() {
        return OperatingSystem.fromValue(this.operatingSystem);
    }

    public String operatingSystemString() {
        return this.operatingSystem;
    }

    public PatchFilterGroup globalFilters() {
        return this.globalFilters;
    }

    public PatchRuleGroup approvalRules() {
        return this.approvalRules;
    }

    public List<String> approvedPatches() {
        return this.approvedPatches;
    }

    public PatchComplianceLevel approvedPatchesComplianceLevel() {
        return PatchComplianceLevel.fromValue(this.approvedPatchesComplianceLevel);
    }

    public String approvedPatchesComplianceLevelString() {
        return this.approvedPatchesComplianceLevel;
    }

    public List<String> rejectedPatches() {
        return this.rejectedPatches;
    }

    public List<String> patchGroups() {
        return this.patchGroups;
    }

    public Instant createdDate() {
        return this.createdDate;
    }

    public Instant modifiedDate() {
        return this.modifiedDate;
    }

    public String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.baselineId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatingSystemString());
        hashCode = 31 * hashCode + Objects.hashCode(this.globalFilters());
        hashCode = 31 * hashCode + Objects.hashCode(this.approvalRules());
        hashCode = 31 * hashCode + Objects.hashCode(this.approvedPatches());
        hashCode = 31 * hashCode + Objects.hashCode(this.approvedPatchesComplianceLevelString());
        hashCode = 31 * hashCode + Objects.hashCode(this.rejectedPatches());
        hashCode = 31 * hashCode + Objects.hashCode(this.patchGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPatchBaselineResponse)) {
            return false;
        }
        GetPatchBaselineResponse other = (GetPatchBaselineResponse)((Object)obj);
        return Objects.equals(this.baselineId(), other.baselineId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.operatingSystemString(), other.operatingSystemString()) && Objects.equals(this.globalFilters(), other.globalFilters()) && Objects.equals(this.approvalRules(), other.approvalRules()) && Objects.equals(this.approvedPatches(), other.approvedPatches()) && Objects.equals(this.approvedPatchesComplianceLevelString(), other.approvedPatchesComplianceLevelString()) && Objects.equals(this.rejectedPatches(), other.rejectedPatches()) && Objects.equals(this.patchGroups(), other.patchGroups()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.modifiedDate(), other.modifiedDate()) && Objects.equals(this.description(), other.description());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.baselineId() != null) {
            sb.append("BaselineId: ").append(this.baselineId()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.operatingSystemString() != null) {
            sb.append("OperatingSystem: ").append(this.operatingSystemString()).append(",");
        }
        if (this.globalFilters() != null) {
            sb.append("GlobalFilters: ").append(this.globalFilters()).append(",");
        }
        if (this.approvalRules() != null) {
            sb.append("ApprovalRules: ").append(this.approvalRules()).append(",");
        }
        if (this.approvedPatches() != null) {
            sb.append("ApprovedPatches: ").append(this.approvedPatches()).append(",");
        }
        if (this.approvedPatchesComplianceLevelString() != null) {
            sb.append("ApprovedPatchesComplianceLevel: ").append(this.approvedPatchesComplianceLevelString()).append(",");
        }
        if (this.rejectedPatches() != null) {
            sb.append("RejectedPatches: ").append(this.rejectedPatches()).append(",");
        }
        if (this.patchGroups() != null) {
            sb.append("PatchGroups: ").append(this.patchGroups()).append(",");
        }
        if (this.createdDate() != null) {
            sb.append("CreatedDate: ").append(this.createdDate()).append(",");
        }
        if (this.modifiedDate() != null) {
            sb.append("ModifiedDate: ").append(this.modifiedDate()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BaselineId": {
                return Optional.of(clazz.cast(this.baselineId()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "OperatingSystem": {
                return Optional.of(clazz.cast(this.operatingSystemString()));
            }
            case "GlobalFilters": {
                return Optional.of(clazz.cast(this.globalFilters()));
            }
            case "ApprovalRules": {
                return Optional.of(clazz.cast(this.approvalRules()));
            }
            case "ApprovedPatches": {
                return Optional.of(clazz.cast(this.approvedPatches()));
            }
            case "ApprovedPatchesComplianceLevel": {
                return Optional.of(clazz.cast(this.approvedPatchesComplianceLevelString()));
            }
            case "RejectedPatches": {
                return Optional.of(clazz.cast(this.rejectedPatches()));
            }
            case "PatchGroups": {
                return Optional.of(clazz.cast(this.patchGroups()));
            }
            case "CreatedDate": {
                return Optional.of(clazz.cast(this.createdDate()));
            }
            case "ModifiedDate": {
                return Optional.of(clazz.cast(this.modifiedDate()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SSMResponse.BuilderImpl
    implements Builder {
        private String baselineId;
        private String name;
        private String operatingSystem;
        private PatchFilterGroup globalFilters;
        private PatchRuleGroup approvalRules;
        private List<String> approvedPatches;
        private String approvedPatchesComplianceLevel;
        private List<String> rejectedPatches;
        private List<String> patchGroups;
        private Instant createdDate;
        private Instant modifiedDate;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPatchBaselineResponse model) {
            this.baselineId(model.baselineId);
            this.name(model.name);
            this.operatingSystem(model.operatingSystem);
            this.globalFilters(model.globalFilters);
            this.approvalRules(model.approvalRules);
            this.approvedPatches(model.approvedPatches);
            this.approvedPatchesComplianceLevel(model.approvedPatchesComplianceLevel);
            this.rejectedPatches(model.rejectedPatches);
            this.patchGroups(model.patchGroups);
            this.createdDate(model.createdDate);
            this.modifiedDate(model.modifiedDate);
            this.description(model.description);
        }

        public final String getBaselineId() {
            return this.baselineId;
        }

        @Override
        public final Builder baselineId(String baselineId) {
            this.baselineId = baselineId;
            return this;
        }

        public final void setBaselineId(String baselineId) {
            this.baselineId = baselineId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getOperatingSystem() {
            return this.operatingSystem;
        }

        @Override
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        @Override
        public final Builder operatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem(operatingSystem.toString());
            return this;
        }

        public final void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        public final PatchFilterGroup.Builder getGlobalFilters() {
            return this.globalFilters != null ? this.globalFilters.toBuilder() : null;
        }

        @Override
        public final Builder globalFilters(PatchFilterGroup globalFilters) {
            this.globalFilters = globalFilters;
            return this;
        }

        public final void setGlobalFilters(PatchFilterGroup.BuilderImpl globalFilters) {
            this.globalFilters = globalFilters != null ? globalFilters.build() : null;
        }

        public final PatchRuleGroup.Builder getApprovalRules() {
            return this.approvalRules != null ? this.approvalRules.toBuilder() : null;
        }

        @Override
        public final Builder approvalRules(PatchRuleGroup approvalRules) {
            this.approvalRules = approvalRules;
            return this;
        }

        public final void setApprovalRules(PatchRuleGroup.BuilderImpl approvalRules) {
            this.approvalRules = approvalRules != null ? approvalRules.build() : null;
        }

        public final Collection<String> getApprovedPatches() {
            return this.approvedPatches;
        }

        @Override
        public final Builder approvedPatches(Collection<String> approvedPatches) {
            this.approvedPatches = PatchIdListCopier.copy(approvedPatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder approvedPatches(String ... approvedPatches) {
            this.approvedPatches(Arrays.asList(approvedPatches));
            return this;
        }

        public final void setApprovedPatches(Collection<String> approvedPatches) {
            this.approvedPatches = PatchIdListCopier.copy(approvedPatches);
        }

        public final String getApprovedPatchesComplianceLevel() {
            return this.approvedPatchesComplianceLevel;
        }

        @Override
        public final Builder approvedPatchesComplianceLevel(String approvedPatchesComplianceLevel) {
            this.approvedPatchesComplianceLevel = approvedPatchesComplianceLevel;
            return this;
        }

        @Override
        public final Builder approvedPatchesComplianceLevel(PatchComplianceLevel approvedPatchesComplianceLevel) {
            this.approvedPatchesComplianceLevel(approvedPatchesComplianceLevel.toString());
            return this;
        }

        public final void setApprovedPatchesComplianceLevel(String approvedPatchesComplianceLevel) {
            this.approvedPatchesComplianceLevel = approvedPatchesComplianceLevel;
        }

        public final Collection<String> getRejectedPatches() {
            return this.rejectedPatches;
        }

        @Override
        public final Builder rejectedPatches(Collection<String> rejectedPatches) {
            this.rejectedPatches = PatchIdListCopier.copy(rejectedPatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rejectedPatches(String ... rejectedPatches) {
            this.rejectedPatches(Arrays.asList(rejectedPatches));
            return this;
        }

        public final void setRejectedPatches(Collection<String> rejectedPatches) {
            this.rejectedPatches = PatchIdListCopier.copy(rejectedPatches);
        }

        public final Collection<String> getPatchGroups() {
            return this.patchGroups;
        }

        @Override
        public final Builder patchGroups(Collection<String> patchGroups) {
            this.patchGroups = PatchGroupListCopier.copy(patchGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patchGroups(String ... patchGroups) {
            this.patchGroups(Arrays.asList(patchGroups));
            return this;
        }

        public final void setPatchGroups(Collection<String> patchGroups) {
            this.patchGroups = PatchGroupListCopier.copy(patchGroups);
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final Instant getModifiedDate() {
            return this.modifiedDate;
        }

        @Override
        public final Builder modifiedDate(Instant modifiedDate) {
            this.modifiedDate = modifiedDate;
            return this;
        }

        public final void setModifiedDate(Instant modifiedDate) {
            this.modifiedDate = modifiedDate;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public GetPatchBaselineResponse build() {
            return new GetPatchBaselineResponse(this);
        }
    }

    public static interface Builder
    extends SSMResponse.Builder,
    CopyableBuilder<Builder, GetPatchBaselineResponse> {
        public Builder baselineId(String var1);

        public Builder name(String var1);

        public Builder operatingSystem(String var1);

        public Builder operatingSystem(OperatingSystem var1);

        public Builder globalFilters(PatchFilterGroup var1);

        default public Builder globalFilters(Consumer<PatchFilterGroup.Builder> globalFilters) {
            return this.globalFilters((PatchFilterGroup)((PatchFilterGroup.Builder)PatchFilterGroup.builder().apply(globalFilters)).build());
        }

        public Builder approvalRules(PatchRuleGroup var1);

        default public Builder approvalRules(Consumer<PatchRuleGroup.Builder> approvalRules) {
            return this.approvalRules((PatchRuleGroup)((PatchRuleGroup.Builder)PatchRuleGroup.builder().apply(approvalRules)).build());
        }

        public Builder approvedPatches(Collection<String> var1);

        public Builder approvedPatches(String ... var1);

        public Builder approvedPatchesComplianceLevel(String var1);

        public Builder approvedPatchesComplianceLevel(PatchComplianceLevel var1);

        public Builder rejectedPatches(Collection<String> var1);

        public Builder rejectedPatches(String ... var1);

        public Builder patchGroups(Collection<String> var1);

        public Builder patchGroups(String ... var1);

        public Builder createdDate(Instant var1);

        public Builder modifiedDate(Instant var1);

        public Builder description(String var1);
    }
}

