/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.LastResourceDataSyncStatus;
import software.amazon.awssdk.services.ssm.model.ResourceDataSyncS3Destination;
import software.amazon.awssdk.services.ssm.transform.ResourceDataSyncItemMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ResourceDataSyncItem
implements StructuredPojo,
ToCopyableBuilder<Builder, ResourceDataSyncItem> {
    private final String syncName;
    private final ResourceDataSyncS3Destination s3Destination;
    private final Instant lastSyncTime;
    private final Instant lastSuccessfulSyncTime;
    private final String lastStatus;
    private final Instant syncCreatedTime;

    private ResourceDataSyncItem(BuilderImpl builder) {
        this.syncName = builder.syncName;
        this.s3Destination = builder.s3Destination;
        this.lastSyncTime = builder.lastSyncTime;
        this.lastSuccessfulSyncTime = builder.lastSuccessfulSyncTime;
        this.lastStatus = builder.lastStatus;
        this.syncCreatedTime = builder.syncCreatedTime;
    }

    public String syncName() {
        return this.syncName;
    }

    public ResourceDataSyncS3Destination s3Destination() {
        return this.s3Destination;
    }

    public Instant lastSyncTime() {
        return this.lastSyncTime;
    }

    public Instant lastSuccessfulSyncTime() {
        return this.lastSuccessfulSyncTime;
    }

    public LastResourceDataSyncStatus lastStatus() {
        return LastResourceDataSyncStatus.fromValue(this.lastStatus);
    }

    public String lastStatusString() {
        return this.lastStatus;
    }

    public Instant syncCreatedTime() {
        return this.syncCreatedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.syncName());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSyncTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSuccessfulSyncTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastStatusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.syncCreatedTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceDataSyncItem)) {
            return false;
        }
        ResourceDataSyncItem other = (ResourceDataSyncItem)obj;
        return Objects.equals(this.syncName(), other.syncName()) && Objects.equals(this.s3Destination(), other.s3Destination()) && Objects.equals(this.lastSyncTime(), other.lastSyncTime()) && Objects.equals(this.lastSuccessfulSyncTime(), other.lastSuccessfulSyncTime()) && Objects.equals(this.lastStatusString(), other.lastStatusString()) && Objects.equals(this.syncCreatedTime(), other.syncCreatedTime());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.syncName() != null) {
            sb.append("SyncName: ").append(this.syncName()).append(",");
        }
        if (this.s3Destination() != null) {
            sb.append("S3Destination: ").append(this.s3Destination()).append(",");
        }
        if (this.lastSyncTime() != null) {
            sb.append("LastSyncTime: ").append(this.lastSyncTime()).append(",");
        }
        if (this.lastSuccessfulSyncTime() != null) {
            sb.append("LastSuccessfulSyncTime: ").append(this.lastSuccessfulSyncTime()).append(",");
        }
        if (this.lastStatusString() != null) {
            sb.append("LastStatus: ").append(this.lastStatusString()).append(",");
        }
        if (this.syncCreatedTime() != null) {
            sb.append("SyncCreatedTime: ").append(this.syncCreatedTime()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SyncName": {
                return Optional.of(clazz.cast(this.syncName()));
            }
            case "S3Destination": {
                return Optional.of(clazz.cast(this.s3Destination()));
            }
            case "LastSyncTime": {
                return Optional.of(clazz.cast(this.lastSyncTime()));
            }
            case "LastSuccessfulSyncTime": {
                return Optional.of(clazz.cast(this.lastSuccessfulSyncTime()));
            }
            case "LastStatus": {
                return Optional.of(clazz.cast(this.lastStatusString()));
            }
            case "SyncCreatedTime": {
                return Optional.of(clazz.cast(this.syncCreatedTime()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourceDataSyncItemMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String syncName;
        private ResourceDataSyncS3Destination s3Destination;
        private Instant lastSyncTime;
        private Instant lastSuccessfulSyncTime;
        private String lastStatus;
        private Instant syncCreatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceDataSyncItem model) {
            this.syncName(model.syncName);
            this.s3Destination(model.s3Destination);
            this.lastSyncTime(model.lastSyncTime);
            this.lastSuccessfulSyncTime(model.lastSuccessfulSyncTime);
            this.lastStatus(model.lastStatus);
            this.syncCreatedTime(model.syncCreatedTime);
        }

        public final String getSyncName() {
            return this.syncName;
        }

        @Override
        public final Builder syncName(String syncName) {
            this.syncName = syncName;
            return this;
        }

        public final void setSyncName(String syncName) {
            this.syncName = syncName;
        }

        public final ResourceDataSyncS3Destination.Builder getS3Destination() {
            return this.s3Destination != null ? this.s3Destination.toBuilder() : null;
        }

        @Override
        public final Builder s3Destination(ResourceDataSyncS3Destination s3Destination) {
            this.s3Destination = s3Destination;
            return this;
        }

        public final void setS3Destination(ResourceDataSyncS3Destination.BuilderImpl s3Destination) {
            this.s3Destination = s3Destination != null ? s3Destination.build() : null;
        }

        public final Instant getLastSyncTime() {
            return this.lastSyncTime;
        }

        @Override
        public final Builder lastSyncTime(Instant lastSyncTime) {
            this.lastSyncTime = lastSyncTime;
            return this;
        }

        public final void setLastSyncTime(Instant lastSyncTime) {
            this.lastSyncTime = lastSyncTime;
        }

        public final Instant getLastSuccessfulSyncTime() {
            return this.lastSuccessfulSyncTime;
        }

        @Override
        public final Builder lastSuccessfulSyncTime(Instant lastSuccessfulSyncTime) {
            this.lastSuccessfulSyncTime = lastSuccessfulSyncTime;
            return this;
        }

        public final void setLastSuccessfulSyncTime(Instant lastSuccessfulSyncTime) {
            this.lastSuccessfulSyncTime = lastSuccessfulSyncTime;
        }

        public final String getLastStatus() {
            return this.lastStatus;
        }

        @Override
        public final Builder lastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
            return this;
        }

        @Override
        public final Builder lastStatus(LastResourceDataSyncStatus lastStatus) {
            this.lastStatus(lastStatus.toString());
            return this;
        }

        public final void setLastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
        }

        public final Instant getSyncCreatedTime() {
            return this.syncCreatedTime;
        }

        @Override
        public final Builder syncCreatedTime(Instant syncCreatedTime) {
            this.syncCreatedTime = syncCreatedTime;
            return this;
        }

        public final void setSyncCreatedTime(Instant syncCreatedTime) {
            this.syncCreatedTime = syncCreatedTime;
        }

        public ResourceDataSyncItem build() {
            return new ResourceDataSyncItem(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ResourceDataSyncItem> {
        public Builder syncName(String var1);

        public Builder s3Destination(ResourceDataSyncS3Destination var1);

        default public Builder s3Destination(Consumer<ResourceDataSyncS3Destination.Builder> s3Destination) {
            return this.s3Destination((ResourceDataSyncS3Destination)((ResourceDataSyncS3Destination.Builder)ResourceDataSyncS3Destination.builder().apply(s3Destination)).build());
        }

        public Builder lastSyncTime(Instant var1);

        public Builder lastSuccessfulSyncTime(Instant var1);

        public Builder lastStatus(String var1);

        public Builder lastStatus(LastResourceDataSyncStatus var1);

        public Builder syncCreatedTime(Instant var1);
    }
}

