/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.ssm.SSMClient;
import software.amazon.awssdk.services.ssm.model.Activation;
import software.amazon.awssdk.services.ssm.model.DescribeActivationsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeActivationsResponse;

public final class DescribeActivationsPaginator
implements SdkIterable<DescribeActivationsResponse> {
    private final SSMClient client;
    private final DescribeActivationsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeActivationsPaginator(SSMClient client, DescribeActivationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeActivationsResponseFetcher();
    }

    public Iterator<DescribeActivationsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Activation> activationList() {
        Function<DescribeActivationsResponse, Iterator> getIterator = response -> response != null ? response.activationList().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeActivationsResponseFetcher
    implements NextPageFetcher<DescribeActivationsResponse> {
        private DescribeActivationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeActivationsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeActivationsResponse nextPage(DescribeActivationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeActivationsPaginator.this.client.describeActivations(DescribeActivationsPaginator.this.firstRequest);
            }
            return DescribeActivationsPaginator.this.client.describeActivations((DescribeActivationsRequest)((Object)DescribeActivationsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

