/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowTaskRequest;

@SdkInternalApi
public class UpdateMaintenanceWindowTaskRequestModelMarshaller {
    private static final MarshallingInfo<String> WINDOWID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WindowId").build();
    private static final MarshallingInfo<String> WINDOWTASKID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WindowTaskId").build();
    private static final MarshallingInfo<List> TARGETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Targets").build();
    private static final MarshallingInfo<String> TASKARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TaskArn").build();
    private static final MarshallingInfo<String> SERVICEROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceRoleArn").build();
    private static final MarshallingInfo<Map> TASKPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TaskParameters").build();
    private static final MarshallingInfo<StructuredPojo> TASKINVOCATIONPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TaskInvocationParameters").build();
    private static final MarshallingInfo<Integer> PRIORITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Priority").build();
    private static final MarshallingInfo<String> MAXCONCURRENCY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxConcurrency").build();
    private static final MarshallingInfo<String> MAXERRORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxErrors").build();
    private static final MarshallingInfo<StructuredPojo> LOGGINGINFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LoggingInfo").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<Boolean> REPLACE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Replace").build();
    private static final UpdateMaintenanceWindowTaskRequestModelMarshaller INSTANCE = new UpdateMaintenanceWindowTaskRequestModelMarshaller();

    public static UpdateMaintenanceWindowTaskRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UpdateMaintenanceWindowTaskRequest updateMaintenanceWindowTaskRequest, ProtocolMarshaller protocolMarshaller) {
        if (updateMaintenanceWindowTaskRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)updateMaintenanceWindowTaskRequest.windowId(), WINDOWID_BINDING);
            protocolMarshaller.marshall((Object)updateMaintenanceWindowTaskRequest.windowTaskId(), WINDOWTASKID_BINDING);
            protocolMarshaller.marshall(updateMaintenanceWindowTaskRequest.targets(), TARGETS_BINDING);
            protocolMarshaller.marshall((Object)updateMaintenanceWindowTaskRequest.taskArn(), TASKARN_BINDING);
            protocolMarshaller.marshall((Object)updateMaintenanceWindowTaskRequest.serviceRoleArn(), SERVICEROLEARN_BINDING);
            protocolMarshaller.marshall(updateMaintenanceWindowTaskRequest.taskParameters(), TASKPARAMETERS_BINDING);
            protocolMarshaller.marshall((Object)updateMaintenanceWindowTaskRequest.taskInvocationParameters(), TASKINVOCATIONPARAMETERS_BINDING);
            protocolMarshaller.marshall((Object)updateMaintenanceWindowTaskRequest.priority(), PRIORITY_BINDING);
            protocolMarshaller.marshall((Object)updateMaintenanceWindowTaskRequest.maxConcurrency(), MAXCONCURRENCY_BINDING);
            protocolMarshaller.marshall((Object)updateMaintenanceWindowTaskRequest.maxErrors(), MAXERRORS_BINDING);
            protocolMarshaller.marshall((Object)updateMaintenanceWindowTaskRequest.loggingInfo(), LOGGINGINFO_BINDING);
            protocolMarshaller.marshall((Object)updateMaintenanceWindowTaskRequest.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)updateMaintenanceWindowTaskRequest.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)updateMaintenanceWindowTaskRequest.replace(), REPLACE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

