/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.ssm.model.AddTagsToResourceRequest;
import software.amazon.awssdk.services.ssm.model.AddTagsToResourceResponse;
import software.amazon.awssdk.services.ssm.model.CancelCommandRequest;
import software.amazon.awssdk.services.ssm.model.CancelCommandResponse;
import software.amazon.awssdk.services.ssm.model.CreateActivationRequest;
import software.amazon.awssdk.services.ssm.model.CreateActivationResponse;
import software.amazon.awssdk.services.ssm.model.CreateAssociationBatchRequest;
import software.amazon.awssdk.services.ssm.model.CreateAssociationBatchResponse;
import software.amazon.awssdk.services.ssm.model.CreateAssociationRequest;
import software.amazon.awssdk.services.ssm.model.CreateAssociationResponse;
import software.amazon.awssdk.services.ssm.model.CreateDocumentRequest;
import software.amazon.awssdk.services.ssm.model.CreateDocumentResponse;
import software.amazon.awssdk.services.ssm.model.CreateMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.CreateMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.CreatePatchBaselineRequest;
import software.amazon.awssdk.services.ssm.model.CreatePatchBaselineResponse;
import software.amazon.awssdk.services.ssm.model.CreateResourceDataSyncRequest;
import software.amazon.awssdk.services.ssm.model.CreateResourceDataSyncResponse;
import software.amazon.awssdk.services.ssm.model.DeleteActivationRequest;
import software.amazon.awssdk.services.ssm.model.DeleteActivationResponse;
import software.amazon.awssdk.services.ssm.model.DeleteAssociationRequest;
import software.amazon.awssdk.services.ssm.model.DeleteAssociationResponse;
import software.amazon.awssdk.services.ssm.model.DeleteDocumentRequest;
import software.amazon.awssdk.services.ssm.model.DeleteDocumentResponse;
import software.amazon.awssdk.services.ssm.model.DeleteMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.DeleteMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.DeleteParameterRequest;
import software.amazon.awssdk.services.ssm.model.DeleteParameterResponse;
import software.amazon.awssdk.services.ssm.model.DeleteParametersRequest;
import software.amazon.awssdk.services.ssm.model.DeleteParametersResponse;
import software.amazon.awssdk.services.ssm.model.DeletePatchBaselineRequest;
import software.amazon.awssdk.services.ssm.model.DeletePatchBaselineResponse;
import software.amazon.awssdk.services.ssm.model.DeleteResourceDataSyncRequest;
import software.amazon.awssdk.services.ssm.model.DeleteResourceDataSyncResponse;
import software.amazon.awssdk.services.ssm.model.DeregisterManagedInstanceRequest;
import software.amazon.awssdk.services.ssm.model.DeregisterManagedInstanceResponse;
import software.amazon.awssdk.services.ssm.model.DeregisterPatchBaselineForPatchGroupRequest;
import software.amazon.awssdk.services.ssm.model.DeregisterPatchBaselineForPatchGroupResponse;
import software.amazon.awssdk.services.ssm.model.DeregisterTargetFromMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.DeregisterTargetFromMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.DeregisterTaskFromMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.DeregisterTaskFromMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.DescribeActivationsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeActivationsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeAssociationRequest;
import software.amazon.awssdk.services.ssm.model.DescribeAssociationResponse;
import software.amazon.awssdk.services.ssm.model.DescribeAutomationExecutionsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeAutomationExecutionsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeAvailablePatchesRequest;
import software.amazon.awssdk.services.ssm.model.DescribeAvailablePatchesResponse;
import software.amazon.awssdk.services.ssm.model.DescribeDocumentPermissionRequest;
import software.amazon.awssdk.services.ssm.model.DescribeDocumentPermissionResponse;
import software.amazon.awssdk.services.ssm.model.DescribeDocumentRequest;
import software.amazon.awssdk.services.ssm.model.DescribeDocumentResponse;
import software.amazon.awssdk.services.ssm.model.DescribeEffectiveInstanceAssociationsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeEffectiveInstanceAssociationsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeEffectivePatchesForPatchBaselineRequest;
import software.amazon.awssdk.services.ssm.model.DescribeEffectivePatchesForPatchBaselineResponse;
import software.amazon.awssdk.services.ssm.model.DescribeInstanceAssociationsStatusRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInstanceAssociationsStatusResponse;
import software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationResponse;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesForPatchGroupRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesForPatchGroupResponse;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesResponse;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePatchesRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePatchesResponse;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTasksRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTasksResponse;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTargetsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTargetsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTasksRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTasksResponse;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeParametersRequest;
import software.amazon.awssdk.services.ssm.model.DescribeParametersResponse;
import software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesRequest;
import software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesResponse;
import software.amazon.awssdk.services.ssm.model.DescribePatchGroupStateRequest;
import software.amazon.awssdk.services.ssm.model.DescribePatchGroupStateResponse;
import software.amazon.awssdk.services.ssm.model.DescribePatchGroupsRequest;
import software.amazon.awssdk.services.ssm.model.DescribePatchGroupsResponse;
import software.amazon.awssdk.services.ssm.model.GetAutomationExecutionRequest;
import software.amazon.awssdk.services.ssm.model.GetAutomationExecutionResponse;
import software.amazon.awssdk.services.ssm.model.GetCommandInvocationRequest;
import software.amazon.awssdk.services.ssm.model.GetCommandInvocationResponse;
import software.amazon.awssdk.services.ssm.model.GetDefaultPatchBaselineRequest;
import software.amazon.awssdk.services.ssm.model.GetDefaultPatchBaselineResponse;
import software.amazon.awssdk.services.ssm.model.GetDeployablePatchSnapshotForInstanceRequest;
import software.amazon.awssdk.services.ssm.model.GetDeployablePatchSnapshotForInstanceResponse;
import software.amazon.awssdk.services.ssm.model.GetDocumentRequest;
import software.amazon.awssdk.services.ssm.model.GetDocumentResponse;
import software.amazon.awssdk.services.ssm.model.GetInventoryRequest;
import software.amazon.awssdk.services.ssm.model.GetInventoryResponse;
import software.amazon.awssdk.services.ssm.model.GetInventorySchemaRequest;
import software.amazon.awssdk.services.ssm.model.GetInventorySchemaResponse;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionRequest;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionResponse;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskInvocationRequest;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskInvocationResponse;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskRequest;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskResponse;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowTaskRequest;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowTaskResponse;
import software.amazon.awssdk.services.ssm.model.GetParameterHistoryRequest;
import software.amazon.awssdk.services.ssm.model.GetParameterHistoryResponse;
import software.amazon.awssdk.services.ssm.model.GetParameterRequest;
import software.amazon.awssdk.services.ssm.model.GetParameterResponse;
import software.amazon.awssdk.services.ssm.model.GetParametersByPathRequest;
import software.amazon.awssdk.services.ssm.model.GetParametersByPathResponse;
import software.amazon.awssdk.services.ssm.model.GetParametersRequest;
import software.amazon.awssdk.services.ssm.model.GetParametersResponse;
import software.amazon.awssdk.services.ssm.model.GetPatchBaselineForPatchGroupRequest;
import software.amazon.awssdk.services.ssm.model.GetPatchBaselineForPatchGroupResponse;
import software.amazon.awssdk.services.ssm.model.GetPatchBaselineRequest;
import software.amazon.awssdk.services.ssm.model.GetPatchBaselineResponse;
import software.amazon.awssdk.services.ssm.model.ListAssociationVersionsRequest;
import software.amazon.awssdk.services.ssm.model.ListAssociationVersionsResponse;
import software.amazon.awssdk.services.ssm.model.ListAssociationsRequest;
import software.amazon.awssdk.services.ssm.model.ListAssociationsResponse;
import software.amazon.awssdk.services.ssm.model.ListCommandInvocationsRequest;
import software.amazon.awssdk.services.ssm.model.ListCommandInvocationsResponse;
import software.amazon.awssdk.services.ssm.model.ListCommandsRequest;
import software.amazon.awssdk.services.ssm.model.ListCommandsResponse;
import software.amazon.awssdk.services.ssm.model.ListComplianceItemsRequest;
import software.amazon.awssdk.services.ssm.model.ListComplianceItemsResponse;
import software.amazon.awssdk.services.ssm.model.ListComplianceSummariesRequest;
import software.amazon.awssdk.services.ssm.model.ListComplianceSummariesResponse;
import software.amazon.awssdk.services.ssm.model.ListDocumentVersionsRequest;
import software.amazon.awssdk.services.ssm.model.ListDocumentVersionsResponse;
import software.amazon.awssdk.services.ssm.model.ListDocumentsRequest;
import software.amazon.awssdk.services.ssm.model.ListDocumentsResponse;
import software.amazon.awssdk.services.ssm.model.ListInventoryEntriesRequest;
import software.amazon.awssdk.services.ssm.model.ListInventoryEntriesResponse;
import software.amazon.awssdk.services.ssm.model.ListResourceComplianceSummariesRequest;
import software.amazon.awssdk.services.ssm.model.ListResourceComplianceSummariesResponse;
import software.amazon.awssdk.services.ssm.model.ListResourceDataSyncRequest;
import software.amazon.awssdk.services.ssm.model.ListResourceDataSyncResponse;
import software.amazon.awssdk.services.ssm.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.ssm.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.ssm.model.ModifyDocumentPermissionRequest;
import software.amazon.awssdk.services.ssm.model.ModifyDocumentPermissionResponse;
import software.amazon.awssdk.services.ssm.model.PutComplianceItemsRequest;
import software.amazon.awssdk.services.ssm.model.PutComplianceItemsResponse;
import software.amazon.awssdk.services.ssm.model.PutInventoryRequest;
import software.amazon.awssdk.services.ssm.model.PutInventoryResponse;
import software.amazon.awssdk.services.ssm.model.PutParameterRequest;
import software.amazon.awssdk.services.ssm.model.PutParameterResponse;
import software.amazon.awssdk.services.ssm.model.RegisterDefaultPatchBaselineRequest;
import software.amazon.awssdk.services.ssm.model.RegisterDefaultPatchBaselineResponse;
import software.amazon.awssdk.services.ssm.model.RegisterPatchBaselineForPatchGroupRequest;
import software.amazon.awssdk.services.ssm.model.RegisterPatchBaselineForPatchGroupResponse;
import software.amazon.awssdk.services.ssm.model.RegisterTargetWithMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.RegisterTargetWithMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.RegisterTaskWithMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.RegisterTaskWithMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.RemoveTagsFromResourceRequest;
import software.amazon.awssdk.services.ssm.model.RemoveTagsFromResourceResponse;
import software.amazon.awssdk.services.ssm.model.SendAutomationSignalRequest;
import software.amazon.awssdk.services.ssm.model.SendAutomationSignalResponse;
import software.amazon.awssdk.services.ssm.model.SendCommandRequest;
import software.amazon.awssdk.services.ssm.model.SendCommandResponse;
import software.amazon.awssdk.services.ssm.model.StartAutomationExecutionRequest;
import software.amazon.awssdk.services.ssm.model.StartAutomationExecutionResponse;
import software.amazon.awssdk.services.ssm.model.StopAutomationExecutionRequest;
import software.amazon.awssdk.services.ssm.model.StopAutomationExecutionResponse;
import software.amazon.awssdk.services.ssm.model.UpdateAssociationRequest;
import software.amazon.awssdk.services.ssm.model.UpdateAssociationResponse;
import software.amazon.awssdk.services.ssm.model.UpdateAssociationStatusRequest;
import software.amazon.awssdk.services.ssm.model.UpdateAssociationStatusResponse;
import software.amazon.awssdk.services.ssm.model.UpdateDocumentDefaultVersionRequest;
import software.amazon.awssdk.services.ssm.model.UpdateDocumentDefaultVersionResponse;
import software.amazon.awssdk.services.ssm.model.UpdateDocumentRequest;
import software.amazon.awssdk.services.ssm.model.UpdateDocumentResponse;
import software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowTargetRequest;
import software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowTargetResponse;
import software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowTaskRequest;
import software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowTaskResponse;
import software.amazon.awssdk.services.ssm.model.UpdateManagedInstanceRoleRequest;
import software.amazon.awssdk.services.ssm.model.UpdateManagedInstanceRoleResponse;
import software.amazon.awssdk.services.ssm.model.UpdatePatchBaselineRequest;
import software.amazon.awssdk.services.ssm.model.UpdatePatchBaselineResponse;
import software.amazon.awssdk.utils.SdkAutoCloseable;

/**
 * Service client for accessing Amazon SSM asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <fullname>Amazon EC2 Systems Manager</fullname>
 * <p>
 * Amazon EC2 Systems Manager is a collection of capabilities that helps you automate management tasks such as
 * collecting system inventory, applying operating system (OS) patches, automating the creation of Amazon Machine Images
 * (AMIs), and configuring operating systems (OSs) and applications at scale. Systems Manager lets you remotely and
 * securely manage the configuration of your managed instances. A <i>managed instance</i> is any Amazon EC2 instance or
 * on-premises machine in your hybrid environment that has been configured for Systems Manager.
 * </p>
 * <p>
 * This reference is intended to be used with the <a
 * href="http://docs.aws.amazon.com/systems-manager/latest/userguide/">Amazon EC2 Systems Manager User Guide</a>.
 * </p>
 * <p>
 * To get started, verify prerequisites and configure managed instances. For more information, see <a
 * href="http://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-setting-up.html">Systems Manager
 * Prerequisites</a>.
 * </p>
 * <p>
 * For information about other API actions you can perform on Amazon EC2 instances, see the <a
 * href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/">Amazon EC2 API Reference</a>. For information about how
 * to use a Query API, see <a
 * href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/making-api-requests.html">Making API Requests</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface SSMAsyncClient extends SdkClient, SdkAutoCloseable {
    String SERVICE_NAME = "ssm";

    /**
     * Create a {@link SSMAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.core.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from
     * the {@link software.amazon.awssdk.core.auth.DefaultCredentialsProvider}.
     */
    static SSMAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SSMAsyncClient}.
     */
    static SSMAsyncClientBuilder builder() {
        return new DefaultSSMAsyncClientBuilder();
    }

    /**
     * <p>
     * Adds or overwrites one or more tags for the specified resource. Tags are metadata that you can assign to your
     * documents, managed instances, Maintenance Windows, Parameter Store parameters, and patch baselines. Tags enable
     * you to categorize your resources in different ways, for example, by purpose, owner, or environment. Each tag
     * consists of a key and an optional value, both of which you define. For example, you could define a set of tags
     * for your account's managed instances that helps you track each instance's owner and stack level. For example:
     * Key=Owner and Value=DbAdmin, SysAdmin, or Dev. Or Key=Stack and Value=Production, Pre-Production, or Test.
     * </p>
     * <p>
     * Each resource can have a maximum of 10 tags.
     * </p>
     * <p>
     * We recommend that you devise a set of tag keys that meets your needs for each resource type. Using a consistent
     * set of tag keys makes it easier for you to manage your resources. You can search and filter the resources based
     * on the tags you add. Tags don't have any semantic meaning to Amazon EC2 and are interpreted strictly as a string
     * of characters.
     * </p>
     * <p>
     * For more information about tags, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging Your Amazon EC2 Resources</a>
     * in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param addTagsToResourceRequest
     * @return A Java Future containing the result of the AddTagsToResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidResourceTypeException The resource type is not valid. For example, if you are attempting to
     *         tag an instance, the instance must be a registered, managed instance.</li>
     *         <li>InvalidResourceIdException The resource ID is not valid. Verify that you entered the correct ID and
     *         try again.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>TooManyTagsErrorException The Targets parameter includes too many tags. Remove one or more tags and
     *         try the command again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.AddTagsToResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/AddTagsToResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AddTagsToResourceResponse> addTagsToResource(AddTagsToResourceRequest addTagsToResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or overwrites one or more tags for the specified resource. Tags are metadata that you can assign to your
     * documents, managed instances, Maintenance Windows, Parameter Store parameters, and patch baselines. Tags enable
     * you to categorize your resources in different ways, for example, by purpose, owner, or environment. Each tag
     * consists of a key and an optional value, both of which you define. For example, you could define a set of tags
     * for your account's managed instances that helps you track each instance's owner and stack level. For example:
     * Key=Owner and Value=DbAdmin, SysAdmin, or Dev. Or Key=Stack and Value=Production, Pre-Production, or Test.
     * </p>
     * <p>
     * Each resource can have a maximum of 10 tags.
     * </p>
     * <p>
     * We recommend that you devise a set of tag keys that meets your needs for each resource type. Using a consistent
     * set of tag keys makes it easier for you to manage your resources. You can search and filter the resources based
     * on the tags you add. Tags don't have any semantic meaning to Amazon EC2 and are interpreted strictly as a string
     * of characters.
     * </p>
     * <p>
     * For more information about tags, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging Your Amazon EC2 Resources</a>
     * in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link AddTagsToResourceRequest.Builder} avoiding the need
     * to create one manually via {@link AddTagsToResourceRequest#builder()}
     *
     * @param addTagsToResourceRequest
     *        a {@link Consumer} that will call methods on {@link AddTagsToResourceRequest.Builder}.
     * @return A Java Future containing the result of the AddTagsToResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidResourceTypeException The resource type is not valid. For example, if you are attempting to
     *         tag an instance, the instance must be a registered, managed instance.</li>
     *         <li>InvalidResourceIdException The resource ID is not valid. Verify that you entered the correct ID and
     *         try again.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>TooManyTagsErrorException The Targets parameter includes too many tags. Remove one or more tags and
     *         try the command again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.AddTagsToResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/AddTagsToResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AddTagsToResourceResponse> addTagsToResource(
            Consumer<AddTagsToResourceRequest.Builder> addTagsToResourceRequest) {
        return addTagsToResource(AddTagsToResourceRequest.builder().apply(addTagsToResourceRequest).build());
    }

    /**
     * <p>
     * Attempts to cancel the command specified by the Command ID. There is no guarantee that the command will be
     * terminated and the underlying process stopped.
     * </p>
     *
     * @param cancelCommandRequest
     * @return A Java Future containing the result of the CancelCommand operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidCommandIdException</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>DuplicateInstanceIdException You cannot specify an instance ID in more than one association.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.CancelCommand
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CancelCommand" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CancelCommandResponse> cancelCommand(CancelCommandRequest cancelCommandRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attempts to cancel the command specified by the Command ID. There is no guarantee that the command will be
     * terminated and the underlying process stopped.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link CancelCommandRequest.Builder} avoiding the need to
     * create one manually via {@link CancelCommandRequest#builder()}
     *
     * @param cancelCommandRequest
     *        a {@link Consumer} that will call methods on {@link CancelCommandRequest.Builder}.
     * @return A Java Future containing the result of the CancelCommand operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidCommandIdException</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>DuplicateInstanceIdException You cannot specify an instance ID in more than one association.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.CancelCommand
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CancelCommand" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CancelCommandResponse> cancelCommand(Consumer<CancelCommandRequest.Builder> cancelCommandRequest) {
        return cancelCommand(CancelCommandRequest.builder().apply(cancelCommandRequest).build());
    }

    /**
     * <p>
     * Registers your on-premises server or virtual machine with Amazon EC2 so that you can manage these resources using
     * Run Command. An on-premises server or virtual machine that has been registered with EC2 is called a managed
     * instance. For more information about activations, see <a
     * href="http://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-managedinstances.html">Setting
     * Up Systems Manager in Hybrid Environments</a>.
     * </p>
     *
     * @param createActivationRequest
     * @return A Java Future containing the result of the CreateActivation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.CreateActivation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateActivation" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateActivationResponse> createActivation(CreateActivationRequest createActivationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers your on-premises server or virtual machine with Amazon EC2 so that you can manage these resources using
     * Run Command. An on-premises server or virtual machine that has been registered with EC2 is called a managed
     * instance. For more information about activations, see <a
     * href="http://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-managedinstances.html">Setting
     * Up Systems Manager in Hybrid Environments</a>.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link CreateActivationRequest.Builder} avoiding the need
     * to create one manually via {@link CreateActivationRequest#builder()}
     *
     * @param createActivationRequest
     *        a {@link Consumer} that will call methods on {@link CreateActivationRequest.Builder}.
     * @return A Java Future containing the result of the CreateActivation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.CreateActivation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateActivation" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateActivationResponse> createActivation(
            Consumer<CreateActivationRequest.Builder> createActivationRequest) {
        return createActivation(CreateActivationRequest.builder().apply(createActivationRequest).build());
    }

    /**
     * <p>
     * Associates the specified Systems Manager document with the specified instances or targets.
     * </p>
     * <p>
     * When you associate a document with one or more instances using instance IDs or tags, the SSM Agent running on the
     * instance processes the document and configures the instance as specified.
     * </p>
     * <p>
     * If you associate a document with an instance that already has an associated document, the system throws the
     * AssociationAlreadyExists exception.
     * </p>
     *
     * @param createAssociationRequest
     * @return A Java Future containing the result of the CreateAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AssociationAlreadyExistsException The specified association already exists.</li>
     *         <li>AssociationLimitExceededException You can have at most 2,000 active associations.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentException The specified document does not exist.</li>
     *         <li>InvalidDocumentVersionException The document version is not valid or does not exist.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>UnsupportedPlatformTypeException The document does not support the platform type of the given
     *         instance ID(s). For example, you sent an document for a Windows instance to a Linux instance.</li>
     *         <li>InvalidOutputLocationException The output location is not valid or does not exist.</li>
     *         <li>InvalidParametersException You must specify values for all required parameters in the Systems Manager
     *         document. You can only supply values to parameters defined in the Systems Manager document.</li>
     *         <li>InvalidTargetException The target is not valid or does not exist. It might not be configured for EC2
     *         Systems Manager or you might not have permission to perform the operation.</li>
     *         <li>InvalidScheduleException The schedule is invalid. Verify your cron or rate expression and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.CreateAssociation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateAssociation" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAssociationResponse> createAssociation(CreateAssociationRequest createAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified Systems Manager document with the specified instances or targets.
     * </p>
     * <p>
     * When you associate a document with one or more instances using instance IDs or tags, the SSM Agent running on the
     * instance processes the document and configures the instance as specified.
     * </p>
     * <p>
     * If you associate a document with an instance that already has an associated document, the system throws the
     * AssociationAlreadyExists exception.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link CreateAssociationRequest.Builder} avoiding the need
     * to create one manually via {@link CreateAssociationRequest#builder()}
     *
     * @param createAssociationRequest
     *        a {@link Consumer} that will call methods on {@link CreateAssociationRequest.Builder}.
     * @return A Java Future containing the result of the CreateAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AssociationAlreadyExistsException The specified association already exists.</li>
     *         <li>AssociationLimitExceededException You can have at most 2,000 active associations.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentException The specified document does not exist.</li>
     *         <li>InvalidDocumentVersionException The document version is not valid or does not exist.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>UnsupportedPlatformTypeException The document does not support the platform type of the given
     *         instance ID(s). For example, you sent an document for a Windows instance to a Linux instance.</li>
     *         <li>InvalidOutputLocationException The output location is not valid or does not exist.</li>
     *         <li>InvalidParametersException You must specify values for all required parameters in the Systems Manager
     *         document. You can only supply values to parameters defined in the Systems Manager document.</li>
     *         <li>InvalidTargetException The target is not valid or does not exist. It might not be configured for EC2
     *         Systems Manager or you might not have permission to perform the operation.</li>
     *         <li>InvalidScheduleException The schedule is invalid. Verify your cron or rate expression and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.CreateAssociation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateAssociation" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAssociationResponse> createAssociation(
            Consumer<CreateAssociationRequest.Builder> createAssociationRequest) {
        return createAssociation(CreateAssociationRequest.builder().apply(createAssociationRequest).build());
    }

    /**
     * <p>
     * Associates the specified Systems Manager document with the specified instances or targets.
     * </p>
     * <p>
     * When you associate a document with one or more instances using instance IDs or tags, the SSM Agent running on the
     * instance processes the document and configures the instance as specified.
     * </p>
     * <p>
     * If you associate a document with an instance that already has an associated document, the system throws the
     * AssociationAlreadyExists exception.
     * </p>
     *
     * @param createAssociationBatchRequest
     * @return A Java Future containing the result of the CreateAssociationBatch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentException The specified document does not exist.</li>
     *         <li>InvalidDocumentVersionException The document version is not valid or does not exist.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidParametersException You must specify values for all required parameters in the Systems Manager
     *         document. You can only supply values to parameters defined in the Systems Manager document.</li>
     *         <li>DuplicateInstanceIdException You cannot specify an instance ID in more than one association.</li>
     *         <li>AssociationLimitExceededException You can have at most 2,000 active associations.</li>
     *         <li>UnsupportedPlatformTypeException The document does not support the platform type of the given
     *         instance ID(s). For example, you sent an document for a Windows instance to a Linux instance.</li>
     *         <li>InvalidOutputLocationException The output location is not valid or does not exist.</li>
     *         <li>InvalidTargetException The target is not valid or does not exist. It might not be configured for EC2
     *         Systems Manager or you might not have permission to perform the operation.</li>
     *         <li>InvalidScheduleException The schedule is invalid. Verify your cron or rate expression and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.CreateAssociationBatch
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateAssociationBatch" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAssociationBatchResponse> createAssociationBatch(
            CreateAssociationBatchRequest createAssociationBatchRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified Systems Manager document with the specified instances or targets.
     * </p>
     * <p>
     * When you associate a document with one or more instances using instance IDs or tags, the SSM Agent running on the
     * instance processes the document and configures the instance as specified.
     * </p>
     * <p>
     * If you associate a document with an instance that already has an associated document, the system throws the
     * AssociationAlreadyExists exception.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link CreateAssociationBatchRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAssociationBatchRequest#builder()}
     *
     * @param createAssociationBatchRequest
     *        a {@link Consumer} that will call methods on {@link CreateAssociationBatchRequest.Builder}.
     * @return A Java Future containing the result of the CreateAssociationBatch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentException The specified document does not exist.</li>
     *         <li>InvalidDocumentVersionException The document version is not valid or does not exist.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidParametersException You must specify values for all required parameters in the Systems Manager
     *         document. You can only supply values to parameters defined in the Systems Manager document.</li>
     *         <li>DuplicateInstanceIdException You cannot specify an instance ID in more than one association.</li>
     *         <li>AssociationLimitExceededException You can have at most 2,000 active associations.</li>
     *         <li>UnsupportedPlatformTypeException The document does not support the platform type of the given
     *         instance ID(s). For example, you sent an document for a Windows instance to a Linux instance.</li>
     *         <li>InvalidOutputLocationException The output location is not valid or does not exist.</li>
     *         <li>InvalidTargetException The target is not valid or does not exist. It might not be configured for EC2
     *         Systems Manager or you might not have permission to perform the operation.</li>
     *         <li>InvalidScheduleException The schedule is invalid. Verify your cron or rate expression and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.CreateAssociationBatch
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateAssociationBatch" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAssociationBatchResponse> createAssociationBatch(
            Consumer<CreateAssociationBatchRequest.Builder> createAssociationBatchRequest) {
        return createAssociationBatch(CreateAssociationBatchRequest.builder().apply(createAssociationBatchRequest).build());
    }

    /**
     * <p>
     * Creates a Systems Manager document.
     * </p>
     * <p>
     * After you create a document, you can use CreateAssociation to associate it with one or more running instances.
     * </p>
     *
     * @param createDocumentRequest
     * @return A Java Future containing the result of the CreateDocument operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DocumentAlreadyExistsException The specified document already exists.</li>
     *         <li>MaxDocumentSizeExceededException The size limit of a document is 64 KB.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentContentException The content for the document is not valid.</li>
     *         <li>DocumentLimitExceededException You can have at most 200 active Systems Manager documents.</li>
     *         <li>InvalidDocumentSchemaVersionException The version of the document schema is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.CreateDocument
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateDocument" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDocumentResponse> createDocument(CreateDocumentRequest createDocumentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Systems Manager document.
     * </p>
     * <p>
     * After you create a document, you can use CreateAssociation to associate it with one or more running instances.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link CreateDocumentRequest.Builder} avoiding the need to
     * create one manually via {@link CreateDocumentRequest#builder()}
     *
     * @param createDocumentRequest
     *        a {@link Consumer} that will call methods on {@link CreateDocumentRequest.Builder}.
     * @return A Java Future containing the result of the CreateDocument operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DocumentAlreadyExistsException The specified document already exists.</li>
     *         <li>MaxDocumentSizeExceededException The size limit of a document is 64 KB.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentContentException The content for the document is not valid.</li>
     *         <li>DocumentLimitExceededException You can have at most 200 active Systems Manager documents.</li>
     *         <li>InvalidDocumentSchemaVersionException The version of the document schema is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.CreateDocument
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateDocument" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDocumentResponse> createDocument(Consumer<CreateDocumentRequest.Builder> createDocumentRequest) {
        return createDocument(CreateDocumentRequest.builder().apply(createDocumentRequest).build());
    }

    /**
     * <p>
     * Creates a new Maintenance Window.
     * </p>
     *
     * @param createMaintenanceWindowRequest
     * @return A Java Future containing the result of the CreateMaintenanceWindow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>IdempotentParameterMismatchException Error returned when an idempotent operation is retried and the
     *         parameters don't match the original call to the API with the same idempotency token.</li>
     *         <li>ResourceLimitExceededException Error returned when the caller has exceeded the default resource
     *         limits (e.g. too many Maintenance Windows have been created).</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.CreateMaintenanceWindow
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateMaintenanceWindow" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateMaintenanceWindowResponse> createMaintenanceWindow(
            CreateMaintenanceWindowRequest createMaintenanceWindowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Maintenance Window.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link CreateMaintenanceWindowRequest.Builder} avoiding
     * the need to create one manually via {@link CreateMaintenanceWindowRequest#builder()}
     *
     * @param createMaintenanceWindowRequest
     *        a {@link Consumer} that will call methods on {@link CreateMaintenanceWindowRequest.Builder}.
     * @return A Java Future containing the result of the CreateMaintenanceWindow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>IdempotentParameterMismatchException Error returned when an idempotent operation is retried and the
     *         parameters don't match the original call to the API with the same idempotency token.</li>
     *         <li>ResourceLimitExceededException Error returned when the caller has exceeded the default resource
     *         limits (e.g. too many Maintenance Windows have been created).</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.CreateMaintenanceWindow
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateMaintenanceWindow" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateMaintenanceWindowResponse> createMaintenanceWindow(
            Consumer<CreateMaintenanceWindowRequest.Builder> createMaintenanceWindowRequest) {
        return createMaintenanceWindow(CreateMaintenanceWindowRequest.builder().apply(createMaintenanceWindowRequest).build());
    }

    /**
     * <p>
     * Creates a patch baseline.
     * </p>
     *
     * @param createPatchBaselineRequest
     * @return A Java Future containing the result of the CreatePatchBaseline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>IdempotentParameterMismatchException Error returned when an idempotent operation is retried and the
     *         parameters don't match the original call to the API with the same idempotency token.</li>
     *         <li>ResourceLimitExceededException Error returned when the caller has exceeded the default resource
     *         limits (e.g. too many Maintenance Windows have been created).</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.CreatePatchBaseline
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreatePatchBaseline" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreatePatchBaselineResponse> createPatchBaseline(
            CreatePatchBaselineRequest createPatchBaselineRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a patch baseline.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link CreatePatchBaselineRequest.Builder} avoiding the
     * need to create one manually via {@link CreatePatchBaselineRequest#builder()}
     *
     * @param createPatchBaselineRequest
     *        a {@link Consumer} that will call methods on {@link CreatePatchBaselineRequest.Builder}.
     * @return A Java Future containing the result of the CreatePatchBaseline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>IdempotentParameterMismatchException Error returned when an idempotent operation is retried and the
     *         parameters don't match the original call to the API with the same idempotency token.</li>
     *         <li>ResourceLimitExceededException Error returned when the caller has exceeded the default resource
     *         limits (e.g. too many Maintenance Windows have been created).</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.CreatePatchBaseline
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreatePatchBaseline" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreatePatchBaselineResponse> createPatchBaseline(
            Consumer<CreatePatchBaselineRequest.Builder> createPatchBaselineRequest) {
        return createPatchBaseline(CreatePatchBaselineRequest.builder().apply(createPatchBaselineRequest).build());
    }

    /**
     * <p>
     * Creates a resource data sync configuration to a single bucket in Amazon S3. This is an asynchronous operation
     * that returns immediately. After a successful initial sync is completed, the system continuously syncs data to the
     * Amazon S3 bucket. To check the status of the sync, use the <a>ListResourceDataSync</a>.
     * </p>
     * <p>
     * By default, data is not encrypted in Amazon S3. We strongly recommend that you enable encryption in Amazon S3 to
     * ensure secure data storage. We also recommend that you secure access to the Amazon S3 bucket by creating a
     * restrictive bucket policy. To view an example of a restrictive Amazon S3 bucket policy for Resource Data Sync,
     * see <a href=
     * "http://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-inventory-configuring.html#sysman-inventory-datasync"
     * >Configuring Resource Data Sync for Inventory</a>.
     * </p>
     *
     * @param createResourceDataSyncRequest
     * @return A Java Future containing the result of the CreateResourceDataSync operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ResourceDataSyncCountExceededException You have exceeded the allowed maximum sync configurations.</li>
     *         <li>ResourceDataSyncAlreadyExistsException A sync configuration with the same name already exists.</li>
     *         <li>ResourceDataSyncInvalidConfigurationException The specified sync configuration is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.CreateResourceDataSync
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateResourceDataSync" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateResourceDataSyncResponse> createResourceDataSync(
            CreateResourceDataSyncRequest createResourceDataSyncRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a resource data sync configuration to a single bucket in Amazon S3. This is an asynchronous operation
     * that returns immediately. After a successful initial sync is completed, the system continuously syncs data to the
     * Amazon S3 bucket. To check the status of the sync, use the <a>ListResourceDataSync</a>.
     * </p>
     * <p>
     * By default, data is not encrypted in Amazon S3. We strongly recommend that you enable encryption in Amazon S3 to
     * ensure secure data storage. We also recommend that you secure access to the Amazon S3 bucket by creating a
     * restrictive bucket policy. To view an example of a restrictive Amazon S3 bucket policy for Resource Data Sync,
     * see <a href=
     * "http://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-inventory-configuring.html#sysman-inventory-datasync"
     * >Configuring Resource Data Sync for Inventory</a>.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link CreateResourceDataSyncRequest.Builder} avoiding the
     * need to create one manually via {@link CreateResourceDataSyncRequest#builder()}
     *
     * @param createResourceDataSyncRequest
     *        a {@link Consumer} that will call methods on {@link CreateResourceDataSyncRequest.Builder}.
     * @return A Java Future containing the result of the CreateResourceDataSync operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ResourceDataSyncCountExceededException You have exceeded the allowed maximum sync configurations.</li>
     *         <li>ResourceDataSyncAlreadyExistsException A sync configuration with the same name already exists.</li>
     *         <li>ResourceDataSyncInvalidConfigurationException The specified sync configuration is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.CreateResourceDataSync
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateResourceDataSync" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateResourceDataSyncResponse> createResourceDataSync(
            Consumer<CreateResourceDataSyncRequest.Builder> createResourceDataSyncRequest) {
        return createResourceDataSync(CreateResourceDataSyncRequest.builder().apply(createResourceDataSyncRequest).build());
    }

    /**
     * <p>
     * Deletes an activation. You are not required to delete an activation. If you delete an activation, you can no
     * longer use it to register additional managed instances. Deleting an activation does not de-register managed
     * instances. You must manually de-register managed instances.
     * </p>
     *
     * @param deleteActivationRequest
     * @return A Java Future containing the result of the DeleteActivation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidActivationIdException The activation ID is not valid. Verify the you entered the correct
     *         ActivationId or ActivationCode and try again.</li>
     *         <li>InvalidActivationException The activation is not valid. The activation might have been deleted, or
     *         the ActivationId and the ActivationCode do not match.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>TooManyUpdatesException There are concurrent updates for a resource that supports one update at a
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DeleteActivation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteActivation" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteActivationResponse> deleteActivation(DeleteActivationRequest deleteActivationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an activation. You are not required to delete an activation. If you delete an activation, you can no
     * longer use it to register additional managed instances. Deleting an activation does not de-register managed
     * instances. You must manually de-register managed instances.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link DeleteActivationRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteActivationRequest#builder()}
     *
     * @param deleteActivationRequest
     *        a {@link Consumer} that will call methods on {@link DeleteActivationRequest.Builder}.
     * @return A Java Future containing the result of the DeleteActivation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidActivationIdException The activation ID is not valid. Verify the you entered the correct
     *         ActivationId or ActivationCode and try again.</li>
     *         <li>InvalidActivationException The activation is not valid. The activation might have been deleted, or
     *         the ActivationId and the ActivationCode do not match.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>TooManyUpdatesException There are concurrent updates for a resource that supports one update at a
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DeleteActivation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteActivation" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteActivationResponse> deleteActivation(
            Consumer<DeleteActivationRequest.Builder> deleteActivationRequest) {
        return deleteActivation(DeleteActivationRequest.builder().apply(deleteActivationRequest).build());
    }

    /**
     * <p>
     * Disassociates the specified Systems Manager document from the specified instance.
     * </p>
     * <p>
     * When you disassociate a document from an instance, it does not change the configuration of the instance. To
     * change the configuration state of an instance after you disassociate a document, you must create a new document
     * with the desired configuration and associate it with the instance.
     * </p>
     *
     * @param deleteAssociationRequest
     * @return A Java Future containing the result of the DeleteAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AssociationDoesNotExistException The specified association does not exist.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentException The specified document does not exist.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>TooManyUpdatesException There are concurrent updates for a resource that supports one update at a
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DeleteAssociation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteAssociation" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAssociationResponse> deleteAssociation(DeleteAssociationRequest deleteAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the specified Systems Manager document from the specified instance.
     * </p>
     * <p>
     * When you disassociate a document from an instance, it does not change the configuration of the instance. To
     * change the configuration state of an instance after you disassociate a document, you must create a new document
     * with the desired configuration and associate it with the instance.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link DeleteAssociationRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAssociationRequest#builder()}
     *
     * @param deleteAssociationRequest
     *        a {@link Consumer} that will call methods on {@link DeleteAssociationRequest.Builder}.
     * @return A Java Future containing the result of the DeleteAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AssociationDoesNotExistException The specified association does not exist.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentException The specified document does not exist.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>TooManyUpdatesException There are concurrent updates for a resource that supports one update at a
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DeleteAssociation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteAssociation" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAssociationResponse> deleteAssociation(
            Consumer<DeleteAssociationRequest.Builder> deleteAssociationRequest) {
        return deleteAssociation(DeleteAssociationRequest.builder().apply(deleteAssociationRequest).build());
    }

    /**
     * <p>
     * Deletes the Systems Manager document and all instance associations to the document.
     * </p>
     * <p>
     * Before you delete the document, we recommend that you use <a>DeleteAssociation</a> to disassociate all instances
     * that are associated with the document.
     * </p>
     *
     * @param deleteDocumentRequest
     * @return A Java Future containing the result of the DeleteDocument operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentException The specified document does not exist.</li>
     *         <li>InvalidDocumentOperationException You attempted to delete a document while it is still shared. You
     *         must stop sharing the document before you can delete it.</li>
     *         <li>AssociatedInstancesException You must disassociate a document from all instances before you can
     *         delete it.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DeleteDocument
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteDocument" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDocumentResponse> deleteDocument(DeleteDocumentRequest deleteDocumentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the Systems Manager document and all instance associations to the document.
     * </p>
     * <p>
     * Before you delete the document, we recommend that you use <a>DeleteAssociation</a> to disassociate all instances
     * that are associated with the document.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link DeleteDocumentRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDocumentRequest#builder()}
     *
     * @param deleteDocumentRequest
     *        a {@link Consumer} that will call methods on {@link DeleteDocumentRequest.Builder}.
     * @return A Java Future containing the result of the DeleteDocument operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentException The specified document does not exist.</li>
     *         <li>InvalidDocumentOperationException You attempted to delete a document while it is still shared. You
     *         must stop sharing the document before you can delete it.</li>
     *         <li>AssociatedInstancesException You must disassociate a document from all instances before you can
     *         delete it.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DeleteDocument
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteDocument" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDocumentResponse> deleteDocument(Consumer<DeleteDocumentRequest.Builder> deleteDocumentRequest) {
        return deleteDocument(DeleteDocumentRequest.builder().apply(deleteDocumentRequest).build());
    }

    /**
     * <p>
     * Deletes a Maintenance Window.
     * </p>
     *
     * @param deleteMaintenanceWindowRequest
     * @return A Java Future containing the result of the DeleteMaintenanceWindow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DeleteMaintenanceWindow
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteMaintenanceWindow" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteMaintenanceWindowResponse> deleteMaintenanceWindow(
            DeleteMaintenanceWindowRequest deleteMaintenanceWindowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Maintenance Window.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link DeleteMaintenanceWindowRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteMaintenanceWindowRequest#builder()}
     *
     * @param deleteMaintenanceWindowRequest
     *        a {@link Consumer} that will call methods on {@link DeleteMaintenanceWindowRequest.Builder}.
     * @return A Java Future containing the result of the DeleteMaintenanceWindow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DeleteMaintenanceWindow
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteMaintenanceWindow" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteMaintenanceWindowResponse> deleteMaintenanceWindow(
            Consumer<DeleteMaintenanceWindowRequest.Builder> deleteMaintenanceWindowRequest) {
        return deleteMaintenanceWindow(DeleteMaintenanceWindowRequest.builder().apply(deleteMaintenanceWindowRequest).build());
    }

    /**
     * <p>
     * Delete a parameter from the system.
     * </p>
     *
     * @param deleteParameterRequest
     * @return A Java Future containing the result of the DeleteParameter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ParameterNotFoundException The parameter could not be found. Verify the name and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DeleteParameter
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteParameter" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteParameterResponse> deleteParameter(DeleteParameterRequest deleteParameterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a parameter from the system.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link DeleteParameterRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteParameterRequest#builder()}
     *
     * @param deleteParameterRequest
     *        a {@link Consumer} that will call methods on {@link DeleteParameterRequest.Builder}.
     * @return A Java Future containing the result of the DeleteParameter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ParameterNotFoundException The parameter could not be found. Verify the name and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DeleteParameter
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteParameter" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteParameterResponse> deleteParameter(
            Consumer<DeleteParameterRequest.Builder> deleteParameterRequest) {
        return deleteParameter(DeleteParameterRequest.builder().apply(deleteParameterRequest).build());
    }

    /**
     * <p>
     * Delete a list of parameters. This API is used to delete parameters by using the Amazon EC2 console.
     * </p>
     *
     * @param deleteParametersRequest
     * @return A Java Future containing the result of the DeleteParameters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DeleteParameters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteParameters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteParametersResponse> deleteParameters(DeleteParametersRequest deleteParametersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a list of parameters. This API is used to delete parameters by using the Amazon EC2 console.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link DeleteParametersRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteParametersRequest#builder()}
     *
     * @param deleteParametersRequest
     *        a {@link Consumer} that will call methods on {@link DeleteParametersRequest.Builder}.
     * @return A Java Future containing the result of the DeleteParameters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DeleteParameters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteParameters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteParametersResponse> deleteParameters(
            Consumer<DeleteParametersRequest.Builder> deleteParametersRequest) {
        return deleteParameters(DeleteParametersRequest.builder().apply(deleteParametersRequest).build());
    }

    /**
     * <p>
     * Deletes a patch baseline.
     * </p>
     *
     * @param deletePatchBaselineRequest
     * @return A Java Future containing the result of the DeletePatchBaseline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException Error returned if an attempt is made to delete a patch baseline that is
     *         registered for a patch group.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DeletePatchBaseline
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeletePatchBaseline" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeletePatchBaselineResponse> deletePatchBaseline(
            DeletePatchBaselineRequest deletePatchBaselineRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a patch baseline.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link DeletePatchBaselineRequest.Builder} avoiding the
     * need to create one manually via {@link DeletePatchBaselineRequest#builder()}
     *
     * @param deletePatchBaselineRequest
     *        a {@link Consumer} that will call methods on {@link DeletePatchBaselineRequest.Builder}.
     * @return A Java Future containing the result of the DeletePatchBaseline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException Error returned if an attempt is made to delete a patch baseline that is
     *         registered for a patch group.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DeletePatchBaseline
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeletePatchBaseline" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeletePatchBaselineResponse> deletePatchBaseline(
            Consumer<DeletePatchBaselineRequest.Builder> deletePatchBaselineRequest) {
        return deletePatchBaseline(DeletePatchBaselineRequest.builder().apply(deletePatchBaselineRequest).build());
    }

    /**
     * <p>
     * Deletes a Resource Data Sync configuration. After the configuration is deleted, changes to inventory data on
     * managed instances are no longer synced with the target Amazon S3 bucket. Deleting a sync configuration does not
     * delete data in the target Amazon S3 bucket.
     * </p>
     *
     * @param deleteResourceDataSyncRequest
     * @return A Java Future containing the result of the DeleteResourceDataSync operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ResourceDataSyncNotFoundException The specified sync name was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DeleteResourceDataSync
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteResourceDataSync" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteResourceDataSyncResponse> deleteResourceDataSync(
            DeleteResourceDataSyncRequest deleteResourceDataSyncRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Resource Data Sync configuration. After the configuration is deleted, changes to inventory data on
     * managed instances are no longer synced with the target Amazon S3 bucket. Deleting a sync configuration does not
     * delete data in the target Amazon S3 bucket.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link DeleteResourceDataSyncRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteResourceDataSyncRequest#builder()}
     *
     * @param deleteResourceDataSyncRequest
     *        a {@link Consumer} that will call methods on {@link DeleteResourceDataSyncRequest.Builder}.
     * @return A Java Future containing the result of the DeleteResourceDataSync operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ResourceDataSyncNotFoundException The specified sync name was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DeleteResourceDataSync
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteResourceDataSync" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteResourceDataSyncResponse> deleteResourceDataSync(
            Consumer<DeleteResourceDataSyncRequest.Builder> deleteResourceDataSyncRequest) {
        return deleteResourceDataSync(DeleteResourceDataSyncRequest.builder().apply(deleteResourceDataSyncRequest).build());
    }

    /**
     * <p>
     * Removes the server or virtual machine from the list of registered servers. You can reregister the instance again
     * at any time. If you don't plan to use Run Command on the server, we suggest uninstalling the SSM Agent first.
     * </p>
     *
     * @param deregisterManagedInstanceRequest
     * @return A Java Future containing the result of the DeregisterManagedInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DeregisterManagedInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeregisterManagedInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeregisterManagedInstanceResponse> deregisterManagedInstance(
            DeregisterManagedInstanceRequest deregisterManagedInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the server or virtual machine from the list of registered servers. You can reregister the instance again
     * at any time. If you don't plan to use Run Command on the server, we suggest uninstalling the SSM Agent first.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link DeregisterManagedInstanceRequest.Builder} avoiding
     * the need to create one manually via {@link DeregisterManagedInstanceRequest#builder()}
     *
     * @param deregisterManagedInstanceRequest
     *        a {@link Consumer} that will call methods on {@link DeregisterManagedInstanceRequest.Builder}.
     * @return A Java Future containing the result of the DeregisterManagedInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DeregisterManagedInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeregisterManagedInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeregisterManagedInstanceResponse> deregisterManagedInstance(
            Consumer<DeregisterManagedInstanceRequest.Builder> deregisterManagedInstanceRequest) {
        return deregisterManagedInstance(DeregisterManagedInstanceRequest.builder().apply(deregisterManagedInstanceRequest)
                .build());
    }

    /**
     * <p>
     * Removes a patch group from a patch baseline.
     * </p>
     *
     * @param deregisterPatchBaselineForPatchGroupRequest
     * @return A Java Future containing the result of the DeregisterPatchBaselineForPatchGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidResourceIdException The resource ID is not valid. Verify that you entered the correct ID and
     *         try again.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DeregisterPatchBaselineForPatchGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeregisterPatchBaselineForPatchGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterPatchBaselineForPatchGroupResponse> deregisterPatchBaselineForPatchGroup(
            DeregisterPatchBaselineForPatchGroupRequest deregisterPatchBaselineForPatchGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a patch group from a patch baseline.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the
     * {@link DeregisterPatchBaselineForPatchGroupRequest.Builder} avoiding the need to create one manually via
     * {@link DeregisterPatchBaselineForPatchGroupRequest#builder()}
     *
     * @param deregisterPatchBaselineForPatchGroupRequest
     *        a {@link Consumer} that will call methods on {@link DeregisterPatchBaselineForPatchGroupRequest.Builder}.
     * @return A Java Future containing the result of the DeregisterPatchBaselineForPatchGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidResourceIdException The resource ID is not valid. Verify that you entered the correct ID and
     *         try again.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DeregisterPatchBaselineForPatchGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeregisterPatchBaselineForPatchGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterPatchBaselineForPatchGroupResponse> deregisterPatchBaselineForPatchGroup(
            Consumer<DeregisterPatchBaselineForPatchGroupRequest.Builder> deregisterPatchBaselineForPatchGroupRequest) {
        return deregisterPatchBaselineForPatchGroup(DeregisterPatchBaselineForPatchGroupRequest.builder()
                .apply(deregisterPatchBaselineForPatchGroupRequest).build());
    }

    /**
     * <p>
     * Removes a target from a Maintenance Window.
     * </p>
     *
     * @param deregisterTargetFromMaintenanceWindowRequest
     * @return A Java Future containing the result of the DeregisterTargetFromMaintenanceWindow operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource (e.g. a Maintenance Window)
     *         doesn't exist.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>TargetInUseException You specified the <code>Safe</code> option for the
     *         DeregisterTargetFromMaintenanceWindow operation, but the target is still referenced in a task.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DeregisterTargetFromMaintenanceWindow
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeregisterTargetFromMaintenanceWindow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterTargetFromMaintenanceWindowResponse> deregisterTargetFromMaintenanceWindow(
            DeregisterTargetFromMaintenanceWindowRequest deregisterTargetFromMaintenanceWindowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a target from a Maintenance Window.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the
     * {@link DeregisterTargetFromMaintenanceWindowRequest.Builder} avoiding the need to create one manually via
     * {@link DeregisterTargetFromMaintenanceWindowRequest#builder()}
     *
     * @param deregisterTargetFromMaintenanceWindowRequest
     *        a {@link Consumer} that will call methods on {@link DeregisterTargetFromMaintenanceWindowRequest.Builder}.
     * @return A Java Future containing the result of the DeregisterTargetFromMaintenanceWindow operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource (e.g. a Maintenance Window)
     *         doesn't exist.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>TargetInUseException You specified the <code>Safe</code> option for the
     *         DeregisterTargetFromMaintenanceWindow operation, but the target is still referenced in a task.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DeregisterTargetFromMaintenanceWindow
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeregisterTargetFromMaintenanceWindow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterTargetFromMaintenanceWindowResponse> deregisterTargetFromMaintenanceWindow(
            Consumer<DeregisterTargetFromMaintenanceWindowRequest.Builder> deregisterTargetFromMaintenanceWindowRequest) {
        return deregisterTargetFromMaintenanceWindow(DeregisterTargetFromMaintenanceWindowRequest.builder()
                .apply(deregisterTargetFromMaintenanceWindowRequest).build());
    }

    /**
     * <p>
     * Removes a task from a Maintenance Window.
     * </p>
     *
     * @param deregisterTaskFromMaintenanceWindowRequest
     * @return A Java Future containing the result of the DeregisterTaskFromMaintenanceWindow operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource (e.g. a Maintenance Window)
     *         doesn't exist.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DeregisterTaskFromMaintenanceWindow
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeregisterTaskFromMaintenanceWindow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterTaskFromMaintenanceWindowResponse> deregisterTaskFromMaintenanceWindow(
            DeregisterTaskFromMaintenanceWindowRequest deregisterTaskFromMaintenanceWindowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a task from a Maintenance Window.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link DeregisterTaskFromMaintenanceWindowRequest.Builder}
     * avoiding the need to create one manually via {@link DeregisterTaskFromMaintenanceWindowRequest#builder()}
     *
     * @param deregisterTaskFromMaintenanceWindowRequest
     *        a {@link Consumer} that will call methods on {@link DeregisterTaskFromMaintenanceWindowRequest.Builder}.
     * @return A Java Future containing the result of the DeregisterTaskFromMaintenanceWindow operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource (e.g. a Maintenance Window)
     *         doesn't exist.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DeregisterTaskFromMaintenanceWindow
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeregisterTaskFromMaintenanceWindow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterTaskFromMaintenanceWindowResponse> deregisterTaskFromMaintenanceWindow(
            Consumer<DeregisterTaskFromMaintenanceWindowRequest.Builder> deregisterTaskFromMaintenanceWindowRequest) {
        return deregisterTaskFromMaintenanceWindow(DeregisterTaskFromMaintenanceWindowRequest.builder()
                .apply(deregisterTaskFromMaintenanceWindowRequest).build());
    }

    /**
     * <p>
     * Details about the activation, including: the date and time the activation was created, the expiration date, the
     * IAM role assigned to the instances in the activation, and the number of instances activated by this registration.
     * </p>
     *
     * @param describeActivationsRequest
     * @return A Java Future containing the result of the DescribeActivations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DescribeActivations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeActivations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeActivationsResponse> describeActivations(
            DescribeActivationsRequest describeActivationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Details about the activation, including: the date and time the activation was created, the expiration date, the
     * IAM role assigned to the instances in the activation, and the number of instances activated by this registration.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeActivations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DescribeActivations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeActivations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeActivationsResponse> describeActivations() {
        return describeActivations(DescribeActivationsRequest.builder().build());
    }

    /**
     * <p>
     * Details about the activation, including: the date and time the activation was created, the expiration date, the
     * IAM role assigned to the instances in the activation, and the number of instances activated by this registration.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link DescribeActivationsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeActivationsRequest#builder()}
     *
     * @param describeActivationsRequest
     *        a {@link Consumer} that will call methods on {@link DescribeActivationsRequest.Builder}.
     * @return A Java Future containing the result of the DescribeActivations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DescribeActivations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeActivations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeActivationsResponse> describeActivations(
            Consumer<DescribeActivationsRequest.Builder> describeActivationsRequest) {
        return describeActivations(DescribeActivationsRequest.builder().apply(describeActivationsRequest).build());
    }

    /**
     * <p>
     * Describes the association for the specified target or instance. If you created the association by using the
     * <code>Targets</code> parameter, then you must retrieve the association by using the association ID. If you
     * created the association by specifying an instance ID and a Systems Manager document, then you retrieve the
     * association by specifying the document name and the instance ID.
     * </p>
     *
     * @param describeAssociationRequest
     * @return A Java Future containing the result of the DescribeAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AssociationDoesNotExistException The specified association does not exist.</li>
     *         <li>InvalidAssociationVersionException The version you specified is not valid. Use
     *         ListAssociationVersions to view all versions of an association according to the association ID. Or, use
     *         the <code>&#36LATEST</code> parameter to view the latest version of the association.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentException The specified document does not exist.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DescribeAssociation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAssociation" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeAssociationResponse> describeAssociation(
            DescribeAssociationRequest describeAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the association for the specified target or instance. If you created the association by using the
     * <code>Targets</code> parameter, then you must retrieve the association by using the association ID. If you
     * created the association by specifying an instance ID and a Systems Manager document, then you retrieve the
     * association by specifying the document name and the instance ID.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link DescribeAssociationRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeAssociationRequest#builder()}
     *
     * @param describeAssociationRequest
     *        a {@link Consumer} that will call methods on {@link DescribeAssociationRequest.Builder}.
     * @return A Java Future containing the result of the DescribeAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AssociationDoesNotExistException The specified association does not exist.</li>
     *         <li>InvalidAssociationVersionException The version you specified is not valid. Use
     *         ListAssociationVersions to view all versions of an association according to the association ID. Or, use
     *         the <code>&#36LATEST</code> parameter to view the latest version of the association.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentException The specified document does not exist.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DescribeAssociation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAssociation" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeAssociationResponse> describeAssociation(
            Consumer<DescribeAssociationRequest.Builder> describeAssociationRequest) {
        return describeAssociation(DescribeAssociationRequest.builder().apply(describeAssociationRequest).build());
    }

    /**
     * <p>
     * Provides details about all active and terminated Automation executions.
     * </p>
     *
     * @param describeAutomationExecutionsRequest
     * @return A Java Future containing the result of the DescribeAutomationExecutions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DescribeAutomationExecutions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAutomationExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAutomationExecutionsResponse> describeAutomationExecutions(
            DescribeAutomationExecutionsRequest describeAutomationExecutionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides details about all active and terminated Automation executions.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeAutomationExecutions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DescribeAutomationExecutions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAutomationExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAutomationExecutionsResponse> describeAutomationExecutions() {
        return describeAutomationExecutions(DescribeAutomationExecutionsRequest.builder().build());
    }

    /**
     * <p>
     * Provides details about all active and terminated Automation executions.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link DescribeAutomationExecutionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAutomationExecutionsRequest#builder()}
     *
     * @param describeAutomationExecutionsRequest
     *        a {@link Consumer} that will call methods on {@link DescribeAutomationExecutionsRequest.Builder}.
     * @return A Java Future containing the result of the DescribeAutomationExecutions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DescribeAutomationExecutions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAutomationExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAutomationExecutionsResponse> describeAutomationExecutions(
            Consumer<DescribeAutomationExecutionsRequest.Builder> describeAutomationExecutionsRequest) {
        return describeAutomationExecutions(DescribeAutomationExecutionsRequest.builder()
                .apply(describeAutomationExecutionsRequest).build());
    }

    /**
     * <p>
     * Lists all patches that could possibly be included in a patch baseline.
     * </p>
     *
     * @param describeAvailablePatchesRequest
     * @return A Java Future containing the result of the DescribeAvailablePatches operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DescribeAvailablePatches
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAvailablePatches" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeAvailablePatchesResponse> describeAvailablePatches(
            DescribeAvailablePatchesRequest describeAvailablePatchesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all patches that could possibly be included in a patch baseline.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeAvailablePatches operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DescribeAvailablePatches
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAvailablePatches" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeAvailablePatchesResponse> describeAvailablePatches() {
        return describeAvailablePatches(DescribeAvailablePatchesRequest.builder().build());
    }

    /**
     * <p>
     * Lists all patches that could possibly be included in a patch baseline.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link DescribeAvailablePatchesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeAvailablePatchesRequest#builder()}
     *
     * @param describeAvailablePatchesRequest
     *        a {@link Consumer} that will call methods on {@link DescribeAvailablePatchesRequest.Builder}.
     * @return A Java Future containing the result of the DescribeAvailablePatches operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DescribeAvailablePatches
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAvailablePatches" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeAvailablePatchesResponse> describeAvailablePatches(
            Consumer<DescribeAvailablePatchesRequest.Builder> describeAvailablePatchesRequest) {
        return describeAvailablePatches(DescribeAvailablePatchesRequest.builder().apply(describeAvailablePatchesRequest).build());
    }

    /**
     * <p>
     * Describes the specified Systems Manager document.
     * </p>
     *
     * @param describeDocumentRequest
     * @return A Java Future containing the result of the DescribeDocument operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentException The specified document does not exist.</li>
     *         <li>InvalidDocumentVersionException The document version is not valid or does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DescribeDocument
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeDocument" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDocumentResponse> describeDocument(DescribeDocumentRequest describeDocumentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified Systems Manager document.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link DescribeDocumentRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeDocumentRequest#builder()}
     *
     * @param describeDocumentRequest
     *        a {@link Consumer} that will call methods on {@link DescribeDocumentRequest.Builder}.
     * @return A Java Future containing the result of the DescribeDocument operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentException The specified document does not exist.</li>
     *         <li>InvalidDocumentVersionException The document version is not valid or does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DescribeDocument
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeDocument" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDocumentResponse> describeDocument(
            Consumer<DescribeDocumentRequest.Builder> describeDocumentRequest) {
        return describeDocument(DescribeDocumentRequest.builder().apply(describeDocumentRequest).build());
    }

    /**
     * <p>
     * Describes the permissions for a Systems Manager document. If you created the document, you are the owner. If a
     * document is shared, it can either be shared privately (by specifying a user's AWS account ID) or publicly
     * (<i>All</i>).
     * </p>
     *
     * @param describeDocumentPermissionRequest
     * @return A Java Future containing the result of the DescribeDocumentPermission operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentException The specified document does not exist.</li>
     *         <li>InvalidPermissionTypeException The permission type is not supported. <i>Share</i> is the only
     *         supported permission type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DescribeDocumentPermission
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeDocumentPermission" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDocumentPermissionResponse> describeDocumentPermission(
            DescribeDocumentPermissionRequest describeDocumentPermissionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the permissions for a Systems Manager document. If you created the document, you are the owner. If a
     * document is shared, it can either be shared privately (by specifying a user's AWS account ID) or publicly
     * (<i>All</i>).
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link DescribeDocumentPermissionRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDocumentPermissionRequest#builder()}
     *
     * @param describeDocumentPermissionRequest
     *        a {@link Consumer} that will call methods on {@link DescribeDocumentPermissionRequest.Builder}.
     * @return A Java Future containing the result of the DescribeDocumentPermission operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentException The specified document does not exist.</li>
     *         <li>InvalidPermissionTypeException The permission type is not supported. <i>Share</i> is the only
     *         supported permission type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DescribeDocumentPermission
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeDocumentPermission" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDocumentPermissionResponse> describeDocumentPermission(
            Consumer<DescribeDocumentPermissionRequest.Builder> describeDocumentPermissionRequest) {
        return describeDocumentPermission(DescribeDocumentPermissionRequest.builder().apply(describeDocumentPermissionRequest)
                .build());
    }

    /**
     * <p>
     * All associations for the instance(s).
     * </p>
     *
     * @param describeEffectiveInstanceAssociationsRequest
     * @return A Java Future containing the result of the DescribeEffectiveInstanceAssociations operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DescribeEffectiveInstanceAssociations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeEffectiveInstanceAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEffectiveInstanceAssociationsResponse> describeEffectiveInstanceAssociations(
            DescribeEffectiveInstanceAssociationsRequest describeEffectiveInstanceAssociationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * All associations for the instance(s).
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the
     * {@link DescribeEffectiveInstanceAssociationsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeEffectiveInstanceAssociationsRequest#builder()}
     *
     * @param describeEffectiveInstanceAssociationsRequest
     *        a {@link Consumer} that will call methods on {@link DescribeEffectiveInstanceAssociationsRequest.Builder}.
     * @return A Java Future containing the result of the DescribeEffectiveInstanceAssociations operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DescribeEffectiveInstanceAssociations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeEffectiveInstanceAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEffectiveInstanceAssociationsResponse> describeEffectiveInstanceAssociations(
            Consumer<DescribeEffectiveInstanceAssociationsRequest.Builder> describeEffectiveInstanceAssociationsRequest) {
        return describeEffectiveInstanceAssociations(DescribeEffectiveInstanceAssociationsRequest.builder()
                .apply(describeEffectiveInstanceAssociationsRequest).build());
    }

    /**
     * <p>
     * Retrieves the current effective patches (the patch and the approval state) for the specified patch baseline. Note
     * that this API applies only to Windows patch baselines.
     * </p>
     *
     * @param describeEffectivePatchesForPatchBaselineRequest
     * @return A Java Future containing the result of the DescribeEffectivePatchesForPatchBaseline operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidResourceIdException The resource ID is not valid. Verify that you entered the correct ID and
     *         try again.</li>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource (e.g. a Maintenance Window)
     *         doesn't exist.</li>
     *         <li>UnsupportedOperatingSystemException The operating systems you specified is not supported, or the
     *         operation is not supported for the operating system. Valid operating systems include: Windows,
     *         AmazonLinux, RedhatEnterpriseLinux, and Ubuntu.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DescribeEffectivePatchesForPatchBaseline
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeEffectivePatchesForPatchBaseline"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEffectivePatchesForPatchBaselineResponse> describeEffectivePatchesForPatchBaseline(
            DescribeEffectivePatchesForPatchBaselineRequest describeEffectivePatchesForPatchBaselineRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the current effective patches (the patch and the approval state) for the specified patch baseline. Note
     * that this API applies only to Windows patch baselines.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the
     * {@link DescribeEffectivePatchesForPatchBaselineRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeEffectivePatchesForPatchBaselineRequest#builder()}
     *
     * @param describeEffectivePatchesForPatchBaselineRequest
     *        a {@link Consumer} that will call methods on
     *        {@link DescribeEffectivePatchesForPatchBaselineRequest.Builder}.
     * @return A Java Future containing the result of the DescribeEffectivePatchesForPatchBaseline operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidResourceIdException The resource ID is not valid. Verify that you entered the correct ID and
     *         try again.</li>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource (e.g. a Maintenance Window)
     *         doesn't exist.</li>
     *         <li>UnsupportedOperatingSystemException The operating systems you specified is not supported, or the
     *         operation is not supported for the operating system. Valid operating systems include: Windows,
     *         AmazonLinux, RedhatEnterpriseLinux, and Ubuntu.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DescribeEffectivePatchesForPatchBaseline
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeEffectivePatchesForPatchBaseline"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEffectivePatchesForPatchBaselineResponse> describeEffectivePatchesForPatchBaseline(
            Consumer<DescribeEffectivePatchesForPatchBaselineRequest.Builder> describeEffectivePatchesForPatchBaselineRequest) {
        return describeEffectivePatchesForPatchBaseline(DescribeEffectivePatchesForPatchBaselineRequest.builder()
                .apply(describeEffectivePatchesForPatchBaselineRequest).build());
    }

    /**
     * <p>
     * The status of the associations for the instance(s).
     * </p>
     *
     * @param describeInstanceAssociationsStatusRequest
     * @return A Java Future containing the result of the DescribeInstanceAssociationsStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DescribeInstanceAssociationsStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstanceAssociationsStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeInstanceAssociationsStatusResponse> describeInstanceAssociationsStatus(
            DescribeInstanceAssociationsStatusRequest describeInstanceAssociationsStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The status of the associations for the instance(s).
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link DescribeInstanceAssociationsStatusRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeInstanceAssociationsStatusRequest#builder()}
     *
     * @param describeInstanceAssociationsStatusRequest
     *        a {@link Consumer} that will call methods on {@link DescribeInstanceAssociationsStatusRequest.Builder}.
     * @return A Java Future containing the result of the DescribeInstanceAssociationsStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DescribeInstanceAssociationsStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstanceAssociationsStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeInstanceAssociationsStatusResponse> describeInstanceAssociationsStatus(
            Consumer<DescribeInstanceAssociationsStatusRequest.Builder> describeInstanceAssociationsStatusRequest) {
        return describeInstanceAssociationsStatus(DescribeInstanceAssociationsStatusRequest.builder()
                .apply(describeInstanceAssociationsStatusRequest).build());
    }

    /**
     * <p>
     * Describes one or more of your instances. You can use this to get information about instances like the operating
     * system platform, the SSM Agent version (Linux), status etc. If you specify one or more instance IDs, it returns
     * information for those instances. If you do not specify instance IDs, it returns information for all your
     * instances. If you specify an instance ID that is not valid or an instance that you do not own, you receive an
     * error.
     * </p>
     *
     * @param describeInstanceInformationRequest
     * @return A Java Future containing the result of the DescribeInstanceInformation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InvalidInstanceInformationFilterValueException The specified filter value is not valid.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DescribeInstanceInformation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstanceInformation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeInstanceInformationResponse> describeInstanceInformation(
            DescribeInstanceInformationRequest describeInstanceInformationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes one or more of your instances. You can use this to get information about instances like the operating
     * system platform, the SSM Agent version (Linux), status etc. If you specify one or more instance IDs, it returns
     * information for those instances. If you do not specify instance IDs, it returns information for all your
     * instances. If you specify an instance ID that is not valid or an instance that you do not own, you receive an
     * error.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeInstanceInformation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InvalidInstanceInformationFilterValueException The specified filter value is not valid.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DescribeInstanceInformation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstanceInformation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeInstanceInformationResponse> describeInstanceInformation() {
        return describeInstanceInformation(DescribeInstanceInformationRequest.builder().build());
    }

    /**
     * <p>
     * Describes one or more of your instances. You can use this to get information about instances like the operating
     * system platform, the SSM Agent version (Linux), status etc. If you specify one or more instance IDs, it returns
     * information for those instances. If you do not specify instance IDs, it returns information for all your
     * instances. If you specify an instance ID that is not valid or an instance that you do not own, you receive an
     * error.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link DescribeInstanceInformationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeInstanceInformationRequest#builder()}
     *
     * @param describeInstanceInformationRequest
     *        a {@link Consumer} that will call methods on {@link DescribeInstanceInformationRequest.Builder}.
     * @return A Java Future containing the result of the DescribeInstanceInformation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InvalidInstanceInformationFilterValueException The specified filter value is not valid.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DescribeInstanceInformation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstanceInformation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeInstanceInformationResponse> describeInstanceInformation(
            Consumer<DescribeInstanceInformationRequest.Builder> describeInstanceInformationRequest) {
        return describeInstanceInformation(DescribeInstanceInformationRequest.builder().apply(describeInstanceInformationRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the high-level patch state of one or more instances.
     * </p>
     *
     * @param describeInstancePatchStatesRequest
     * @return A Java Future containing the result of the DescribeInstancePatchStates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DescribeInstancePatchStates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatchStates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeInstancePatchStatesResponse> describeInstancePatchStates(
            DescribeInstancePatchStatesRequest describeInstancePatchStatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the high-level patch state of one or more instances.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link DescribeInstancePatchStatesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeInstancePatchStatesRequest#builder()}
     *
     * @param describeInstancePatchStatesRequest
     *        a {@link Consumer} that will call methods on {@link DescribeInstancePatchStatesRequest.Builder}.
     * @return A Java Future containing the result of the DescribeInstancePatchStates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DescribeInstancePatchStates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatchStates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeInstancePatchStatesResponse> describeInstancePatchStates(
            Consumer<DescribeInstancePatchStatesRequest.Builder> describeInstancePatchStatesRequest) {
        return describeInstancePatchStates(DescribeInstancePatchStatesRequest.builder().apply(describeInstancePatchStatesRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the high-level patch state for the instances in the specified patch group.
     * </p>
     *
     * @param describeInstancePatchStatesForPatchGroupRequest
     * @return A Java Future containing the result of the DescribeInstancePatchStatesForPatchGroup operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DescribeInstancePatchStatesForPatchGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatchStatesForPatchGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeInstancePatchStatesForPatchGroupResponse> describeInstancePatchStatesForPatchGroup(
            DescribeInstancePatchStatesForPatchGroupRequest describeInstancePatchStatesForPatchGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the high-level patch state for the instances in the specified patch group.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the
     * {@link DescribeInstancePatchStatesForPatchGroupRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeInstancePatchStatesForPatchGroupRequest#builder()}
     *
     * @param describeInstancePatchStatesForPatchGroupRequest
     *        a {@link Consumer} that will call methods on
     *        {@link DescribeInstancePatchStatesForPatchGroupRequest.Builder}.
     * @return A Java Future containing the result of the DescribeInstancePatchStatesForPatchGroup operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DescribeInstancePatchStatesForPatchGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatchStatesForPatchGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeInstancePatchStatesForPatchGroupResponse> describeInstancePatchStatesForPatchGroup(
            Consumer<DescribeInstancePatchStatesForPatchGroupRequest.Builder> describeInstancePatchStatesForPatchGroupRequest) {
        return describeInstancePatchStatesForPatchGroup(DescribeInstancePatchStatesForPatchGroupRequest.builder()
                .apply(describeInstancePatchStatesForPatchGroupRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the patches on the specified instance and their state relative to the patch baseline
     * being used for the instance.
     * </p>
     *
     * @param describeInstancePatchesRequest
     * @return A Java Future containing the result of the DescribeInstancePatches operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DescribeInstancePatches
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatches" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeInstancePatchesResponse> describeInstancePatches(
            DescribeInstancePatchesRequest describeInstancePatchesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the patches on the specified instance and their state relative to the patch baseline
     * being used for the instance.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link DescribeInstancePatchesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeInstancePatchesRequest#builder()}
     *
     * @param describeInstancePatchesRequest
     *        a {@link Consumer} that will call methods on {@link DescribeInstancePatchesRequest.Builder}.
     * @return A Java Future containing the result of the DescribeInstancePatches operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DescribeInstancePatches
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatches" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeInstancePatchesResponse> describeInstancePatches(
            Consumer<DescribeInstancePatchesRequest.Builder> describeInstancePatchesRequest) {
        return describeInstancePatches(DescribeInstancePatchesRequest.builder().apply(describeInstancePatchesRequest).build());
    }

    /**
     * <p>
     * Retrieves the individual task executions (one per target) for a particular task executed as part of a Maintenance
     * Window execution.
     * </p>
     *
     * @param describeMaintenanceWindowExecutionTaskInvocationsRequest
     * @return A Java Future containing the result of the DescribeMaintenanceWindowExecutionTaskInvocations operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource (e.g. a Maintenance Window)
     *         doesn't exist.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DescribeMaintenanceWindowExecutionTaskInvocations
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutionTaskInvocations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMaintenanceWindowExecutionTaskInvocationsResponse> describeMaintenanceWindowExecutionTaskInvocations(
            DescribeMaintenanceWindowExecutionTaskInvocationsRequest describeMaintenanceWindowExecutionTaskInvocationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the individual task executions (one per target) for a particular task executed as part of a Maintenance
     * Window execution.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the
     * {@link DescribeMaintenanceWindowExecutionTaskInvocationsRequest.Builder} avoiding the need to create one manually
     * via {@link DescribeMaintenanceWindowExecutionTaskInvocationsRequest#builder()}
     *
     * @param describeMaintenanceWindowExecutionTaskInvocationsRequest
     *        a {@link Consumer} that will call methods on
     *        {@link DescribeMaintenanceWindowExecutionTaskInvocationsRequest.Builder}.
     * @return A Java Future containing the result of the DescribeMaintenanceWindowExecutionTaskInvocations operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource (e.g. a Maintenance Window)
     *         doesn't exist.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DescribeMaintenanceWindowExecutionTaskInvocations
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutionTaskInvocations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMaintenanceWindowExecutionTaskInvocationsResponse> describeMaintenanceWindowExecutionTaskInvocations(
            Consumer<DescribeMaintenanceWindowExecutionTaskInvocationsRequest.Builder> describeMaintenanceWindowExecutionTaskInvocationsRequest) {
        return describeMaintenanceWindowExecutionTaskInvocations(DescribeMaintenanceWindowExecutionTaskInvocationsRequest
                .builder().apply(describeMaintenanceWindowExecutionTaskInvocationsRequest).build());
    }

    /**
     * <p>
     * For a given Maintenance Window execution, lists the tasks that were executed.
     * </p>
     *
     * @param describeMaintenanceWindowExecutionTasksRequest
     * @return A Java Future containing the result of the DescribeMaintenanceWindowExecutionTasks operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource (e.g. a Maintenance Window)
     *         doesn't exist.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DescribeMaintenanceWindowExecutionTasks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutionTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMaintenanceWindowExecutionTasksResponse> describeMaintenanceWindowExecutionTasks(
            DescribeMaintenanceWindowExecutionTasksRequest describeMaintenanceWindowExecutionTasksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For a given Maintenance Window execution, lists the tasks that were executed.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the
     * {@link DescribeMaintenanceWindowExecutionTasksRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeMaintenanceWindowExecutionTasksRequest#builder()}
     *
     * @param describeMaintenanceWindowExecutionTasksRequest
     *        a {@link Consumer} that will call methods on
     *        {@link DescribeMaintenanceWindowExecutionTasksRequest.Builder}.
     * @return A Java Future containing the result of the DescribeMaintenanceWindowExecutionTasks operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource (e.g. a Maintenance Window)
     *         doesn't exist.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DescribeMaintenanceWindowExecutionTasks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutionTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMaintenanceWindowExecutionTasksResponse> describeMaintenanceWindowExecutionTasks(
            Consumer<DescribeMaintenanceWindowExecutionTasksRequest.Builder> describeMaintenanceWindowExecutionTasksRequest) {
        return describeMaintenanceWindowExecutionTasks(DescribeMaintenanceWindowExecutionTasksRequest.builder()
                .apply(describeMaintenanceWindowExecutionTasksRequest).build());
    }

    /**
     * <p>
     * Lists the executions of a Maintenance Window. This includes information about when the Maintenance Window was
     * scheduled to be active, and information about tasks registered and run with the Maintenance Window.
     * </p>
     *
     * @param describeMaintenanceWindowExecutionsRequest
     * @return A Java Future containing the result of the DescribeMaintenanceWindowExecutions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DescribeMaintenanceWindowExecutions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMaintenanceWindowExecutionsResponse> describeMaintenanceWindowExecutions(
            DescribeMaintenanceWindowExecutionsRequest describeMaintenanceWindowExecutionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the executions of a Maintenance Window. This includes information about when the Maintenance Window was
     * scheduled to be active, and information about tasks registered and run with the Maintenance Window.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link DescribeMaintenanceWindowExecutionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeMaintenanceWindowExecutionsRequest#builder()}
     *
     * @param describeMaintenanceWindowExecutionsRequest
     *        a {@link Consumer} that will call methods on {@link DescribeMaintenanceWindowExecutionsRequest.Builder}.
     * @return A Java Future containing the result of the DescribeMaintenanceWindowExecutions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DescribeMaintenanceWindowExecutions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMaintenanceWindowExecutionsResponse> describeMaintenanceWindowExecutions(
            Consumer<DescribeMaintenanceWindowExecutionsRequest.Builder> describeMaintenanceWindowExecutionsRequest) {
        return describeMaintenanceWindowExecutions(DescribeMaintenanceWindowExecutionsRequest.builder()
                .apply(describeMaintenanceWindowExecutionsRequest).build());
    }

    /**
     * <p>
     * Lists the targets registered with the Maintenance Window.
     * </p>
     *
     * @param describeMaintenanceWindowTargetsRequest
     * @return A Java Future containing the result of the DescribeMaintenanceWindowTargets operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource (e.g. a Maintenance Window)
     *         doesn't exist.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DescribeMaintenanceWindowTargets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMaintenanceWindowTargetsResponse> describeMaintenanceWindowTargets(
            DescribeMaintenanceWindowTargetsRequest describeMaintenanceWindowTargetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the targets registered with the Maintenance Window.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link DescribeMaintenanceWindowTargetsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeMaintenanceWindowTargetsRequest#builder()}
     *
     * @param describeMaintenanceWindowTargetsRequest
     *        a {@link Consumer} that will call methods on {@link DescribeMaintenanceWindowTargetsRequest.Builder}.
     * @return A Java Future containing the result of the DescribeMaintenanceWindowTargets operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource (e.g. a Maintenance Window)
     *         doesn't exist.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DescribeMaintenanceWindowTargets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMaintenanceWindowTargetsResponse> describeMaintenanceWindowTargets(
            Consumer<DescribeMaintenanceWindowTargetsRequest.Builder> describeMaintenanceWindowTargetsRequest) {
        return describeMaintenanceWindowTargets(DescribeMaintenanceWindowTargetsRequest.builder()
                .apply(describeMaintenanceWindowTargetsRequest).build());
    }

    /**
     * <p>
     * Lists the tasks in a Maintenance Window.
     * </p>
     *
     * @param describeMaintenanceWindowTasksRequest
     * @return A Java Future containing the result of the DescribeMaintenanceWindowTasks operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource (e.g. a Maintenance Window)
     *         doesn't exist.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DescribeMaintenanceWindowTasks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMaintenanceWindowTasksResponse> describeMaintenanceWindowTasks(
            DescribeMaintenanceWindowTasksRequest describeMaintenanceWindowTasksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tasks in a Maintenance Window.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link DescribeMaintenanceWindowTasksRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeMaintenanceWindowTasksRequest#builder()}
     *
     * @param describeMaintenanceWindowTasksRequest
     *        a {@link Consumer} that will call methods on {@link DescribeMaintenanceWindowTasksRequest.Builder}.
     * @return A Java Future containing the result of the DescribeMaintenanceWindowTasks operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource (e.g. a Maintenance Window)
     *         doesn't exist.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DescribeMaintenanceWindowTasks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMaintenanceWindowTasksResponse> describeMaintenanceWindowTasks(
            Consumer<DescribeMaintenanceWindowTasksRequest.Builder> describeMaintenanceWindowTasksRequest) {
        return describeMaintenanceWindowTasks(DescribeMaintenanceWindowTasksRequest.builder()
                .apply(describeMaintenanceWindowTasksRequest).build());
    }

    /**
     * <p>
     * Retrieves the Maintenance Windows in an AWS account.
     * </p>
     *
     * @param describeMaintenanceWindowsRequest
     * @return A Java Future containing the result of the DescribeMaintenanceWindows operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DescribeMaintenanceWindows
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindows" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeMaintenanceWindowsResponse> describeMaintenanceWindows(
            DescribeMaintenanceWindowsRequest describeMaintenanceWindowsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the Maintenance Windows in an AWS account.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeMaintenanceWindows operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DescribeMaintenanceWindows
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindows" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeMaintenanceWindowsResponse> describeMaintenanceWindows() {
        return describeMaintenanceWindows(DescribeMaintenanceWindowsRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves the Maintenance Windows in an AWS account.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link DescribeMaintenanceWindowsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeMaintenanceWindowsRequest#builder()}
     *
     * @param describeMaintenanceWindowsRequest
     *        a {@link Consumer} that will call methods on {@link DescribeMaintenanceWindowsRequest.Builder}.
     * @return A Java Future containing the result of the DescribeMaintenanceWindows operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DescribeMaintenanceWindows
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindows" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeMaintenanceWindowsResponse> describeMaintenanceWindows(
            Consumer<DescribeMaintenanceWindowsRequest.Builder> describeMaintenanceWindowsRequest) {
        return describeMaintenanceWindows(DescribeMaintenanceWindowsRequest.builder().apply(describeMaintenanceWindowsRequest)
                .build());
    }

    /**
     * <p>
     * Get information about a parameter.
     * </p>
     * <p>
     * Request results are returned on a best-effort basis. If you specify <code>MaxResults</code> in the request, the
     * response includes information up to the limit specified. The number of items returned, however, can be between
     * zero and the value of <code>MaxResults</code>. If the service reaches an internal limit while processing the
     * results, it stops the operation and returns the matching values up to that point and a <code>NextToken</code>.
     * You can specify the <code>NextToken</code> in a subsequent call to get the next set of results.
     * </p>
     *
     * @param describeParametersRequest
     * @return A Java Future containing the result of the DescribeParameters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>InvalidFilterOptionException The specified filter option is not valid. Valid options are Equals and
     *         BeginsWith. For Path filter, valid options are Recursive and OneLevel.</li>
     *         <li>InvalidFilterValueException The filter value is not valid. Verify the value and try again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DescribeParameters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeParameters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeParametersResponse> describeParameters(DescribeParametersRequest describeParametersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get information about a parameter.
     * </p>
     * <p>
     * Request results are returned on a best-effort basis. If you specify <code>MaxResults</code> in the request, the
     * response includes information up to the limit specified. The number of items returned, however, can be between
     * zero and the value of <code>MaxResults</code>. If the service reaches an internal limit while processing the
     * results, it stops the operation and returns the matching values up to that point and a <code>NextToken</code>.
     * You can specify the <code>NextToken</code> in a subsequent call to get the next set of results.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeParameters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>InvalidFilterOptionException The specified filter option is not valid. Valid options are Equals and
     *         BeginsWith. For Path filter, valid options are Recursive and OneLevel.</li>
     *         <li>InvalidFilterValueException The filter value is not valid. Verify the value and try again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DescribeParameters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeParameters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeParametersResponse> describeParameters() {
        return describeParameters(DescribeParametersRequest.builder().build());
    }

    /**
     * <p>
     * Get information about a parameter.
     * </p>
     * <p>
     * Request results are returned on a best-effort basis. If you specify <code>MaxResults</code> in the request, the
     * response includes information up to the limit specified. The number of items returned, however, can be between
     * zero and the value of <code>MaxResults</code>. If the service reaches an internal limit while processing the
     * results, it stops the operation and returns the matching values up to that point and a <code>NextToken</code>.
     * You can specify the <code>NextToken</code> in a subsequent call to get the next set of results.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link DescribeParametersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeParametersRequest#builder()}
     *
     * @param describeParametersRequest
     *        a {@link Consumer} that will call methods on {@link DescribeParametersRequest.Builder}.
     * @return A Java Future containing the result of the DescribeParameters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>InvalidFilterOptionException The specified filter option is not valid. Valid options are Equals and
     *         BeginsWith. For Path filter, valid options are Recursive and OneLevel.</li>
     *         <li>InvalidFilterValueException The filter value is not valid. Verify the value and try again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DescribeParameters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeParameters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeParametersResponse> describeParameters(
            Consumer<DescribeParametersRequest.Builder> describeParametersRequest) {
        return describeParameters(DescribeParametersRequest.builder().apply(describeParametersRequest).build());
    }

    /**
     * <p>
     * Lists the patch baselines in your AWS account.
     * </p>
     *
     * @param describePatchBaselinesRequest
     * @return A Java Future containing the result of the DescribePatchBaselines operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DescribePatchBaselines
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchBaselines" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribePatchBaselinesResponse> describePatchBaselines(
            DescribePatchBaselinesRequest describePatchBaselinesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the patch baselines in your AWS account.
     * </p>
     *
     * @return A Java Future containing the result of the DescribePatchBaselines operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DescribePatchBaselines
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchBaselines" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribePatchBaselinesResponse> describePatchBaselines() {
        return describePatchBaselines(DescribePatchBaselinesRequest.builder().build());
    }

    /**
     * <p>
     * Lists the patch baselines in your AWS account.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link DescribePatchBaselinesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribePatchBaselinesRequest#builder()}
     *
     * @param describePatchBaselinesRequest
     *        a {@link Consumer} that will call methods on {@link DescribePatchBaselinesRequest.Builder}.
     * @return A Java Future containing the result of the DescribePatchBaselines operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DescribePatchBaselines
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchBaselines" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribePatchBaselinesResponse> describePatchBaselines(
            Consumer<DescribePatchBaselinesRequest.Builder> describePatchBaselinesRequest) {
        return describePatchBaselines(DescribePatchBaselinesRequest.builder().apply(describePatchBaselinesRequest).build());
    }

    /**
     * <p>
     * Returns high-level aggregated patch compliance state for a patch group.
     * </p>
     *
     * @param describePatchGroupStateRequest
     * @return A Java Future containing the result of the DescribePatchGroupState operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DescribePatchGroupState
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchGroupState" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribePatchGroupStateResponse> describePatchGroupState(
            DescribePatchGroupStateRequest describePatchGroupStateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns high-level aggregated patch compliance state for a patch group.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link DescribePatchGroupStateRequest.Builder} avoiding
     * the need to create one manually via {@link DescribePatchGroupStateRequest#builder()}
     *
     * @param describePatchGroupStateRequest
     *        a {@link Consumer} that will call methods on {@link DescribePatchGroupStateRequest.Builder}.
     * @return A Java Future containing the result of the DescribePatchGroupState operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DescribePatchGroupState
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchGroupState" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribePatchGroupStateResponse> describePatchGroupState(
            Consumer<DescribePatchGroupStateRequest.Builder> describePatchGroupStateRequest) {
        return describePatchGroupState(DescribePatchGroupStateRequest.builder().apply(describePatchGroupStateRequest).build());
    }

    /**
     * <p>
     * Lists all patch groups that have been registered with patch baselines.
     * </p>
     *
     * @param describePatchGroupsRequest
     * @return A Java Future containing the result of the DescribePatchGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DescribePatchGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribePatchGroupsResponse> describePatchGroups(
            DescribePatchGroupsRequest describePatchGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all patch groups that have been registered with patch baselines.
     * </p>
     *
     * @return A Java Future containing the result of the DescribePatchGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DescribePatchGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribePatchGroupsResponse> describePatchGroups() {
        return describePatchGroups(DescribePatchGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Lists all patch groups that have been registered with patch baselines.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link DescribePatchGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribePatchGroupsRequest#builder()}
     *
     * @param describePatchGroupsRequest
     *        a {@link Consumer} that will call methods on {@link DescribePatchGroupsRequest.Builder}.
     * @return A Java Future containing the result of the DescribePatchGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.DescribePatchGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribePatchGroupsResponse> describePatchGroups(
            Consumer<DescribePatchGroupsRequest.Builder> describePatchGroupsRequest) {
        return describePatchGroups(DescribePatchGroupsRequest.builder().apply(describePatchGroupsRequest).build());
    }

    /**
     * <p>
     * Get detailed information about a particular Automation execution.
     * </p>
     *
     * @param getAutomationExecutionRequest
     * @return A Java Future containing the result of the GetAutomationExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AutomationExecutionNotFoundException There is no automation execution information for the requested
     *         automation execution ID.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.GetAutomationExecution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetAutomationExecution" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAutomationExecutionResponse> getAutomationExecution(
            GetAutomationExecutionRequest getAutomationExecutionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get detailed information about a particular Automation execution.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link GetAutomationExecutionRequest.Builder} avoiding the
     * need to create one manually via {@link GetAutomationExecutionRequest#builder()}
     *
     * @param getAutomationExecutionRequest
     *        a {@link Consumer} that will call methods on {@link GetAutomationExecutionRequest.Builder}.
     * @return A Java Future containing the result of the GetAutomationExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AutomationExecutionNotFoundException There is no automation execution information for the requested
     *         automation execution ID.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.GetAutomationExecution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetAutomationExecution" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAutomationExecutionResponse> getAutomationExecution(
            Consumer<GetAutomationExecutionRequest.Builder> getAutomationExecutionRequest) {
        return getAutomationExecution(GetAutomationExecutionRequest.builder().apply(getAutomationExecutionRequest).build());
    }

    /**
     * <p>
     * Returns detailed information about command execution for an invocation or plugin.
     * </p>
     *
     * @param getCommandInvocationRequest
     * @return A Java Future containing the result of the GetCommandInvocation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidCommandIdException</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidPluginNameException The plugin name is not valid.</li>
     *         <li>InvocationDoesNotExistException The command ID and instance ID you specified did not match any
     *         invocations. Verify the command ID adn the instance ID and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.GetCommandInvocation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetCommandInvocation" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCommandInvocationResponse> getCommandInvocation(
            GetCommandInvocationRequest getCommandInvocationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns detailed information about command execution for an invocation or plugin.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link GetCommandInvocationRequest.Builder} avoiding the
     * need to create one manually via {@link GetCommandInvocationRequest#builder()}
     *
     * @param getCommandInvocationRequest
     *        a {@link Consumer} that will call methods on {@link GetCommandInvocationRequest.Builder}.
     * @return A Java Future containing the result of the GetCommandInvocation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidCommandIdException</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidPluginNameException The plugin name is not valid.</li>
     *         <li>InvocationDoesNotExistException The command ID and instance ID you specified did not match any
     *         invocations. Verify the command ID adn the instance ID and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.GetCommandInvocation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetCommandInvocation" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCommandInvocationResponse> getCommandInvocation(
            Consumer<GetCommandInvocationRequest.Builder> getCommandInvocationRequest) {
        return getCommandInvocation(GetCommandInvocationRequest.builder().apply(getCommandInvocationRequest).build());
    }

    /**
     * <p>
     * Retrieves the default patch baseline. Note that Systems Manager supports creating multiple default patch
     * baselines. For example, you can create a default patch baseline for each operating system.
     * </p>
     *
     * @param getDefaultPatchBaselineRequest
     * @return A Java Future containing the result of the GetDefaultPatchBaseline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.GetDefaultPatchBaseline
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetDefaultPatchBaseline" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDefaultPatchBaselineResponse> getDefaultPatchBaseline(
            GetDefaultPatchBaselineRequest getDefaultPatchBaselineRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the default patch baseline. Note that Systems Manager supports creating multiple default patch
     * baselines. For example, you can create a default patch baseline for each operating system.
     * </p>
     *
     * @return A Java Future containing the result of the GetDefaultPatchBaseline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.GetDefaultPatchBaseline
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetDefaultPatchBaseline" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDefaultPatchBaselineResponse> getDefaultPatchBaseline() {
        return getDefaultPatchBaseline(GetDefaultPatchBaselineRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves the default patch baseline. Note that Systems Manager supports creating multiple default patch
     * baselines. For example, you can create a default patch baseline for each operating system.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link GetDefaultPatchBaselineRequest.Builder} avoiding
     * the need to create one manually via {@link GetDefaultPatchBaselineRequest#builder()}
     *
     * @param getDefaultPatchBaselineRequest
     *        a {@link Consumer} that will call methods on {@link GetDefaultPatchBaselineRequest.Builder}.
     * @return A Java Future containing the result of the GetDefaultPatchBaseline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.GetDefaultPatchBaseline
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetDefaultPatchBaseline" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDefaultPatchBaselineResponse> getDefaultPatchBaseline(
            Consumer<GetDefaultPatchBaselineRequest.Builder> getDefaultPatchBaselineRequest) {
        return getDefaultPatchBaseline(GetDefaultPatchBaselineRequest.builder().apply(getDefaultPatchBaselineRequest).build());
    }

    /**
     * <p>
     * Retrieves the current snapshot for the patch baseline the instance uses. This API is primarily used by the
     * AWS-RunPatchBaseline Systems Manager document.
     * </p>
     *
     * @param getDeployablePatchSnapshotForInstanceRequest
     * @return A Java Future containing the result of the GetDeployablePatchSnapshotForInstance operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>UnsupportedOperatingSystemException The operating systems you specified is not supported, or the
     *         operation is not supported for the operating system. Valid operating systems include: Windows,
     *         AmazonLinux, RedhatEnterpriseLinux, and Ubuntu.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.GetDeployablePatchSnapshotForInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetDeployablePatchSnapshotForInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDeployablePatchSnapshotForInstanceResponse> getDeployablePatchSnapshotForInstance(
            GetDeployablePatchSnapshotForInstanceRequest getDeployablePatchSnapshotForInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the current snapshot for the patch baseline the instance uses. This API is primarily used by the
     * AWS-RunPatchBaseline Systems Manager document.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the
     * {@link GetDeployablePatchSnapshotForInstanceRequest.Builder} avoiding the need to create one manually via
     * {@link GetDeployablePatchSnapshotForInstanceRequest#builder()}
     *
     * @param getDeployablePatchSnapshotForInstanceRequest
     *        a {@link Consumer} that will call methods on {@link GetDeployablePatchSnapshotForInstanceRequest.Builder}.
     * @return A Java Future containing the result of the GetDeployablePatchSnapshotForInstance operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>UnsupportedOperatingSystemException The operating systems you specified is not supported, or the
     *         operation is not supported for the operating system. Valid operating systems include: Windows,
     *         AmazonLinux, RedhatEnterpriseLinux, and Ubuntu.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.GetDeployablePatchSnapshotForInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetDeployablePatchSnapshotForInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDeployablePatchSnapshotForInstanceResponse> getDeployablePatchSnapshotForInstance(
            Consumer<GetDeployablePatchSnapshotForInstanceRequest.Builder> getDeployablePatchSnapshotForInstanceRequest) {
        return getDeployablePatchSnapshotForInstance(GetDeployablePatchSnapshotForInstanceRequest.builder()
                .apply(getDeployablePatchSnapshotForInstanceRequest).build());
    }

    /**
     * <p>
     * Gets the contents of the specified Systems Manager document.
     * </p>
     *
     * @param getDocumentRequest
     * @return A Java Future containing the result of the GetDocument operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentException The specified document does not exist.</li>
     *         <li>InvalidDocumentVersionException The document version is not valid or does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.GetDocument
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetDocument" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDocumentResponse> getDocument(GetDocumentRequest getDocumentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the contents of the specified Systems Manager document.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link GetDocumentRequest.Builder} avoiding the need to
     * create one manually via {@link GetDocumentRequest#builder()}
     *
     * @param getDocumentRequest
     *        a {@link Consumer} that will call methods on {@link GetDocumentRequest.Builder}.
     * @return A Java Future containing the result of the GetDocument operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentException The specified document does not exist.</li>
     *         <li>InvalidDocumentVersionException The document version is not valid or does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.GetDocument
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetDocument" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDocumentResponse> getDocument(Consumer<GetDocumentRequest.Builder> getDocumentRequest) {
        return getDocument(GetDocumentRequest.builder().apply(getDocumentRequest).build());
    }

    /**
     * <p>
     * Query inventory information.
     * </p>
     *
     * @param getInventoryRequest
     * @return A Java Future containing the result of the GetInventory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InvalidTypeNameException The parameter type name is not valid.</li>
     *         <li>InvalidResultAttributeException The specified inventory item result attribute is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.GetInventory
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetInventory" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetInventoryResponse> getInventory(GetInventoryRequest getInventoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Query inventory information.
     * </p>
     *
     * @return A Java Future containing the result of the GetInventory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InvalidTypeNameException The parameter type name is not valid.</li>
     *         <li>InvalidResultAttributeException The specified inventory item result attribute is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.GetInventory
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetInventory" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetInventoryResponse> getInventory() {
        return getInventory(GetInventoryRequest.builder().build());
    }

    /**
     * <p>
     * Query inventory information.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link GetInventoryRequest.Builder} avoiding the need to
     * create one manually via {@link GetInventoryRequest#builder()}
     *
     * @param getInventoryRequest
     *        a {@link Consumer} that will call methods on {@link GetInventoryRequest.Builder}.
     * @return A Java Future containing the result of the GetInventory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InvalidTypeNameException The parameter type name is not valid.</li>
     *         <li>InvalidResultAttributeException The specified inventory item result attribute is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.GetInventory
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetInventory" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetInventoryResponse> getInventory(Consumer<GetInventoryRequest.Builder> getInventoryRequest) {
        return getInventory(GetInventoryRequest.builder().apply(getInventoryRequest).build());
    }

    /**
     * <p>
     * Return a list of inventory type names for the account, or return a list of attribute names for a specific
     * Inventory item type.
     * </p>
     *
     * @param getInventorySchemaRequest
     * @return A Java Future containing the result of the GetInventorySchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidTypeNameException The parameter type name is not valid.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.GetInventorySchema
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetInventorySchema" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetInventorySchemaResponse> getInventorySchema(GetInventorySchemaRequest getInventorySchemaRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Return a list of inventory type names for the account, or return a list of attribute names for a specific
     * Inventory item type.
     * </p>
     *
     * @return A Java Future containing the result of the GetInventorySchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidTypeNameException The parameter type name is not valid.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.GetInventorySchema
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetInventorySchema" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetInventorySchemaResponse> getInventorySchema() {
        return getInventorySchema(GetInventorySchemaRequest.builder().build());
    }

    /**
     * <p>
     * Return a list of inventory type names for the account, or return a list of attribute names for a specific
     * Inventory item type.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link GetInventorySchemaRequest.Builder} avoiding the
     * need to create one manually via {@link GetInventorySchemaRequest#builder()}
     *
     * @param getInventorySchemaRequest
     *        a {@link Consumer} that will call methods on {@link GetInventorySchemaRequest.Builder}.
     * @return A Java Future containing the result of the GetInventorySchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidTypeNameException The parameter type name is not valid.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.GetInventorySchema
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetInventorySchema" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetInventorySchemaResponse> getInventorySchema(
            Consumer<GetInventorySchemaRequest.Builder> getInventorySchemaRequest) {
        return getInventorySchema(GetInventorySchemaRequest.builder().apply(getInventorySchemaRequest).build());
    }

    /**
     * <p>
     * Retrieves a Maintenance Window.
     * </p>
     *
     * @param getMaintenanceWindowRequest
     * @return A Java Future containing the result of the GetMaintenanceWindow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource (e.g. a Maintenance Window)
     *         doesn't exist.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.GetMaintenanceWindow
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMaintenanceWindowResponse> getMaintenanceWindow(
            GetMaintenanceWindowRequest getMaintenanceWindowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a Maintenance Window.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link GetMaintenanceWindowRequest.Builder} avoiding the
     * need to create one manually via {@link GetMaintenanceWindowRequest#builder()}
     *
     * @param getMaintenanceWindowRequest
     *        a {@link Consumer} that will call methods on {@link GetMaintenanceWindowRequest.Builder}.
     * @return A Java Future containing the result of the GetMaintenanceWindow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource (e.g. a Maintenance Window)
     *         doesn't exist.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.GetMaintenanceWindow
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMaintenanceWindowResponse> getMaintenanceWindow(
            Consumer<GetMaintenanceWindowRequest.Builder> getMaintenanceWindowRequest) {
        return getMaintenanceWindow(GetMaintenanceWindowRequest.builder().apply(getMaintenanceWindowRequest).build());
    }

    /**
     * <p>
     * Retrieves details about a specific task executed as part of a Maintenance Window execution.
     * </p>
     *
     * @param getMaintenanceWindowExecutionRequest
     * @return A Java Future containing the result of the GetMaintenanceWindowExecution operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource (e.g. a Maintenance Window)
     *         doesn't exist.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.GetMaintenanceWindowExecution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindowExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMaintenanceWindowExecutionResponse> getMaintenanceWindowExecution(
            GetMaintenanceWindowExecutionRequest getMaintenanceWindowExecutionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details about a specific task executed as part of a Maintenance Window execution.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link GetMaintenanceWindowExecutionRequest.Builder}
     * avoiding the need to create one manually via {@link GetMaintenanceWindowExecutionRequest#builder()}
     *
     * @param getMaintenanceWindowExecutionRequest
     *        a {@link Consumer} that will call methods on {@link GetMaintenanceWindowExecutionRequest.Builder}.
     * @return A Java Future containing the result of the GetMaintenanceWindowExecution operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource (e.g. a Maintenance Window)
     *         doesn't exist.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.GetMaintenanceWindowExecution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindowExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMaintenanceWindowExecutionResponse> getMaintenanceWindowExecution(
            Consumer<GetMaintenanceWindowExecutionRequest.Builder> getMaintenanceWindowExecutionRequest) {
        return getMaintenanceWindowExecution(GetMaintenanceWindowExecutionRequest.builder()
                .apply(getMaintenanceWindowExecutionRequest).build());
    }

    /**
     * <p>
     * Retrieves the details about a specific task executed as part of a Maintenance Window execution.
     * </p>
     *
     * @param getMaintenanceWindowExecutionTaskRequest
     * @return A Java Future containing the result of the GetMaintenanceWindowExecutionTask operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource (e.g. a Maintenance Window)
     *         doesn't exist.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.GetMaintenanceWindowExecutionTask
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindowExecutionTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMaintenanceWindowExecutionTaskResponse> getMaintenanceWindowExecutionTask(
            GetMaintenanceWindowExecutionTaskRequest getMaintenanceWindowExecutionTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the details about a specific task executed as part of a Maintenance Window execution.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link GetMaintenanceWindowExecutionTaskRequest.Builder}
     * avoiding the need to create one manually via {@link GetMaintenanceWindowExecutionTaskRequest#builder()}
     *
     * @param getMaintenanceWindowExecutionTaskRequest
     *        a {@link Consumer} that will call methods on {@link GetMaintenanceWindowExecutionTaskRequest.Builder}.
     * @return A Java Future containing the result of the GetMaintenanceWindowExecutionTask operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource (e.g. a Maintenance Window)
     *         doesn't exist.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.GetMaintenanceWindowExecutionTask
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindowExecutionTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMaintenanceWindowExecutionTaskResponse> getMaintenanceWindowExecutionTask(
            Consumer<GetMaintenanceWindowExecutionTaskRequest.Builder> getMaintenanceWindowExecutionTaskRequest) {
        return getMaintenanceWindowExecutionTask(GetMaintenanceWindowExecutionTaskRequest.builder()
                .apply(getMaintenanceWindowExecutionTaskRequest).build());
    }

    /**
     * <p>
     * Retrieves a task invocation. A task invocation is a specific task executing on a specific target. Maintenance
     * Windows report status for all invocations.
     * </p>
     *
     * @param getMaintenanceWindowExecutionTaskInvocationRequest
     * @return A Java Future containing the result of the GetMaintenanceWindowExecutionTaskInvocation operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource (e.g. a Maintenance Window)
     *         doesn't exist.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.GetMaintenanceWindowExecutionTaskInvocation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindowExecutionTaskInvocation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMaintenanceWindowExecutionTaskInvocationResponse> getMaintenanceWindowExecutionTaskInvocation(
            GetMaintenanceWindowExecutionTaskInvocationRequest getMaintenanceWindowExecutionTaskInvocationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a task invocation. A task invocation is a specific task executing on a specific target. Maintenance
     * Windows report status for all invocations.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the
     * {@link GetMaintenanceWindowExecutionTaskInvocationRequest.Builder} avoiding the need to create one manually via
     * {@link GetMaintenanceWindowExecutionTaskInvocationRequest#builder()}
     *
     * @param getMaintenanceWindowExecutionTaskInvocationRequest
     *        a {@link Consumer} that will call methods on
     *        {@link GetMaintenanceWindowExecutionTaskInvocationRequest.Builder}.
     * @return A Java Future containing the result of the GetMaintenanceWindowExecutionTaskInvocation operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource (e.g. a Maintenance Window)
     *         doesn't exist.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.GetMaintenanceWindowExecutionTaskInvocation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindowExecutionTaskInvocation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMaintenanceWindowExecutionTaskInvocationResponse> getMaintenanceWindowExecutionTaskInvocation(
            Consumer<GetMaintenanceWindowExecutionTaskInvocationRequest.Builder> getMaintenanceWindowExecutionTaskInvocationRequest) {
        return getMaintenanceWindowExecutionTaskInvocation(GetMaintenanceWindowExecutionTaskInvocationRequest.builder()
                .apply(getMaintenanceWindowExecutionTaskInvocationRequest).build());
    }

    /**
     * <p>
     * Lists the tasks in a Maintenance Window.
     * </p>
     *
     * @param getMaintenanceWindowTaskRequest
     * @return A Java Future containing the result of the GetMaintenanceWindowTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource (e.g. a Maintenance Window)
     *         doesn't exist.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.GetMaintenanceWindowTask
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindowTask" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetMaintenanceWindowTaskResponse> getMaintenanceWindowTask(
            GetMaintenanceWindowTaskRequest getMaintenanceWindowTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tasks in a Maintenance Window.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link GetMaintenanceWindowTaskRequest.Builder} avoiding
     * the need to create one manually via {@link GetMaintenanceWindowTaskRequest#builder()}
     *
     * @param getMaintenanceWindowTaskRequest
     *        a {@link Consumer} that will call methods on {@link GetMaintenanceWindowTaskRequest.Builder}.
     * @return A Java Future containing the result of the GetMaintenanceWindowTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource (e.g. a Maintenance Window)
     *         doesn't exist.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.GetMaintenanceWindowTask
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindowTask" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetMaintenanceWindowTaskResponse> getMaintenanceWindowTask(
            Consumer<GetMaintenanceWindowTaskRequest.Builder> getMaintenanceWindowTaskRequest) {
        return getMaintenanceWindowTask(GetMaintenanceWindowTaskRequest.builder().apply(getMaintenanceWindowTaskRequest).build());
    }

    /**
     * <p>
     * Get information about a parameter by using the parameter name.
     * </p>
     *
     * @param getParameterRequest
     * @return A Java Future containing the result of the GetParameter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidKeyIdException The query key ID is not valid.</li>
     *         <li>ParameterNotFoundException The parameter could not be found. Verify the name and try again.</li>
     *         <li>ParameterVersionNotFoundException The specified parameter version was not found. Verify the parameter
     *         name and version, and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.GetParameter
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParameter" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetParameterResponse> getParameter(GetParameterRequest getParameterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get information about a parameter by using the parameter name.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link GetParameterRequest.Builder} avoiding the need to
     * create one manually via {@link GetParameterRequest#builder()}
     *
     * @param getParameterRequest
     *        a {@link Consumer} that will call methods on {@link GetParameterRequest.Builder}.
     * @return A Java Future containing the result of the GetParameter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidKeyIdException The query key ID is not valid.</li>
     *         <li>ParameterNotFoundException The parameter could not be found. Verify the name and try again.</li>
     *         <li>ParameterVersionNotFoundException The specified parameter version was not found. Verify the parameter
     *         name and version, and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.GetParameter
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParameter" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetParameterResponse> getParameter(Consumer<GetParameterRequest.Builder> getParameterRequest) {
        return getParameter(GetParameterRequest.builder().apply(getParameterRequest).build());
    }

    /**
     * <p>
     * Query a list of all parameters used by the AWS account.
     * </p>
     *
     * @param getParameterHistoryRequest
     * @return A Java Future containing the result of the GetParameterHistory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ParameterNotFoundException The parameter could not be found. Verify the name and try again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InvalidKeyIdException The query key ID is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.GetParameterHistory
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParameterHistory" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetParameterHistoryResponse> getParameterHistory(
            GetParameterHistoryRequest getParameterHistoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Query a list of all parameters used by the AWS account.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link GetParameterHistoryRequest.Builder} avoiding the
     * need to create one manually via {@link GetParameterHistoryRequest#builder()}
     *
     * @param getParameterHistoryRequest
     *        a {@link Consumer} that will call methods on {@link GetParameterHistoryRequest.Builder}.
     * @return A Java Future containing the result of the GetParameterHistory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ParameterNotFoundException The parameter could not be found. Verify the name and try again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InvalidKeyIdException The query key ID is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.GetParameterHistory
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParameterHistory" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetParameterHistoryResponse> getParameterHistory(
            Consumer<GetParameterHistoryRequest.Builder> getParameterHistoryRequest) {
        return getParameterHistory(GetParameterHistoryRequest.builder().apply(getParameterHistoryRequest).build());
    }

    /**
     * <p>
     * Get details of a parameter.
     * </p>
     *
     * @param getParametersRequest
     * @return A Java Future containing the result of the GetParameters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidKeyIdException The query key ID is not valid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.GetParameters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParameters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetParametersResponse> getParameters(GetParametersRequest getParametersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get details of a parameter.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link GetParametersRequest.Builder} avoiding the need to
     * create one manually via {@link GetParametersRequest#builder()}
     *
     * @param getParametersRequest
     *        a {@link Consumer} that will call methods on {@link GetParametersRequest.Builder}.
     * @return A Java Future containing the result of the GetParameters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidKeyIdException The query key ID is not valid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.GetParameters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParameters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetParametersResponse> getParameters(Consumer<GetParametersRequest.Builder> getParametersRequest) {
        return getParameters(GetParametersRequest.builder().apply(getParametersRequest).build());
    }

    /**
     * <p>
     * Retrieve parameters in a specific hierarchy. For more information, see <a
     * href="http://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-working.html">Working with
     * Systems Manager Parameters</a>.
     * </p>
     * <p>
     * Request results are returned on a best-effort basis. If you specify <code>MaxResults</code> in the request, the
     * response includes information up to the limit specified. The number of items returned, however, can be between
     * zero and the value of <code>MaxResults</code>. If the service reaches an internal limit while processing the
     * results, it stops the operation and returns the matching values up to that point and a <code>NextToken</code>.
     * You can specify the <code>NextToken</code> in a subsequent call to get the next set of results.
     * </p>
     *
     * @param getParametersByPathRequest
     * @return A Java Future containing the result of the GetParametersByPath operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>InvalidFilterOptionException The specified filter option is not valid. Valid options are Equals and
     *         BeginsWith. For Path filter, valid options are Recursive and OneLevel.</li>
     *         <li>InvalidFilterValueException The filter value is not valid. Verify the value and try again.</li>
     *         <li>InvalidKeyIdException The query key ID is not valid.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.GetParametersByPath
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParametersByPath" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetParametersByPathResponse> getParametersByPath(
            GetParametersByPathRequest getParametersByPathRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve parameters in a specific hierarchy. For more information, see <a
     * href="http://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-working.html">Working with
     * Systems Manager Parameters</a>.
     * </p>
     * <p>
     * Request results are returned on a best-effort basis. If you specify <code>MaxResults</code> in the request, the
     * response includes information up to the limit specified. The number of items returned, however, can be between
     * zero and the value of <code>MaxResults</code>. If the service reaches an internal limit while processing the
     * results, it stops the operation and returns the matching values up to that point and a <code>NextToken</code>.
     * You can specify the <code>NextToken</code> in a subsequent call to get the next set of results.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link GetParametersByPathRequest.Builder} avoiding the
     * need to create one manually via {@link GetParametersByPathRequest#builder()}
     *
     * @param getParametersByPathRequest
     *        a {@link Consumer} that will call methods on {@link GetParametersByPathRequest.Builder}.
     * @return A Java Future containing the result of the GetParametersByPath operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>InvalidFilterOptionException The specified filter option is not valid. Valid options are Equals and
     *         BeginsWith. For Path filter, valid options are Recursive and OneLevel.</li>
     *         <li>InvalidFilterValueException The filter value is not valid. Verify the value and try again.</li>
     *         <li>InvalidKeyIdException The query key ID is not valid.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.GetParametersByPath
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParametersByPath" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetParametersByPathResponse> getParametersByPath(
            Consumer<GetParametersByPathRequest.Builder> getParametersByPathRequest) {
        return getParametersByPath(GetParametersByPathRequest.builder().apply(getParametersByPathRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a patch baseline.
     * </p>
     *
     * @param getPatchBaselineRequest
     * @return A Java Future containing the result of the GetPatchBaseline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource (e.g. a Maintenance Window)
     *         doesn't exist.</li>
     *         <li>InvalidResourceIdException The resource ID is not valid. Verify that you entered the correct ID and
     *         try again.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.GetPatchBaseline
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetPatchBaseline" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPatchBaselineResponse> getPatchBaseline(GetPatchBaselineRequest getPatchBaselineRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a patch baseline.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link GetPatchBaselineRequest.Builder} avoiding the need
     * to create one manually via {@link GetPatchBaselineRequest#builder()}
     *
     * @param getPatchBaselineRequest
     *        a {@link Consumer} that will call methods on {@link GetPatchBaselineRequest.Builder}.
     * @return A Java Future containing the result of the GetPatchBaseline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource (e.g. a Maintenance Window)
     *         doesn't exist.</li>
     *         <li>InvalidResourceIdException The resource ID is not valid. Verify that you entered the correct ID and
     *         try again.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.GetPatchBaseline
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetPatchBaseline" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPatchBaselineResponse> getPatchBaseline(
            Consumer<GetPatchBaselineRequest.Builder> getPatchBaselineRequest) {
        return getPatchBaseline(GetPatchBaselineRequest.builder().apply(getPatchBaselineRequest).build());
    }

    /**
     * <p>
     * Retrieves the patch baseline that should be used for the specified patch group.
     * </p>
     *
     * @param getPatchBaselineForPatchGroupRequest
     * @return A Java Future containing the result of the GetPatchBaselineForPatchGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.GetPatchBaselineForPatchGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetPatchBaselineForPatchGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPatchBaselineForPatchGroupResponse> getPatchBaselineForPatchGroup(
            GetPatchBaselineForPatchGroupRequest getPatchBaselineForPatchGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the patch baseline that should be used for the specified patch group.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link GetPatchBaselineForPatchGroupRequest.Builder}
     * avoiding the need to create one manually via {@link GetPatchBaselineForPatchGroupRequest#builder()}
     *
     * @param getPatchBaselineForPatchGroupRequest
     *        a {@link Consumer} that will call methods on {@link GetPatchBaselineForPatchGroupRequest.Builder}.
     * @return A Java Future containing the result of the GetPatchBaselineForPatchGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.GetPatchBaselineForPatchGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetPatchBaselineForPatchGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPatchBaselineForPatchGroupResponse> getPatchBaselineForPatchGroup(
            Consumer<GetPatchBaselineForPatchGroupRequest.Builder> getPatchBaselineForPatchGroupRequest) {
        return getPatchBaselineForPatchGroup(GetPatchBaselineForPatchGroupRequest.builder()
                .apply(getPatchBaselineForPatchGroupRequest).build());
    }

    /**
     * <p>
     * Retrieves all versions of an association for a specific association ID.
     * </p>
     *
     * @param listAssociationVersionsRequest
     * @return A Java Future containing the result of the ListAssociationVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>AssociationDoesNotExistException The specified association does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.ListAssociationVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListAssociationVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListAssociationVersionsResponse> listAssociationVersions(
            ListAssociationVersionsRequest listAssociationVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all versions of an association for a specific association ID.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link ListAssociationVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAssociationVersionsRequest#builder()}
     *
     * @param listAssociationVersionsRequest
     *        a {@link Consumer} that will call methods on {@link ListAssociationVersionsRequest.Builder}.
     * @return A Java Future containing the result of the ListAssociationVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>AssociationDoesNotExistException The specified association does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.ListAssociationVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListAssociationVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListAssociationVersionsResponse> listAssociationVersions(
            Consumer<ListAssociationVersionsRequest.Builder> listAssociationVersionsRequest) {
        return listAssociationVersions(ListAssociationVersionsRequest.builder().apply(listAssociationVersionsRequest).build());
    }

    /**
     * <p>
     * Lists the associations for the specified Systems Manager document or instance.
     * </p>
     *
     * @param listAssociationsRequest
     * @return A Java Future containing the result of the ListAssociations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.ListAssociations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListAssociations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAssociationsResponse> listAssociations(ListAssociationsRequest listAssociationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the associations for the specified Systems Manager document or instance.
     * </p>
     *
     * @return A Java Future containing the result of the ListAssociations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.ListAssociations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListAssociations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAssociationsResponse> listAssociations() {
        return listAssociations(ListAssociationsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the associations for the specified Systems Manager document or instance.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link ListAssociationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListAssociationsRequest#builder()}
     *
     * @param listAssociationsRequest
     *        a {@link Consumer} that will call methods on {@link ListAssociationsRequest.Builder}.
     * @return A Java Future containing the result of the ListAssociations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.ListAssociations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListAssociations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAssociationsResponse> listAssociations(
            Consumer<ListAssociationsRequest.Builder> listAssociationsRequest) {
        return listAssociations(ListAssociationsRequest.builder().apply(listAssociationsRequest).build());
    }

    /**
     * <p>
     * An invocation is copy of a command sent to a specific instance. A command can apply to one or more instances. A
     * command invocation applies to one instance. For example, if a user executes SendCommand against three instances,
     * then a command invocation is created for each requested instance ID. ListCommandInvocations provide status about
     * command execution.
     * </p>
     *
     * @param listCommandInvocationsRequest
     * @return A Java Future containing the result of the ListCommandInvocations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidCommandIdException</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.ListCommandInvocations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListCommandInvocations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListCommandInvocationsResponse> listCommandInvocations(
            ListCommandInvocationsRequest listCommandInvocationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * An invocation is copy of a command sent to a specific instance. A command can apply to one or more instances. A
     * command invocation applies to one instance. For example, if a user executes SendCommand against three instances,
     * then a command invocation is created for each requested instance ID. ListCommandInvocations provide status about
     * command execution.
     * </p>
     *
     * @return A Java Future containing the result of the ListCommandInvocations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidCommandIdException</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.ListCommandInvocations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListCommandInvocations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListCommandInvocationsResponse> listCommandInvocations() {
        return listCommandInvocations(ListCommandInvocationsRequest.builder().build());
    }

    /**
     * <p>
     * An invocation is copy of a command sent to a specific instance. A command can apply to one or more instances. A
     * command invocation applies to one instance. For example, if a user executes SendCommand against three instances,
     * then a command invocation is created for each requested instance ID. ListCommandInvocations provide status about
     * command execution.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link ListCommandInvocationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListCommandInvocationsRequest#builder()}
     *
     * @param listCommandInvocationsRequest
     *        a {@link Consumer} that will call methods on {@link ListCommandInvocationsRequest.Builder}.
     * @return A Java Future containing the result of the ListCommandInvocations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidCommandIdException</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.ListCommandInvocations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListCommandInvocations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListCommandInvocationsResponse> listCommandInvocations(
            Consumer<ListCommandInvocationsRequest.Builder> listCommandInvocationsRequest) {
        return listCommandInvocations(ListCommandInvocationsRequest.builder().apply(listCommandInvocationsRequest).build());
    }

    /**
     * <p>
     * Lists the commands requested by users of the AWS account.
     * </p>
     *
     * @param listCommandsRequest
     * @return A Java Future containing the result of the ListCommands operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidCommandIdException</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.ListCommands
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListCommands" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListCommandsResponse> listCommands(ListCommandsRequest listCommandsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the commands requested by users of the AWS account.
     * </p>
     *
     * @return A Java Future containing the result of the ListCommands operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidCommandIdException</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.ListCommands
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListCommands" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListCommandsResponse> listCommands() {
        return listCommands(ListCommandsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the commands requested by users of the AWS account.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link ListCommandsRequest.Builder} avoiding the need to
     * create one manually via {@link ListCommandsRequest#builder()}
     *
     * @param listCommandsRequest
     *        a {@link Consumer} that will call methods on {@link ListCommandsRequest.Builder}.
     * @return A Java Future containing the result of the ListCommands operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidCommandIdException</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.ListCommands
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListCommands" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListCommandsResponse> listCommands(Consumer<ListCommandsRequest.Builder> listCommandsRequest) {
        return listCommands(ListCommandsRequest.builder().apply(listCommandsRequest).build());
    }

    /**
     * <p>
     * For a specified resource ID, this API action returns a list of compliance statuses for different resource types.
     * Currently, you can only specify one resource ID per call. List results depend on the criteria specified in the
     * filter.
     * </p>
     *
     * @param listComplianceItemsRequest
     * @return A Java Future containing the result of the ListComplianceItems operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidResourceTypeException The resource type is not valid. For example, if you are attempting to
     *         tag an instance, the instance must be a registered, managed instance.</li>
     *         <li>InvalidResourceIdException The resource ID is not valid. Verify that you entered the correct ID and
     *         try again.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.ListComplianceItems
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListComplianceItems" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListComplianceItemsResponse> listComplianceItems(
            ListComplianceItemsRequest listComplianceItemsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For a specified resource ID, this API action returns a list of compliance statuses for different resource types.
     * Currently, you can only specify one resource ID per call. List results depend on the criteria specified in the
     * filter.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link ListComplianceItemsRequest.Builder} avoiding the
     * need to create one manually via {@link ListComplianceItemsRequest#builder()}
     *
     * @param listComplianceItemsRequest
     *        a {@link Consumer} that will call methods on {@link ListComplianceItemsRequest.Builder}.
     * @return A Java Future containing the result of the ListComplianceItems operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidResourceTypeException The resource type is not valid. For example, if you are attempting to
     *         tag an instance, the instance must be a registered, managed instance.</li>
     *         <li>InvalidResourceIdException The resource ID is not valid. Verify that you entered the correct ID and
     *         try again.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.ListComplianceItems
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListComplianceItems" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListComplianceItemsResponse> listComplianceItems(
            Consumer<ListComplianceItemsRequest.Builder> listComplianceItemsRequest) {
        return listComplianceItems(ListComplianceItemsRequest.builder().apply(listComplianceItemsRequest).build());
    }

    /**
     * <p>
     * Returns a summary count of compliant and non-compliant resources for a compliance type. For example, this call
     * can return State Manager associations, patches, or custom compliance types according to the filter criteria that
     * you specify.
     * </p>
     *
     * @param listComplianceSummariesRequest
     * @return A Java Future containing the result of the ListComplianceSummaries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.ListComplianceSummaries
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListComplianceSummaries" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListComplianceSummariesResponse> listComplianceSummaries(
            ListComplianceSummariesRequest listComplianceSummariesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a summary count of compliant and non-compliant resources for a compliance type. For example, this call
     * can return State Manager associations, patches, or custom compliance types according to the filter criteria that
     * you specify.
     * </p>
     *
     * @return A Java Future containing the result of the ListComplianceSummaries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.ListComplianceSummaries
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListComplianceSummaries" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListComplianceSummariesResponse> listComplianceSummaries() {
        return listComplianceSummaries(ListComplianceSummariesRequest.builder().build());
    }

    /**
     * <p>
     * Returns a summary count of compliant and non-compliant resources for a compliance type. For example, this call
     * can return State Manager associations, patches, or custom compliance types according to the filter criteria that
     * you specify.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link ListComplianceSummariesRequest.Builder} avoiding
     * the need to create one manually via {@link ListComplianceSummariesRequest#builder()}
     *
     * @param listComplianceSummariesRequest
     *        a {@link Consumer} that will call methods on {@link ListComplianceSummariesRequest.Builder}.
     * @return A Java Future containing the result of the ListComplianceSummaries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.ListComplianceSummaries
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListComplianceSummaries" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListComplianceSummariesResponse> listComplianceSummaries(
            Consumer<ListComplianceSummariesRequest.Builder> listComplianceSummariesRequest) {
        return listComplianceSummaries(ListComplianceSummariesRequest.builder().apply(listComplianceSummariesRequest).build());
    }

    /**
     * <p>
     * List all versions for a document.
     * </p>
     *
     * @param listDocumentVersionsRequest
     * @return A Java Future containing the result of the ListDocumentVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InvalidDocumentException The specified document does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.ListDocumentVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListDocumentVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDocumentVersionsResponse> listDocumentVersions(
            ListDocumentVersionsRequest listDocumentVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all versions for a document.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link ListDocumentVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDocumentVersionsRequest#builder()}
     *
     * @param listDocumentVersionsRequest
     *        a {@link Consumer} that will call methods on {@link ListDocumentVersionsRequest.Builder}.
     * @return A Java Future containing the result of the ListDocumentVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InvalidDocumentException The specified document does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.ListDocumentVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListDocumentVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDocumentVersionsResponse> listDocumentVersions(
            Consumer<ListDocumentVersionsRequest.Builder> listDocumentVersionsRequest) {
        return listDocumentVersions(ListDocumentVersionsRequest.builder().apply(listDocumentVersionsRequest).build());
    }

    /**
     * <p>
     * Describes one or more of your Systems Manager documents.
     * </p>
     *
     * @param listDocumentsRequest
     * @return A Java Future containing the result of the ListDocuments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.ListDocuments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListDocuments" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDocumentsResponse> listDocuments(ListDocumentsRequest listDocumentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes one or more of your Systems Manager documents.
     * </p>
     *
     * @return A Java Future containing the result of the ListDocuments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.ListDocuments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListDocuments" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDocumentsResponse> listDocuments() {
        return listDocuments(ListDocumentsRequest.builder().build());
    }

    /**
     * <p>
     * Describes one or more of your Systems Manager documents.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link ListDocumentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDocumentsRequest#builder()}
     *
     * @param listDocumentsRequest
     *        a {@link Consumer} that will call methods on {@link ListDocumentsRequest.Builder}.
     * @return A Java Future containing the result of the ListDocuments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.ListDocuments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListDocuments" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDocumentsResponse> listDocuments(Consumer<ListDocumentsRequest.Builder> listDocumentsRequest) {
        return listDocuments(ListDocumentsRequest.builder().apply(listDocumentsRequest).build());
    }

    /**
     * <p>
     * A list of inventory items returned by the request.
     * </p>
     *
     * @param listInventoryEntriesRequest
     * @return A Java Future containing the result of the ListInventoryEntries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidTypeNameException The parameter type name is not valid.</li>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.ListInventoryEntries
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListInventoryEntries" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListInventoryEntriesResponse> listInventoryEntries(
            ListInventoryEntriesRequest listInventoryEntriesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A list of inventory items returned by the request.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link ListInventoryEntriesRequest.Builder} avoiding the
     * need to create one manually via {@link ListInventoryEntriesRequest#builder()}
     *
     * @param listInventoryEntriesRequest
     *        a {@link Consumer} that will call methods on {@link ListInventoryEntriesRequest.Builder}.
     * @return A Java Future containing the result of the ListInventoryEntries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidTypeNameException The parameter type name is not valid.</li>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.ListInventoryEntries
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListInventoryEntries" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListInventoryEntriesResponse> listInventoryEntries(
            Consumer<ListInventoryEntriesRequest.Builder> listInventoryEntriesRequest) {
        return listInventoryEntries(ListInventoryEntriesRequest.builder().apply(listInventoryEntriesRequest).build());
    }

    /**
     * <p>
     * Returns a resource-level summary count. The summary includes information about compliant and non-compliant
     * statuses and detailed compliance-item severity counts, according to the filter criteria you specify.
     * </p>
     *
     * @param listResourceComplianceSummariesRequest
     * @return A Java Future containing the result of the ListResourceComplianceSummaries operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.ListResourceComplianceSummaries
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListResourceComplianceSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResourceComplianceSummariesResponse> listResourceComplianceSummaries(
            ListResourceComplianceSummariesRequest listResourceComplianceSummariesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a resource-level summary count. The summary includes information about compliant and non-compliant
     * statuses and detailed compliance-item severity counts, according to the filter criteria you specify.
     * </p>
     *
     * @return A Java Future containing the result of the ListResourceComplianceSummaries operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.ListResourceComplianceSummaries
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListResourceComplianceSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResourceComplianceSummariesResponse> listResourceComplianceSummaries() {
        return listResourceComplianceSummaries(ListResourceComplianceSummariesRequest.builder().build());
    }

    /**
     * <p>
     * Returns a resource-level summary count. The summary includes information about compliant and non-compliant
     * statuses and detailed compliance-item severity counts, according to the filter criteria you specify.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link ListResourceComplianceSummariesRequest.Builder}
     * avoiding the need to create one manually via {@link ListResourceComplianceSummariesRequest#builder()}
     *
     * @param listResourceComplianceSummariesRequest
     *        a {@link Consumer} that will call methods on {@link ListResourceComplianceSummariesRequest.Builder}.
     * @return A Java Future containing the result of the ListResourceComplianceSummaries operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.ListResourceComplianceSummaries
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListResourceComplianceSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResourceComplianceSummariesResponse> listResourceComplianceSummaries(
            Consumer<ListResourceComplianceSummariesRequest.Builder> listResourceComplianceSummariesRequest) {
        return listResourceComplianceSummaries(ListResourceComplianceSummariesRequest.builder()
                .apply(listResourceComplianceSummariesRequest).build());
    }

    /**
     * <p>
     * Lists your resource data sync configurations. Includes information about the last time a sync attempted to start,
     * the last sync status, and the last time a sync successfully completed.
     * </p>
     * <p>
     * The number of sync configurations might be too large to return using a single call to
     * <code>ListResourceDataSync</code>. You can limit the number of sync configurations returned by using the
     * <code>MaxResults</code> parameter. To determine whether there are more sync configurations to list, check the
     * value of <code>NextToken</code> in the output. If there are more sync configurations to list, you can request
     * them by specifying the <code>NextToken</code> returned in the call to the parameter of a subsequent call.
     * </p>
     *
     * @param listResourceDataSyncRequest
     * @return A Java Future containing the result of the ListResourceDataSync operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.ListResourceDataSync
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListResourceDataSync" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListResourceDataSyncResponse> listResourceDataSync(
            ListResourceDataSyncRequest listResourceDataSyncRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists your resource data sync configurations. Includes information about the last time a sync attempted to start,
     * the last sync status, and the last time a sync successfully completed.
     * </p>
     * <p>
     * The number of sync configurations might be too large to return using a single call to
     * <code>ListResourceDataSync</code>. You can limit the number of sync configurations returned by using the
     * <code>MaxResults</code> parameter. To determine whether there are more sync configurations to list, check the
     * value of <code>NextToken</code> in the output. If there are more sync configurations to list, you can request
     * them by specifying the <code>NextToken</code> returned in the call to the parameter of a subsequent call.
     * </p>
     *
     * @return A Java Future containing the result of the ListResourceDataSync operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.ListResourceDataSync
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListResourceDataSync" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListResourceDataSyncResponse> listResourceDataSync() {
        return listResourceDataSync(ListResourceDataSyncRequest.builder().build());
    }

    /**
     * <p>
     * Lists your resource data sync configurations. Includes information about the last time a sync attempted to start,
     * the last sync status, and the last time a sync successfully completed.
     * </p>
     * <p>
     * The number of sync configurations might be too large to return using a single call to
     * <code>ListResourceDataSync</code>. You can limit the number of sync configurations returned by using the
     * <code>MaxResults</code> parameter. To determine whether there are more sync configurations to list, check the
     * value of <code>NextToken</code> in the output. If there are more sync configurations to list, you can request
     * them by specifying the <code>NextToken</code> returned in the call to the parameter of a subsequent call.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link ListResourceDataSyncRequest.Builder} avoiding the
     * need to create one manually via {@link ListResourceDataSyncRequest#builder()}
     *
     * @param listResourceDataSyncRequest
     *        a {@link Consumer} that will call methods on {@link ListResourceDataSyncRequest.Builder}.
     * @return A Java Future containing the result of the ListResourceDataSync operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.ListResourceDataSync
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListResourceDataSync" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListResourceDataSyncResponse> listResourceDataSync(
            Consumer<ListResourceDataSyncRequest.Builder> listResourceDataSyncRequest) {
        return listResourceDataSync(ListResourceDataSyncRequest.builder().apply(listResourceDataSyncRequest).build());
    }

    /**
     * <p>
     * Returns a list of the tags assigned to the specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidResourceTypeException The resource type is not valid. For example, if you are attempting to
     *         tag an instance, the instance must be a registered, managed instance.</li>
     *         <li>InvalidResourceIdException The resource ID is not valid. Verify that you entered the correct ID and
     *         try again.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the tags assigned to the specified resource.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     *
     * @param listTagsForResourceRequest
     *        a {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder}.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidResourceTypeException The resource type is not valid. For example, if you are attempting to
     *         tag an instance, the instance must be a registered, managed instance.</li>
     *         <li>InvalidResourceIdException The resource ID is not valid. Verify that you entered the correct ID and
     *         try again.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().apply(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Shares a Systems Manager document publicly or privately. If you share a document privately, you must specify the
     * AWS user account IDs for those people who can use the document. If you share a document publicly, you must
     * specify <i>All</i> as the account ID.
     * </p>
     *
     * @param modifyDocumentPermissionRequest
     * @return A Java Future containing the result of the ModifyDocumentPermission operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentException The specified document does not exist.</li>
     *         <li>InvalidPermissionTypeException The permission type is not supported. <i>Share</i> is the only
     *         supported permission type.</li>
     *         <li>DocumentPermissionLimitException The document cannot be shared with more AWS user accounts. You can
     *         share a document with a maximum of 20 accounts. You can publicly share up to five documents. If you need
     *         to increase this limit, contact AWS Support.</li>
     *         <li>DocumentLimitExceededException You can have at most 200 active Systems Manager documents.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.ModifyDocumentPermission
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ModifyDocumentPermission" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ModifyDocumentPermissionResponse> modifyDocumentPermission(
            ModifyDocumentPermissionRequest modifyDocumentPermissionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Shares a Systems Manager document publicly or privately. If you share a document privately, you must specify the
     * AWS user account IDs for those people who can use the document. If you share a document publicly, you must
     * specify <i>All</i> as the account ID.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link ModifyDocumentPermissionRequest.Builder} avoiding
     * the need to create one manually via {@link ModifyDocumentPermissionRequest#builder()}
     *
     * @param modifyDocumentPermissionRequest
     *        a {@link Consumer} that will call methods on {@link ModifyDocumentPermissionRequest.Builder}.
     * @return A Java Future containing the result of the ModifyDocumentPermission operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentException The specified document does not exist.</li>
     *         <li>InvalidPermissionTypeException The permission type is not supported. <i>Share</i> is the only
     *         supported permission type.</li>
     *         <li>DocumentPermissionLimitException The document cannot be shared with more AWS user accounts. You can
     *         share a document with a maximum of 20 accounts. You can publicly share up to five documents. If you need
     *         to increase this limit, contact AWS Support.</li>
     *         <li>DocumentLimitExceededException You can have at most 200 active Systems Manager documents.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.ModifyDocumentPermission
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ModifyDocumentPermission" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ModifyDocumentPermissionResponse> modifyDocumentPermission(
            Consumer<ModifyDocumentPermissionRequest.Builder> modifyDocumentPermissionRequest) {
        return modifyDocumentPermission(ModifyDocumentPermissionRequest.builder().apply(modifyDocumentPermissionRequest).build());
    }

    /**
     * <p>
     * Registers a compliance type and other compliance details on a designated resource. This action lets you register
     * custom compliance details with a resource. This call overwrites existing compliance information on the resource,
     * so you must provide a full list of compliance items each time that you send the request.
     * </p>
     *
     * @param putComplianceItemsRequest
     * @return A Java Future containing the result of the PutComplianceItems operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidItemContentException One or more content items is not valid.</li>
     *         <li>TotalSizeLimitExceededException The size of inventory data has exceeded the total size limit for the
     *         resource.</li>
     *         <li>ItemSizeLimitExceededException The inventory item size has exceeded the size limit.</li>
     *         <li>ComplianceTypeCountLimitExceededException You specified too many custom compliance types. You can
     *         specify a maximum of 10 different types.</li>
     *         <li>InvalidResourceTypeException The resource type is not valid. For example, if you are attempting to
     *         tag an instance, the instance must be a registered, managed instance.</li>
     *         <li>InvalidResourceIdException The resource ID is not valid. Verify that you entered the correct ID and
     *         try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.PutComplianceItems
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/PutComplianceItems" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutComplianceItemsResponse> putComplianceItems(PutComplianceItemsRequest putComplianceItemsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers a compliance type and other compliance details on a designated resource. This action lets you register
     * custom compliance details with a resource. This call overwrites existing compliance information on the resource,
     * so you must provide a full list of compliance items each time that you send the request.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link PutComplianceItemsRequest.Builder} avoiding the
     * need to create one manually via {@link PutComplianceItemsRequest#builder()}
     *
     * @param putComplianceItemsRequest
     *        a {@link Consumer} that will call methods on {@link PutComplianceItemsRequest.Builder}.
     * @return A Java Future containing the result of the PutComplianceItems operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidItemContentException One or more content items is not valid.</li>
     *         <li>TotalSizeLimitExceededException The size of inventory data has exceeded the total size limit for the
     *         resource.</li>
     *         <li>ItemSizeLimitExceededException The inventory item size has exceeded the size limit.</li>
     *         <li>ComplianceTypeCountLimitExceededException You specified too many custom compliance types. You can
     *         specify a maximum of 10 different types.</li>
     *         <li>InvalidResourceTypeException The resource type is not valid. For example, if you are attempting to
     *         tag an instance, the instance must be a registered, managed instance.</li>
     *         <li>InvalidResourceIdException The resource ID is not valid. Verify that you entered the correct ID and
     *         try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.PutComplianceItems
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/PutComplianceItems" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutComplianceItemsResponse> putComplianceItems(
            Consumer<PutComplianceItemsRequest.Builder> putComplianceItemsRequest) {
        return putComplianceItems(PutComplianceItemsRequest.builder().apply(putComplianceItemsRequest).build());
    }

    /**
     * <p>
     * Bulk update custom inventory items on one more instance. The request adds an inventory item, if it doesn't
     * already exist, or updates an inventory item, if it does exist.
     * </p>
     *
     * @param putInventoryRequest
     * @return A Java Future containing the result of the PutInventory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidTypeNameException The parameter type name is not valid.</li>
     *         <li>InvalidItemContentException One or more content items is not valid.</li>
     *         <li>TotalSizeLimitExceededException The size of inventory data has exceeded the total size limit for the
     *         resource.</li>
     *         <li>ItemSizeLimitExceededException The inventory item size has exceeded the size limit.</li>
     *         <li>ItemContentMismatchException The inventory item has invalid content.</li>
     *         <li>CustomSchemaCountLimitExceededException You have exceeded the limit for custom schemas. Delete one or
     *         more custom schemas and try again.</li>
     *         <li>UnsupportedInventorySchemaVersionException Inventory item type schema version has to match supported
     *         versions in the service. Check output of GetInventorySchema to see the available schema version for each
     *         type.</li>
     *         <li>UnsupportedInventoryItemContextException The <code>Context</code> attribute that you specified for
     *         the <code>InventoryItem</code> is not allowed for this inventory type. You can only use the
     *         <code>Context</code> attribute with inventory types like <code>AWS:ComplianceItem</code>.</li>
     *         <li>InvalidInventoryItemContextException You specified invalid keys or values in the <code>Context</code>
     *         attribute for <code>InventoryItem</code>. Verify the keys and values, and try again.</li>
     *         <li>SubTypeCountLimitExceededException The sub-type count exceeded the limit for the inventory type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.PutInventory
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/PutInventory" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutInventoryResponse> putInventory(PutInventoryRequest putInventoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Bulk update custom inventory items on one more instance. The request adds an inventory item, if it doesn't
     * already exist, or updates an inventory item, if it does exist.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link PutInventoryRequest.Builder} avoiding the need to
     * create one manually via {@link PutInventoryRequest#builder()}
     *
     * @param putInventoryRequest
     *        a {@link Consumer} that will call methods on {@link PutInventoryRequest.Builder}.
     * @return A Java Future containing the result of the PutInventory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidTypeNameException The parameter type name is not valid.</li>
     *         <li>InvalidItemContentException One or more content items is not valid.</li>
     *         <li>TotalSizeLimitExceededException The size of inventory data has exceeded the total size limit for the
     *         resource.</li>
     *         <li>ItemSizeLimitExceededException The inventory item size has exceeded the size limit.</li>
     *         <li>ItemContentMismatchException The inventory item has invalid content.</li>
     *         <li>CustomSchemaCountLimitExceededException You have exceeded the limit for custom schemas. Delete one or
     *         more custom schemas and try again.</li>
     *         <li>UnsupportedInventorySchemaVersionException Inventory item type schema version has to match supported
     *         versions in the service. Check output of GetInventorySchema to see the available schema version for each
     *         type.</li>
     *         <li>UnsupportedInventoryItemContextException The <code>Context</code> attribute that you specified for
     *         the <code>InventoryItem</code> is not allowed for this inventory type. You can only use the
     *         <code>Context</code> attribute with inventory types like <code>AWS:ComplianceItem</code>.</li>
     *         <li>InvalidInventoryItemContextException You specified invalid keys or values in the <code>Context</code>
     *         attribute for <code>InventoryItem</code>. Verify the keys and values, and try again.</li>
     *         <li>SubTypeCountLimitExceededException The sub-type count exceeded the limit for the inventory type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.PutInventory
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/PutInventory" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutInventoryResponse> putInventory(Consumer<PutInventoryRequest.Builder> putInventoryRequest) {
        return putInventory(PutInventoryRequest.builder().apply(putInventoryRequest).build());
    }

    /**
     * <p>
     * Add one or more parameters to the system.
     * </p>
     *
     * @param putParameterRequest
     * @return A Java Future containing the result of the PutParameter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidKeyIdException The query key ID is not valid.</li>
     *         <li>ParameterLimitExceededException You have exceeded the number of parameters for this AWS account.
     *         Delete one or more parameters and try again.</li>
     *         <li>TooManyUpdatesException There are concurrent updates for a resource that supports one update at a
     *         time.</li>
     *         <li>ParameterAlreadyExistsException The parameter already exists. You can't create duplicate parameters.</li>
     *         <li>HierarchyLevelLimitExceededException A hierarchy can have a maximum of five levels. For example:</p>
     *         <p>
     *         /Finance/Prod/IAD/OS/WinServ2016/license15
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-working.html">Working
     *         with Systems Manager Parameters</a>.</li>
     *         <li>HierarchyTypeMismatchException Parameter Store does not support changing a parameter type in a
     *         hierarchy. For example, you can't change a parameter from a String type to a SecureString type. You must
     *         create a new, unique parameter.</li>
     *         <li>InvalidAllowedPatternException The request does not meet the regular expression requirement.</li>
     *         <li>ParameterMaxVersionLimitExceededException The parameter exceeded the maximum number of allowed
     *         versions.</li>
     *         <li>ParameterPatternMismatchException The parameter name is not valid.</li>
     *         <li>UnsupportedParameterTypeException The parameter type is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.PutParameter
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/PutParameter" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutParameterResponse> putParameter(PutParameterRequest putParameterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Add one or more parameters to the system.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link PutParameterRequest.Builder} avoiding the need to
     * create one manually via {@link PutParameterRequest#builder()}
     *
     * @param putParameterRequest
     *        a {@link Consumer} that will call methods on {@link PutParameterRequest.Builder}.
     * @return A Java Future containing the result of the PutParameter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidKeyIdException The query key ID is not valid.</li>
     *         <li>ParameterLimitExceededException You have exceeded the number of parameters for this AWS account.
     *         Delete one or more parameters and try again.</li>
     *         <li>TooManyUpdatesException There are concurrent updates for a resource that supports one update at a
     *         time.</li>
     *         <li>ParameterAlreadyExistsException The parameter already exists. You can't create duplicate parameters.</li>
     *         <li>HierarchyLevelLimitExceededException A hierarchy can have a maximum of five levels. For example:</p>
     *         <p>
     *         /Finance/Prod/IAD/OS/WinServ2016/license15
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-working.html">Working
     *         with Systems Manager Parameters</a>.</li>
     *         <li>HierarchyTypeMismatchException Parameter Store does not support changing a parameter type in a
     *         hierarchy. For example, you can't change a parameter from a String type to a SecureString type. You must
     *         create a new, unique parameter.</li>
     *         <li>InvalidAllowedPatternException The request does not meet the regular expression requirement.</li>
     *         <li>ParameterMaxVersionLimitExceededException The parameter exceeded the maximum number of allowed
     *         versions.</li>
     *         <li>ParameterPatternMismatchException The parameter name is not valid.</li>
     *         <li>UnsupportedParameterTypeException The parameter type is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.PutParameter
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/PutParameter" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutParameterResponse> putParameter(Consumer<PutParameterRequest.Builder> putParameterRequest) {
        return putParameter(PutParameterRequest.builder().apply(putParameterRequest).build());
    }

    /**
     * <p>
     * Defines the default patch baseline.
     * </p>
     *
     * @param registerDefaultPatchBaselineRequest
     * @return A Java Future containing the result of the RegisterDefaultPatchBaseline operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidResourceIdException The resource ID is not valid. Verify that you entered the correct ID and
     *         try again.</li>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource (e.g. a Maintenance Window)
     *         doesn't exist.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.RegisterDefaultPatchBaseline
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RegisterDefaultPatchBaseline"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterDefaultPatchBaselineResponse> registerDefaultPatchBaseline(
            RegisterDefaultPatchBaselineRequest registerDefaultPatchBaselineRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Defines the default patch baseline.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link RegisterDefaultPatchBaselineRequest.Builder}
     * avoiding the need to create one manually via {@link RegisterDefaultPatchBaselineRequest#builder()}
     *
     * @param registerDefaultPatchBaselineRequest
     *        a {@link Consumer} that will call methods on {@link RegisterDefaultPatchBaselineRequest.Builder}.
     * @return A Java Future containing the result of the RegisterDefaultPatchBaseline operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidResourceIdException The resource ID is not valid. Verify that you entered the correct ID and
     *         try again.</li>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource (e.g. a Maintenance Window)
     *         doesn't exist.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.RegisterDefaultPatchBaseline
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RegisterDefaultPatchBaseline"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterDefaultPatchBaselineResponse> registerDefaultPatchBaseline(
            Consumer<RegisterDefaultPatchBaselineRequest.Builder> registerDefaultPatchBaselineRequest) {
        return registerDefaultPatchBaseline(RegisterDefaultPatchBaselineRequest.builder()
                .apply(registerDefaultPatchBaselineRequest).build());
    }

    /**
     * <p>
     * Registers a patch baseline for a patch group.
     * </p>
     *
     * @param registerPatchBaselineForPatchGroupRequest
     * @return A Java Future containing the result of the RegisterPatchBaselineForPatchGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException Error returned if an attempt is made to register a patch group with a patch
     *         baseline that is already registered with a different patch baseline.</li>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource (e.g. a Maintenance Window)
     *         doesn't exist.</li>
     *         <li>InvalidResourceIdException The resource ID is not valid. Verify that you entered the correct ID and
     *         try again.</li>
     *         <li>ResourceLimitExceededException Error returned when the caller has exceeded the default resource
     *         limits (e.g. too many Maintenance Windows have been created).</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.RegisterPatchBaselineForPatchGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RegisterPatchBaselineForPatchGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterPatchBaselineForPatchGroupResponse> registerPatchBaselineForPatchGroup(
            RegisterPatchBaselineForPatchGroupRequest registerPatchBaselineForPatchGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers a patch baseline for a patch group.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link RegisterPatchBaselineForPatchGroupRequest.Builder}
     * avoiding the need to create one manually via {@link RegisterPatchBaselineForPatchGroupRequest#builder()}
     *
     * @param registerPatchBaselineForPatchGroupRequest
     *        a {@link Consumer} that will call methods on {@link RegisterPatchBaselineForPatchGroupRequest.Builder}.
     * @return A Java Future containing the result of the RegisterPatchBaselineForPatchGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException Error returned if an attempt is made to register a patch group with a patch
     *         baseline that is already registered with a different patch baseline.</li>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource (e.g. a Maintenance Window)
     *         doesn't exist.</li>
     *         <li>InvalidResourceIdException The resource ID is not valid. Verify that you entered the correct ID and
     *         try again.</li>
     *         <li>ResourceLimitExceededException Error returned when the caller has exceeded the default resource
     *         limits (e.g. too many Maintenance Windows have been created).</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.RegisterPatchBaselineForPatchGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RegisterPatchBaselineForPatchGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterPatchBaselineForPatchGroupResponse> registerPatchBaselineForPatchGroup(
            Consumer<RegisterPatchBaselineForPatchGroupRequest.Builder> registerPatchBaselineForPatchGroupRequest) {
        return registerPatchBaselineForPatchGroup(RegisterPatchBaselineForPatchGroupRequest.builder()
                .apply(registerPatchBaselineForPatchGroupRequest).build());
    }

    /**
     * <p>
     * Registers a target with a Maintenance Window.
     * </p>
     *
     * @param registerTargetWithMaintenanceWindowRequest
     * @return A Java Future containing the result of the RegisterTargetWithMaintenanceWindow operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>IdempotentParameterMismatchException Error returned when an idempotent operation is retried and the
     *         parameters don't match the original call to the API with the same idempotency token.</li>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource (e.g. a Maintenance Window)
     *         doesn't exist.</li>
     *         <li>ResourceLimitExceededException Error returned when the caller has exceeded the default resource
     *         limits (e.g. too many Maintenance Windows have been created).</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.RegisterTargetWithMaintenanceWindow
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RegisterTargetWithMaintenanceWindow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterTargetWithMaintenanceWindowResponse> registerTargetWithMaintenanceWindow(
            RegisterTargetWithMaintenanceWindowRequest registerTargetWithMaintenanceWindowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers a target with a Maintenance Window.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link RegisterTargetWithMaintenanceWindowRequest.Builder}
     * avoiding the need to create one manually via {@link RegisterTargetWithMaintenanceWindowRequest#builder()}
     *
     * @param registerTargetWithMaintenanceWindowRequest
     *        a {@link Consumer} that will call methods on {@link RegisterTargetWithMaintenanceWindowRequest.Builder}.
     * @return A Java Future containing the result of the RegisterTargetWithMaintenanceWindow operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>IdempotentParameterMismatchException Error returned when an idempotent operation is retried and the
     *         parameters don't match the original call to the API with the same idempotency token.</li>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource (e.g. a Maintenance Window)
     *         doesn't exist.</li>
     *         <li>ResourceLimitExceededException Error returned when the caller has exceeded the default resource
     *         limits (e.g. too many Maintenance Windows have been created).</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.RegisterTargetWithMaintenanceWindow
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RegisterTargetWithMaintenanceWindow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterTargetWithMaintenanceWindowResponse> registerTargetWithMaintenanceWindow(
            Consumer<RegisterTargetWithMaintenanceWindowRequest.Builder> registerTargetWithMaintenanceWindowRequest) {
        return registerTargetWithMaintenanceWindow(RegisterTargetWithMaintenanceWindowRequest.builder()
                .apply(registerTargetWithMaintenanceWindowRequest).build());
    }

    /**
     * <p>
     * Adds a new task to a Maintenance Window.
     * </p>
     *
     * @param registerTaskWithMaintenanceWindowRequest
     * @return A Java Future containing the result of the RegisterTaskWithMaintenanceWindow operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>IdempotentParameterMismatchException Error returned when an idempotent operation is retried and the
     *         parameters don't match the original call to the API with the same idempotency token.</li>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource (e.g. a Maintenance Window)
     *         doesn't exist.</li>
     *         <li>ResourceLimitExceededException Error returned when the caller has exceeded the default resource
     *         limits (e.g. too many Maintenance Windows have been created).</li>
     *         <li>FeatureNotAvailableException You attempted to register a LAMBDA or STEP_FUNCTION task in a region
     *         where the corresponding service is not available.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.RegisterTaskWithMaintenanceWindow
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RegisterTaskWithMaintenanceWindow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterTaskWithMaintenanceWindowResponse> registerTaskWithMaintenanceWindow(
            RegisterTaskWithMaintenanceWindowRequest registerTaskWithMaintenanceWindowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a new task to a Maintenance Window.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link RegisterTaskWithMaintenanceWindowRequest.Builder}
     * avoiding the need to create one manually via {@link RegisterTaskWithMaintenanceWindowRequest#builder()}
     *
     * @param registerTaskWithMaintenanceWindowRequest
     *        a {@link Consumer} that will call methods on {@link RegisterTaskWithMaintenanceWindowRequest.Builder}.
     * @return A Java Future containing the result of the RegisterTaskWithMaintenanceWindow operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>IdempotentParameterMismatchException Error returned when an idempotent operation is retried and the
     *         parameters don't match the original call to the API with the same idempotency token.</li>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource (e.g. a Maintenance Window)
     *         doesn't exist.</li>
     *         <li>ResourceLimitExceededException Error returned when the caller has exceeded the default resource
     *         limits (e.g. too many Maintenance Windows have been created).</li>
     *         <li>FeatureNotAvailableException You attempted to register a LAMBDA or STEP_FUNCTION task in a region
     *         where the corresponding service is not available.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.RegisterTaskWithMaintenanceWindow
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RegisterTaskWithMaintenanceWindow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterTaskWithMaintenanceWindowResponse> registerTaskWithMaintenanceWindow(
            Consumer<RegisterTaskWithMaintenanceWindowRequest.Builder> registerTaskWithMaintenanceWindowRequest) {
        return registerTaskWithMaintenanceWindow(RegisterTaskWithMaintenanceWindowRequest.builder()
                .apply(registerTaskWithMaintenanceWindowRequest).build());
    }

    /**
     * <p>
     * Removes all tags from the specified resource.
     * </p>
     *
     * @param removeTagsFromResourceRequest
     * @return A Java Future containing the result of the RemoveTagsFromResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidResourceTypeException The resource type is not valid. For example, if you are attempting to
     *         tag an instance, the instance must be a registered, managed instance.</li>
     *         <li>InvalidResourceIdException The resource ID is not valid. Verify that you entered the correct ID and
     *         try again.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.RemoveTagsFromResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RemoveTagsFromResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RemoveTagsFromResourceResponse> removeTagsFromResource(
            RemoveTagsFromResourceRequest removeTagsFromResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes all tags from the specified resource.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link RemoveTagsFromResourceRequest.Builder} avoiding the
     * need to create one manually via {@link RemoveTagsFromResourceRequest#builder()}
     *
     * @param removeTagsFromResourceRequest
     *        a {@link Consumer} that will call methods on {@link RemoveTagsFromResourceRequest.Builder}.
     * @return A Java Future containing the result of the RemoveTagsFromResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidResourceTypeException The resource type is not valid. For example, if you are attempting to
     *         tag an instance, the instance must be a registered, managed instance.</li>
     *         <li>InvalidResourceIdException The resource ID is not valid. Verify that you entered the correct ID and
     *         try again.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.RemoveTagsFromResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RemoveTagsFromResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RemoveTagsFromResourceResponse> removeTagsFromResource(
            Consumer<RemoveTagsFromResourceRequest.Builder> removeTagsFromResourceRequest) {
        return removeTagsFromResource(RemoveTagsFromResourceRequest.builder().apply(removeTagsFromResourceRequest).build());
    }

    /**
     * <p>
     * Sends a signal to an Automation execution to change the current behavior or status of the execution.
     * </p>
     *
     * @param sendAutomationSignalRequest
     * @return A Java Future containing the result of the SendAutomationSignal operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AutomationExecutionNotFoundException There is no automation execution information for the requested
     *         automation execution ID.</li>
     *         <li>InvalidAutomationSignalException The signal is not valid for the current Automation execution.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.SendAutomationSignal
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/SendAutomationSignal" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SendAutomationSignalResponse> sendAutomationSignal(
            SendAutomationSignalRequest sendAutomationSignalRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends a signal to an Automation execution to change the current behavior or status of the execution.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link SendAutomationSignalRequest.Builder} avoiding the
     * need to create one manually via {@link SendAutomationSignalRequest#builder()}
     *
     * @param sendAutomationSignalRequest
     *        a {@link Consumer} that will call methods on {@link SendAutomationSignalRequest.Builder}.
     * @return A Java Future containing the result of the SendAutomationSignal operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AutomationExecutionNotFoundException There is no automation execution information for the requested
     *         automation execution ID.</li>
     *         <li>InvalidAutomationSignalException The signal is not valid for the current Automation execution.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.SendAutomationSignal
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/SendAutomationSignal" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SendAutomationSignalResponse> sendAutomationSignal(
            Consumer<SendAutomationSignalRequest.Builder> sendAutomationSignalRequest) {
        return sendAutomationSignal(SendAutomationSignalRequest.builder().apply(sendAutomationSignalRequest).build());
    }

    /**
     * <p>
     * Executes commands on one or more managed instances.
     * </p>
     *
     * @param sendCommandRequest
     * @return A Java Future containing the result of the SendCommand operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DuplicateInstanceIdException You cannot specify an instance ID in more than one association.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidDocumentException The specified document does not exist.</li>
     *         <li>InvalidOutputFolderException The S3 bucket does not exist.</li>
     *         <li>InvalidParametersException You must specify values for all required parameters in the Systems Manager
     *         document. You can only supply values to parameters defined in the Systems Manager document.</li>
     *         <li>UnsupportedPlatformTypeException The document does not support the platform type of the given
     *         instance ID(s). For example, you sent an document for a Windows instance to a Linux instance.</li>
     *         <li>MaxDocumentSizeExceededException The size limit of a document is 64 KB.</li>
     *         <li>InvalidRoleException The role name can't contain invalid characters. Also verify that you specified
     *         an IAM role for notifications that includes the required trust policy. For information about configuring
     *         the IAM role for Run Command notifications, see <a
     *         href="http://docs.aws.amazon.com/systems-manager/latest/userguide/rc-sns-notifications.html">Configuring
     *         Amazon SNS Notifications for Run Command</a> in the <i>Amazon EC2 Systems Manager User Guide</i>.</li>
     *         <li>InvalidNotificationConfigException One or more configuration items is not valid. Verify that a valid
     *         Amazon Resource Name (ARN) was provided for an Amazon SNS topic.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.SendCommand
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/SendCommand" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SendCommandResponse> sendCommand(SendCommandRequest sendCommandRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Executes commands on one or more managed instances.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link SendCommandRequest.Builder} avoiding the need to
     * create one manually via {@link SendCommandRequest#builder()}
     *
     * @param sendCommandRequest
     *        a {@link Consumer} that will call methods on {@link SendCommandRequest.Builder}.
     * @return A Java Future containing the result of the SendCommand operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DuplicateInstanceIdException You cannot specify an instance ID in more than one association.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidDocumentException The specified document does not exist.</li>
     *         <li>InvalidOutputFolderException The S3 bucket does not exist.</li>
     *         <li>InvalidParametersException You must specify values for all required parameters in the Systems Manager
     *         document. You can only supply values to parameters defined in the Systems Manager document.</li>
     *         <li>UnsupportedPlatformTypeException The document does not support the platform type of the given
     *         instance ID(s). For example, you sent an document for a Windows instance to a Linux instance.</li>
     *         <li>MaxDocumentSizeExceededException The size limit of a document is 64 KB.</li>
     *         <li>InvalidRoleException The role name can't contain invalid characters. Also verify that you specified
     *         an IAM role for notifications that includes the required trust policy. For information about configuring
     *         the IAM role for Run Command notifications, see <a
     *         href="http://docs.aws.amazon.com/systems-manager/latest/userguide/rc-sns-notifications.html">Configuring
     *         Amazon SNS Notifications for Run Command</a> in the <i>Amazon EC2 Systems Manager User Guide</i>.</li>
     *         <li>InvalidNotificationConfigException One or more configuration items is not valid. Verify that a valid
     *         Amazon Resource Name (ARN) was provided for an Amazon SNS topic.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.SendCommand
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/SendCommand" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SendCommandResponse> sendCommand(Consumer<SendCommandRequest.Builder> sendCommandRequest) {
        return sendCommand(SendCommandRequest.builder().apply(sendCommandRequest).build());
    }

    /**
     * <p>
     * Initiates execution of an Automation document.
     * </p>
     *
     * @param startAutomationExecutionRequest
     * @return A Java Future containing the result of the StartAutomationExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AutomationDefinitionNotFoundException An Automation document with the specified name could not be
     *         found.</li>
     *         <li>InvalidAutomationExecutionParametersException The supplied parameters for invoking the specified
     *         Automation document are incorrect. For example, they may not match the set of parameters permitted for
     *         the specified Automation document.</li>
     *         <li>AutomationExecutionLimitExceededException The number of simultaneously running Automation executions
     *         exceeded the allowable limit.</li>
     *         <li>AutomationDefinitionVersionNotFoundException An Automation document with the specified name and
     *         version could not be found.</li>
     *         <li>IdempotentParameterMismatchException Error returned when an idempotent operation is retried and the
     *         parameters don't match the original call to the API with the same idempotency token.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.StartAutomationExecution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/StartAutomationExecution" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartAutomationExecutionResponse> startAutomationExecution(
            StartAutomationExecutionRequest startAutomationExecutionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Initiates execution of an Automation document.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link StartAutomationExecutionRequest.Builder} avoiding
     * the need to create one manually via {@link StartAutomationExecutionRequest#builder()}
     *
     * @param startAutomationExecutionRequest
     *        a {@link Consumer} that will call methods on {@link StartAutomationExecutionRequest.Builder}.
     * @return A Java Future containing the result of the StartAutomationExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AutomationDefinitionNotFoundException An Automation document with the specified name could not be
     *         found.</li>
     *         <li>InvalidAutomationExecutionParametersException The supplied parameters for invoking the specified
     *         Automation document are incorrect. For example, they may not match the set of parameters permitted for
     *         the specified Automation document.</li>
     *         <li>AutomationExecutionLimitExceededException The number of simultaneously running Automation executions
     *         exceeded the allowable limit.</li>
     *         <li>AutomationDefinitionVersionNotFoundException An Automation document with the specified name and
     *         version could not be found.</li>
     *         <li>IdempotentParameterMismatchException Error returned when an idempotent operation is retried and the
     *         parameters don't match the original call to the API with the same idempotency token.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.StartAutomationExecution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/StartAutomationExecution" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartAutomationExecutionResponse> startAutomationExecution(
            Consumer<StartAutomationExecutionRequest.Builder> startAutomationExecutionRequest) {
        return startAutomationExecution(StartAutomationExecutionRequest.builder().apply(startAutomationExecutionRequest).build());
    }

    /**
     * <p>
     * Stop an Automation that is currently executing.
     * </p>
     *
     * @param stopAutomationExecutionRequest
     * @return A Java Future containing the result of the StopAutomationExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AutomationExecutionNotFoundException There is no automation execution information for the requested
     *         automation execution ID.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.StopAutomationExecution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/StopAutomationExecution" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StopAutomationExecutionResponse> stopAutomationExecution(
            StopAutomationExecutionRequest stopAutomationExecutionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stop an Automation that is currently executing.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link StopAutomationExecutionRequest.Builder} avoiding
     * the need to create one manually via {@link StopAutomationExecutionRequest#builder()}
     *
     * @param stopAutomationExecutionRequest
     *        a {@link Consumer} that will call methods on {@link StopAutomationExecutionRequest.Builder}.
     * @return A Java Future containing the result of the StopAutomationExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AutomationExecutionNotFoundException There is no automation execution information for the requested
     *         automation execution ID.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.StopAutomationExecution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/StopAutomationExecution" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StopAutomationExecutionResponse> stopAutomationExecution(
            Consumer<StopAutomationExecutionRequest.Builder> stopAutomationExecutionRequest) {
        return stopAutomationExecution(StopAutomationExecutionRequest.builder().apply(stopAutomationExecutionRequest).build());
    }

    /**
     * <p>
     * Updates an association. You can update the association name and version, the document version, schedule,
     * parameters, and Amazon S3 output.
     * </p>
     *
     * @param updateAssociationRequest
     * @return A Java Future containing the result of the UpdateAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidScheduleException The schedule is invalid. Verify your cron or rate expression and try again.</li>
     *         <li>InvalidParametersException You must specify values for all required parameters in the Systems Manager
     *         document. You can only supply values to parameters defined in the Systems Manager document.</li>
     *         <li>InvalidOutputLocationException The output location is not valid or does not exist.</li>
     *         <li>InvalidDocumentVersionException The document version is not valid or does not exist.</li>
     *         <li>AssociationDoesNotExistException The specified association does not exist.</li>
     *         <li>InvalidUpdateException The update is not valid.</li>
     *         <li>TooManyUpdatesException There are concurrent updates for a resource that supports one update at a
     *         time.</li>
     *         <li>InvalidDocumentException The specified document does not exist.</li>
     *         <li>InvalidTargetException The target is not valid or does not exist. It might not be configured for EC2
     *         Systems Manager or you might not have permission to perform the operation.</li>
     *         <li>InvalidAssociationVersionException The version you specified is not valid. Use
     *         ListAssociationVersions to view all versions of an association according to the association ID. Or, use
     *         the <code>&#36LATEST</code> parameter to view the latest version of the association.</li>
     *         <li>AssociationVersionLimitExceededException You have reached the maximum number versions allowed for an
     *         association. Each association has a limit of 1,000 versions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.UpdateAssociation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateAssociation" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateAssociationResponse> updateAssociation(UpdateAssociationRequest updateAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an association. You can update the association name and version, the document version, schedule,
     * parameters, and Amazon S3 output.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link UpdateAssociationRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateAssociationRequest#builder()}
     *
     * @param updateAssociationRequest
     *        a {@link Consumer} that will call methods on {@link UpdateAssociationRequest.Builder}.
     * @return A Java Future containing the result of the UpdateAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidScheduleException The schedule is invalid. Verify your cron or rate expression and try again.</li>
     *         <li>InvalidParametersException You must specify values for all required parameters in the Systems Manager
     *         document. You can only supply values to parameters defined in the Systems Manager document.</li>
     *         <li>InvalidOutputLocationException The output location is not valid or does not exist.</li>
     *         <li>InvalidDocumentVersionException The document version is not valid or does not exist.</li>
     *         <li>AssociationDoesNotExistException The specified association does not exist.</li>
     *         <li>InvalidUpdateException The update is not valid.</li>
     *         <li>TooManyUpdatesException There are concurrent updates for a resource that supports one update at a
     *         time.</li>
     *         <li>InvalidDocumentException The specified document does not exist.</li>
     *         <li>InvalidTargetException The target is not valid or does not exist. It might not be configured for EC2
     *         Systems Manager or you might not have permission to perform the operation.</li>
     *         <li>InvalidAssociationVersionException The version you specified is not valid. Use
     *         ListAssociationVersions to view all versions of an association according to the association ID. Or, use
     *         the <code>&#36LATEST</code> parameter to view the latest version of the association.</li>
     *         <li>AssociationVersionLimitExceededException You have reached the maximum number versions allowed for an
     *         association. Each association has a limit of 1,000 versions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.UpdateAssociation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateAssociation" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateAssociationResponse> updateAssociation(
            Consumer<UpdateAssociationRequest.Builder> updateAssociationRequest) {
        return updateAssociation(UpdateAssociationRequest.builder().apply(updateAssociationRequest).build());
    }

    /**
     * <p>
     * Updates the status of the Systems Manager document associated with the specified instance.
     * </p>
     *
     * @param updateAssociationStatusRequest
     * @return A Java Future containing the result of the UpdateAssociationStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidDocumentException The specified document does not exist.</li>
     *         <li>AssociationDoesNotExistException The specified association does not exist.</li>
     *         <li>StatusUnchangedException The updated status is the same as the current status.</li>
     *         <li>TooManyUpdatesException There are concurrent updates for a resource that supports one update at a
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.UpdateAssociationStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateAssociationStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateAssociationStatusResponse> updateAssociationStatus(
            UpdateAssociationStatusRequest updateAssociationStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the status of the Systems Manager document associated with the specified instance.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link UpdateAssociationStatusRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateAssociationStatusRequest#builder()}
     *
     * @param updateAssociationStatusRequest
     *        a {@link Consumer} that will call methods on {@link UpdateAssociationStatusRequest.Builder}.
     * @return A Java Future containing the result of the UpdateAssociationStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidDocumentException The specified document does not exist.</li>
     *         <li>AssociationDoesNotExistException The specified association does not exist.</li>
     *         <li>StatusUnchangedException The updated status is the same as the current status.</li>
     *         <li>TooManyUpdatesException There are concurrent updates for a resource that supports one update at a
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.UpdateAssociationStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateAssociationStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateAssociationStatusResponse> updateAssociationStatus(
            Consumer<UpdateAssociationStatusRequest.Builder> updateAssociationStatusRequest) {
        return updateAssociationStatus(UpdateAssociationStatusRequest.builder().apply(updateAssociationStatusRequest).build());
    }

    /**
     * <p>
     * The document you want to update.
     * </p>
     *
     * @param updateDocumentRequest
     * @return A Java Future containing the result of the UpdateDocument operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MaxDocumentSizeExceededException The size limit of a document is 64 KB.</li>
     *         <li>DocumentVersionLimitExceededException The document has too many versions. Delete one or more document
     *         versions and try again.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>DuplicateDocumentContentException The content of the association document matches another document.
     *         Change the content of the document and try again.</li>
     *         <li>InvalidDocumentContentException The content for the document is not valid.</li>
     *         <li>InvalidDocumentVersionException The document version is not valid or does not exist.</li>
     *         <li>InvalidDocumentSchemaVersionException The version of the document schema is not supported.</li>
     *         <li>InvalidDocumentException The specified document does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.UpdateDocument
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateDocument" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateDocumentResponse> updateDocument(UpdateDocumentRequest updateDocumentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The document you want to update.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link UpdateDocumentRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateDocumentRequest#builder()}
     *
     * @param updateDocumentRequest
     *        a {@link Consumer} that will call methods on {@link UpdateDocumentRequest.Builder}.
     * @return A Java Future containing the result of the UpdateDocument operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MaxDocumentSizeExceededException The size limit of a document is 64 KB.</li>
     *         <li>DocumentVersionLimitExceededException The document has too many versions. Delete one or more document
     *         versions and try again.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>DuplicateDocumentContentException The content of the association document matches another document.
     *         Change the content of the document and try again.</li>
     *         <li>InvalidDocumentContentException The content for the document is not valid.</li>
     *         <li>InvalidDocumentVersionException The document version is not valid or does not exist.</li>
     *         <li>InvalidDocumentSchemaVersionException The version of the document schema is not supported.</li>
     *         <li>InvalidDocumentException The specified document does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.UpdateDocument
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateDocument" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateDocumentResponse> updateDocument(Consumer<UpdateDocumentRequest.Builder> updateDocumentRequest) {
        return updateDocument(UpdateDocumentRequest.builder().apply(updateDocumentRequest).build());
    }

    /**
     * <p>
     * Set the default version of a document.
     * </p>
     *
     * @param updateDocumentDefaultVersionRequest
     * @return A Java Future containing the result of the UpdateDocumentDefaultVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentException The specified document does not exist.</li>
     *         <li>InvalidDocumentVersionException The document version is not valid or does not exist.</li>
     *         <li>InvalidDocumentSchemaVersionException The version of the document schema is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.UpdateDocumentDefaultVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateDocumentDefaultVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDocumentDefaultVersionResponse> updateDocumentDefaultVersion(
            UpdateDocumentDefaultVersionRequest updateDocumentDefaultVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Set the default version of a document.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link UpdateDocumentDefaultVersionRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateDocumentDefaultVersionRequest#builder()}
     *
     * @param updateDocumentDefaultVersionRequest
     *        a {@link Consumer} that will call methods on {@link UpdateDocumentDefaultVersionRequest.Builder}.
     * @return A Java Future containing the result of the UpdateDocumentDefaultVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentException The specified document does not exist.</li>
     *         <li>InvalidDocumentVersionException The document version is not valid or does not exist.</li>
     *         <li>InvalidDocumentSchemaVersionException The version of the document schema is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.UpdateDocumentDefaultVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateDocumentDefaultVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDocumentDefaultVersionResponse> updateDocumentDefaultVersion(
            Consumer<UpdateDocumentDefaultVersionRequest.Builder> updateDocumentDefaultVersionRequest) {
        return updateDocumentDefaultVersion(UpdateDocumentDefaultVersionRequest.builder()
                .apply(updateDocumentDefaultVersionRequest).build());
    }

    /**
     * <p>
     * Updates an existing Maintenance Window. Only specified parameters are modified.
     * </p>
     *
     * @param updateMaintenanceWindowRequest
     * @return A Java Future containing the result of the UpdateMaintenanceWindow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource (e.g. a Maintenance Window)
     *         doesn't exist.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.UpdateMaintenanceWindow
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateMaintenanceWindow" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateMaintenanceWindowResponse> updateMaintenanceWindow(
            UpdateMaintenanceWindowRequest updateMaintenanceWindowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing Maintenance Window. Only specified parameters are modified.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link UpdateMaintenanceWindowRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateMaintenanceWindowRequest#builder()}
     *
     * @param updateMaintenanceWindowRequest
     *        a {@link Consumer} that will call methods on {@link UpdateMaintenanceWindowRequest.Builder}.
     * @return A Java Future containing the result of the UpdateMaintenanceWindow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource (e.g. a Maintenance Window)
     *         doesn't exist.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.UpdateMaintenanceWindow
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateMaintenanceWindow" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateMaintenanceWindowResponse> updateMaintenanceWindow(
            Consumer<UpdateMaintenanceWindowRequest.Builder> updateMaintenanceWindowRequest) {
        return updateMaintenanceWindow(UpdateMaintenanceWindowRequest.builder().apply(updateMaintenanceWindowRequest).build());
    }

    /**
     * <p>
     * Modifies the target of an existing Maintenance Window. You can't change the target type, but you can change the
     * following:
     * </p>
     * <p>
     * The target from being an ID target to a Tag target, or a Tag target to an ID target.
     * </p>
     * <p>
     * IDs for an ID target.
     * </p>
     * <p>
     * Tags for a Tag target.
     * </p>
     * <p>
     * Owner.
     * </p>
     * <p>
     * Name.
     * </p>
     * <p>
     * Description.
     * </p>
     * <p>
     * If a parameter is null, then the corresponding field is not modified.
     * </p>
     *
     * @param updateMaintenanceWindowTargetRequest
     * @return A Java Future containing the result of the UpdateMaintenanceWindowTarget operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource (e.g. a Maintenance Window)
     *         doesn't exist.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.UpdateMaintenanceWindowTarget
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateMaintenanceWindowTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateMaintenanceWindowTargetResponse> updateMaintenanceWindowTarget(
            UpdateMaintenanceWindowTargetRequest updateMaintenanceWindowTargetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the target of an existing Maintenance Window. You can't change the target type, but you can change the
     * following:
     * </p>
     * <p>
     * The target from being an ID target to a Tag target, or a Tag target to an ID target.
     * </p>
     * <p>
     * IDs for an ID target.
     * </p>
     * <p>
     * Tags for a Tag target.
     * </p>
     * <p>
     * Owner.
     * </p>
     * <p>
     * Name.
     * </p>
     * <p>
     * Description.
     * </p>
     * <p>
     * If a parameter is null, then the corresponding field is not modified.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link UpdateMaintenanceWindowTargetRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateMaintenanceWindowTargetRequest#builder()}
     *
     * @param updateMaintenanceWindowTargetRequest
     *        a {@link Consumer} that will call methods on {@link UpdateMaintenanceWindowTargetRequest.Builder}.
     * @return A Java Future containing the result of the UpdateMaintenanceWindowTarget operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource (e.g. a Maintenance Window)
     *         doesn't exist.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.UpdateMaintenanceWindowTarget
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateMaintenanceWindowTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateMaintenanceWindowTargetResponse> updateMaintenanceWindowTarget(
            Consumer<UpdateMaintenanceWindowTargetRequest.Builder> updateMaintenanceWindowTargetRequest) {
        return updateMaintenanceWindowTarget(UpdateMaintenanceWindowTargetRequest.builder()
                .apply(updateMaintenanceWindowTargetRequest).build());
    }

    /**
     * <p>
     * Modifies a task assigned to a Maintenance Window. You can't change the task type, but you can change the
     * following values:
     * </p>
     * <p>
     * Task ARN. For example, you can change a RUN_COMMAND task from AWS-RunPowerShellScript to AWS-RunShellScript.
     * </p>
     * <p>
     * Service role ARN.
     * </p>
     * <p>
     * Task parameters.
     * </p>
     * <p>
     * Task priority.
     * </p>
     * <p>
     * Task MaxConcurrency and MaxErrors.
     * </p>
     * <p>
     * Log location.
     * </p>
     * <p>
     * If a parameter is null, then the corresponding field is not modified. Also, if you set Replace to true, then all
     * fields required by the RegisterTaskWithMaintenanceWindow action are required for this request. Optional fields
     * that aren't specified are set to null.
     * </p>
     *
     * @param updateMaintenanceWindowTaskRequest
     * @return A Java Future containing the result of the UpdateMaintenanceWindowTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource (e.g. a Maintenance Window)
     *         doesn't exist.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.UpdateMaintenanceWindowTask
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateMaintenanceWindowTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateMaintenanceWindowTaskResponse> updateMaintenanceWindowTask(
            UpdateMaintenanceWindowTaskRequest updateMaintenanceWindowTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies a task assigned to a Maintenance Window. You can't change the task type, but you can change the
     * following values:
     * </p>
     * <p>
     * Task ARN. For example, you can change a RUN_COMMAND task from AWS-RunPowerShellScript to AWS-RunShellScript.
     * </p>
     * <p>
     * Service role ARN.
     * </p>
     * <p>
     * Task parameters.
     * </p>
     * <p>
     * Task priority.
     * </p>
     * <p>
     * Task MaxConcurrency and MaxErrors.
     * </p>
     * <p>
     * Log location.
     * </p>
     * <p>
     * If a parameter is null, then the corresponding field is not modified. Also, if you set Replace to true, then all
     * fields required by the RegisterTaskWithMaintenanceWindow action are required for this request. Optional fields
     * that aren't specified are set to null.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link UpdateMaintenanceWindowTaskRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateMaintenanceWindowTaskRequest#builder()}
     *
     * @param updateMaintenanceWindowTaskRequest
     *        a {@link Consumer} that will call methods on {@link UpdateMaintenanceWindowTaskRequest.Builder}.
     * @return A Java Future containing the result of the UpdateMaintenanceWindowTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource (e.g. a Maintenance Window)
     *         doesn't exist.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.UpdateMaintenanceWindowTask
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateMaintenanceWindowTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateMaintenanceWindowTaskResponse> updateMaintenanceWindowTask(
            Consumer<UpdateMaintenanceWindowTaskRequest.Builder> updateMaintenanceWindowTaskRequest) {
        return updateMaintenanceWindowTask(UpdateMaintenanceWindowTaskRequest.builder().apply(updateMaintenanceWindowTaskRequest)
                .build());
    }

    /**
     * <p>
     * Assigns or changes an Amazon Identity and Access Management (IAM) role to the managed instance.
     * </p>
     *
     * @param updateManagedInstanceRoleRequest
     * @return A Java Future containing the result of the UpdateManagedInstanceRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.UpdateManagedInstanceRole
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateManagedInstanceRole" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateManagedInstanceRoleResponse> updateManagedInstanceRole(
            UpdateManagedInstanceRoleRequest updateManagedInstanceRoleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns or changes an Amazon Identity and Access Management (IAM) role to the managed instance.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link UpdateManagedInstanceRoleRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateManagedInstanceRoleRequest#builder()}
     *
     * @param updateManagedInstanceRoleRequest
     *        a {@link Consumer} that will call methods on {@link UpdateManagedInstanceRoleRequest.Builder}.
     * @return A Java Future containing the result of the UpdateManagedInstanceRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.UpdateManagedInstanceRole
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateManagedInstanceRole" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateManagedInstanceRoleResponse> updateManagedInstanceRole(
            Consumer<UpdateManagedInstanceRoleRequest.Builder> updateManagedInstanceRoleRequest) {
        return updateManagedInstanceRole(UpdateManagedInstanceRoleRequest.builder().apply(updateManagedInstanceRoleRequest)
                .build());
    }

    /**
     * <p>
     * Modifies an existing patch baseline. Fields not specified in the request are left unchanged.
     * </p>
     *
     * @param updatePatchBaselineRequest
     * @return A Java Future containing the result of the UpdatePatchBaseline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource (e.g. a Maintenance Window)
     *         doesn't exist.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.UpdatePatchBaseline
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdatePatchBaseline" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdatePatchBaselineResponse> updatePatchBaseline(
            UpdatePatchBaselineRequest updatePatchBaselineRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies an existing patch baseline. Fields not specified in the request are left unchanged.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link UpdatePatchBaselineRequest.Builder} avoiding the
     * need to create one manually via {@link UpdatePatchBaselineRequest#builder()}
     *
     * @param updatePatchBaselineRequest
     *        a {@link Consumer} that will call methods on {@link UpdatePatchBaselineRequest.Builder}.
     * @return A Java Future containing the result of the UpdatePatchBaseline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource (e.g. a Maintenance Window)
     *         doesn't exist.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SSMException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SSMAsyncClient.UpdatePatchBaseline
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdatePatchBaseline" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdatePatchBaselineResponse> updatePatchBaseline(
            Consumer<UpdatePatchBaselineRequest.Builder> updatePatchBaselineRequest) {
        return updatePatchBaseline(UpdatePatchBaselineRequest.builder().apply(updatePatchBaselineRequest).build());
    }
}
