/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.ComplianceStringFilterMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * One or more filters. Use a filter to return a more specific list of results.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ComplianceStringFilter implements StructuredPojo,
        ToCopyableBuilder<ComplianceStringFilter.Builder, ComplianceStringFilter> {
    private final String key;

    private final List<String> values;

    private final String type;

    private ComplianceStringFilter(BuilderImpl builder) {
        this.key = builder.key;
        this.values = builder.values;
        this.type = builder.type;
    }

    /**
     * <p>
     * The name of the filter.
     * </p>
     * 
     * @return The name of the filter.
     */
    public String key() {
        return key;
    }

    /**
     * <p>
     * The value for which to search.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value for which to search.
     */
    public List<String> values() {
        return values;
    }

    /**
     * <p>
     * The type of comparison that should be performed for the value: Equal, NotEqual, BeginWith, LessThan, or
     * GreaterThan.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ComplianceQueryOperatorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeString}.
     * </p>
     * 
     * @return The type of comparison that should be performed for the value: Equal, NotEqual, BeginWith, LessThan, or
     *         GreaterThan.
     * @see ComplianceQueryOperatorType
     */
    public ComplianceQueryOperatorType type() {
        return ComplianceQueryOperatorType.fromValue(type);
    }

    /**
     * <p>
     * The type of comparison that should be performed for the value: Equal, NotEqual, BeginWith, LessThan, or
     * GreaterThan.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ComplianceQueryOperatorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeString}.
     * </p>
     * 
     * @return The type of comparison that should be performed for the value: Equal, NotEqual, BeginWith, LessThan, or
     *         GreaterThan.
     * @see ComplianceQueryOperatorType
     */
    public String typeString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(values());
        hashCode = 31 * hashCode + Objects.hashCode(typeString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComplianceStringFilter)) {
            return false;
        }
        ComplianceStringFilter other = (ComplianceStringFilter) obj;
        return Objects.equals(key(), other.key()) && Objects.equals(values(), other.values())
                && Objects.equals(typeString(), other.typeString());
    }

    @Override
    public String toString() {
        return ToString.builder("ComplianceStringFilter").add("Key", key()).add("Values", values()).add("Type", typeString())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Key":
            return Optional.of(clazz.cast(key()));
        case "Values":
            return Optional.of(clazz.cast(values()));
        case "Type":
            return Optional.of(clazz.cast(typeString()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComplianceStringFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ComplianceStringFilter> {
        /**
         * <p>
         * The name of the filter.
         * </p>
         * 
         * @param key
         *        The name of the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * The value for which to search.
         * </p>
         * 
         * @param values
         *        The value for which to search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<String> values);

        /**
         * <p>
         * The value for which to search.
         * </p>
         * 
         * @param values
         *        The value for which to search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(String... values);

        /**
         * <p>
         * The type of comparison that should be performed for the value: Equal, NotEqual, BeginWith, LessThan, or
         * GreaterThan.
         * </p>
         * 
         * @param type
         *        The type of comparison that should be performed for the value: Equal, NotEqual, BeginWith, LessThan,
         *        or GreaterThan.
         * @see ComplianceQueryOperatorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComplianceQueryOperatorType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of comparison that should be performed for the value: Equal, NotEqual, BeginWith, LessThan, or
         * GreaterThan.
         * </p>
         * 
         * @param type
         *        The type of comparison that should be performed for the value: Equal, NotEqual, BeginWith, LessThan,
         *        or GreaterThan.
         * @see ComplianceQueryOperatorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComplianceQueryOperatorType
         */
        Builder type(ComplianceQueryOperatorType type);
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private List<String> values;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(ComplianceStringFilter model) {
            key(model.key);
            values(model.values);
            type(model.type);
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final Collection<String> getValues() {
            return values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = ComplianceStringFilterValueListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String... values) {
            values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = ComplianceStringFilterValueListCopier.copy(values);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ComplianceQueryOperatorType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public ComplianceStringFilter build() {
            return new ComplianceStringFilter(this);
        }
    }
}
