/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeletePatchBaselineRequest extends SSMRequest implements
        ToCopyableBuilder<DeletePatchBaselineRequest.Builder, DeletePatchBaselineRequest> {
    private final String baselineId;

    private DeletePatchBaselineRequest(BuilderImpl builder) {
        super(builder);
        this.baselineId = builder.baselineId;
    }

    /**
     * <p>
     * The ID of the patch baseline to delete.
     * </p>
     * 
     * @return The ID of the patch baseline to delete.
     */
    public String baselineId() {
        return baselineId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(baselineId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeletePatchBaselineRequest)) {
            return false;
        }
        DeletePatchBaselineRequest other = (DeletePatchBaselineRequest) obj;
        return Objects.equals(baselineId(), other.baselineId());
    }

    @Override
    public String toString() {
        return ToString.builder("DeletePatchBaselineRequest").add("BaselineId", baselineId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BaselineId":
            return Optional.of(clazz.cast(baselineId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SSMRequest.Builder, CopyableBuilder<Builder, DeletePatchBaselineRequest> {
        /**
         * <p>
         * The ID of the patch baseline to delete.
         * </p>
         * 
         * @param baselineId
         *        The ID of the patch baseline to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baselineId(String baselineId);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends SSMRequest.BuilderImpl implements Builder {
        private String baselineId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeletePatchBaselineRequest model) {
            baselineId(model.baselineId);
        }

        public final String getBaselineId() {
            return baselineId;
        }

        @Override
        public final Builder baselineId(String baselineId) {
            this.baselineId = baselineId;
            return this;
        }

        public final void setBaselineId(String baselineId) {
            this.baselineId = baselineId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeletePatchBaselineRequest build() {
            return new DeletePatchBaselineRequest(this);
        }
    }
}
