/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribePatchGroupStateRequest extends SSMRequest implements
        ToCopyableBuilder<DescribePatchGroupStateRequest.Builder, DescribePatchGroupStateRequest> {
    private final String patchGroup;

    private DescribePatchGroupStateRequest(BuilderImpl builder) {
        super(builder);
        this.patchGroup = builder.patchGroup;
    }

    /**
     * <p>
     * The name of the patch group whose patch snapshot should be retrieved.
     * </p>
     * 
     * @return The name of the patch group whose patch snapshot should be retrieved.
     */
    public String patchGroup() {
        return patchGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(patchGroup());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePatchGroupStateRequest)) {
            return false;
        }
        DescribePatchGroupStateRequest other = (DescribePatchGroupStateRequest) obj;
        return Objects.equals(patchGroup(), other.patchGroup());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribePatchGroupStateRequest").add("PatchGroup", patchGroup()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PatchGroup":
            return Optional.of(clazz.cast(patchGroup()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SSMRequest.Builder, CopyableBuilder<Builder, DescribePatchGroupStateRequest> {
        /**
         * <p>
         * The name of the patch group whose patch snapshot should be retrieved.
         * </p>
         * 
         * @param patchGroup
         *        The name of the patch group whose patch snapshot should be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patchGroup(String patchGroup);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends SSMRequest.BuilderImpl implements Builder {
        private String patchGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePatchGroupStateRequest model) {
            patchGroup(model.patchGroup);
        }

        public final String getPatchGroup() {
            return patchGroup;
        }

        @Override
        public final Builder patchGroup(String patchGroup) {
            this.patchGroup = patchGroup;
            return this;
        }

        public final void setPatchGroup(String patchGroup) {
            this.patchGroup = patchGroup;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribePatchGroupStateRequest build() {
            return new DescribePatchGroupStateRequest(this);
        }
    }
}
