/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetMaintenanceWindowExecutionTaskInvocationRequest extends SSMRequest
        implements
        ToCopyableBuilder<GetMaintenanceWindowExecutionTaskInvocationRequest.Builder, GetMaintenanceWindowExecutionTaskInvocationRequest> {
    private final String windowExecutionId;

    private final String taskId;

    private final String invocationId;

    private GetMaintenanceWindowExecutionTaskInvocationRequest(BuilderImpl builder) {
        super(builder);
        this.windowExecutionId = builder.windowExecutionId;
        this.taskId = builder.taskId;
        this.invocationId = builder.invocationId;
    }

    /**
     * <p>
     * The ID of the Maintenance Window execution for which the task is a part.
     * </p>
     * 
     * @return The ID of the Maintenance Window execution for which the task is a part.
     */
    public String windowExecutionId() {
        return windowExecutionId;
    }

    /**
     * <p>
     * The ID of the specific task in the Maintenance Window task that should be retrieved.
     * </p>
     * 
     * @return The ID of the specific task in the Maintenance Window task that should be retrieved.
     */
    public String taskId() {
        return taskId;
    }

    /**
     * <p>
     * The invocation ID to retrieve.
     * </p>
     * 
     * @return The invocation ID to retrieve.
     */
    public String invocationId() {
        return invocationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(windowExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(taskId());
        hashCode = 31 * hashCode + Objects.hashCode(invocationId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMaintenanceWindowExecutionTaskInvocationRequest)) {
            return false;
        }
        GetMaintenanceWindowExecutionTaskInvocationRequest other = (GetMaintenanceWindowExecutionTaskInvocationRequest) obj;
        return Objects.equals(windowExecutionId(), other.windowExecutionId()) && Objects.equals(taskId(), other.taskId())
                && Objects.equals(invocationId(), other.invocationId());
    }

    @Override
    public String toString() {
        return ToString.builder("GetMaintenanceWindowExecutionTaskInvocationRequest")
                .add("WindowExecutionId", windowExecutionId()).add("TaskId", taskId()).add("InvocationId", invocationId())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WindowExecutionId":
            return Optional.of(clazz.cast(windowExecutionId()));
        case "TaskId":
            return Optional.of(clazz.cast(taskId()));
        case "InvocationId":
            return Optional.of(clazz.cast(invocationId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SSMRequest.Builder,
            CopyableBuilder<Builder, GetMaintenanceWindowExecutionTaskInvocationRequest> {
        /**
         * <p>
         * The ID of the Maintenance Window execution for which the task is a part.
         * </p>
         * 
         * @param windowExecutionId
         *        The ID of the Maintenance Window execution for which the task is a part.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowExecutionId(String windowExecutionId);

        /**
         * <p>
         * The ID of the specific task in the Maintenance Window task that should be retrieved.
         * </p>
         * 
         * @param taskId
         *        The ID of the specific task in the Maintenance Window task that should be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskId(String taskId);

        /**
         * <p>
         * The invocation ID to retrieve.
         * </p>
         * 
         * @param invocationId
         *        The invocation ID to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invocationId(String invocationId);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends SSMRequest.BuilderImpl implements Builder {
        private String windowExecutionId;

        private String taskId;

        private String invocationId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMaintenanceWindowExecutionTaskInvocationRequest model) {
            windowExecutionId(model.windowExecutionId);
            taskId(model.taskId);
            invocationId(model.invocationId);
        }

        public final String getWindowExecutionId() {
            return windowExecutionId;
        }

        @Override
        public final Builder windowExecutionId(String windowExecutionId) {
            this.windowExecutionId = windowExecutionId;
            return this;
        }

        public final void setWindowExecutionId(String windowExecutionId) {
            this.windowExecutionId = windowExecutionId;
        }

        public final String getTaskId() {
            return taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public final String getInvocationId() {
            return invocationId;
        }

        @Override
        public final Builder invocationId(String invocationId) {
            this.invocationId = invocationId;
            return this;
        }

        public final void setInvocationId(String invocationId) {
            this.invocationId = invocationId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetMaintenanceWindowExecutionTaskInvocationRequest build() {
            return new GetMaintenanceWindowExecutionTaskInvocationRequest(this);
        }
    }
}
