/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class RegisterTargetWithMaintenanceWindowResponse extends SSMResponse implements
        ToCopyableBuilder<RegisterTargetWithMaintenanceWindowResponse.Builder, RegisterTargetWithMaintenanceWindowResponse> {
    private final String windowTargetId;

    private RegisterTargetWithMaintenanceWindowResponse(BuilderImpl builder) {
        super(builder);
        this.windowTargetId = builder.windowTargetId;
    }

    /**
     * <p>
     * The ID of the target definition in this Maintenance Window.
     * </p>
     * 
     * @return The ID of the target definition in this Maintenance Window.
     */
    public String windowTargetId() {
        return windowTargetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(windowTargetId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterTargetWithMaintenanceWindowResponse)) {
            return false;
        }
        RegisterTargetWithMaintenanceWindowResponse other = (RegisterTargetWithMaintenanceWindowResponse) obj;
        return Objects.equals(windowTargetId(), other.windowTargetId());
    }

    @Override
    public String toString() {
        return ToString.builder("RegisterTargetWithMaintenanceWindowResponse").add("WindowTargetId", windowTargetId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WindowTargetId":
            return Optional.of(clazz.cast(windowTargetId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SSMResponse.Builder, CopyableBuilder<Builder, RegisterTargetWithMaintenanceWindowResponse> {
        /**
         * <p>
         * The ID of the target definition in this Maintenance Window.
         * </p>
         * 
         * @param windowTargetId
         *        The ID of the target definition in this Maintenance Window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowTargetId(String windowTargetId);
    }

    static final class BuilderImpl extends SSMResponse.BuilderImpl implements Builder {
        private String windowTargetId;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterTargetWithMaintenanceWindowResponse model) {
            windowTargetId(model.windowTargetId);
        }

        public final String getWindowTargetId() {
            return windowTargetId;
        }

        @Override
        public final Builder windowTargetId(String windowTargetId) {
            this.windowTargetId = windowTargetId;
            return this;
        }

        public final void setWindowTargetId(String windowTargetId) {
            this.windowTargetId = windowTargetId;
        }

        @Override
        public RegisterTargetWithMaintenanceWindowResponse build() {
            return new RegisterTargetWithMaintenanceWindowResponse(this);
        }
    }
}
