/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateManagedInstanceRoleRequest extends SSMRequest implements
        ToCopyableBuilder<UpdateManagedInstanceRoleRequest.Builder, UpdateManagedInstanceRoleRequest> {
    private final String instanceId;

    private final String iamRole;

    private UpdateManagedInstanceRoleRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.iamRole = builder.iamRole;
    }

    /**
     * <p>
     * The ID of the managed instance where you want to update the role.
     * </p>
     * 
     * @return The ID of the managed instance where you want to update the role.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The IAM role you want to assign or change.
     * </p>
     * 
     * @return The IAM role you want to assign or change.
     */
    public String iamRole() {
        return iamRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(iamRole());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateManagedInstanceRoleRequest)) {
            return false;
        }
        UpdateManagedInstanceRoleRequest other = (UpdateManagedInstanceRoleRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(iamRole(), other.iamRole());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateManagedInstanceRoleRequest").add("InstanceId", instanceId()).add("IamRole", iamRole())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.of(clazz.cast(instanceId()));
        case "IamRole":
            return Optional.of(clazz.cast(iamRole()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SSMRequest.Builder, CopyableBuilder<Builder, UpdateManagedInstanceRoleRequest> {
        /**
         * <p>
         * The ID of the managed instance where you want to update the role.
         * </p>
         * 
         * @param instanceId
         *        The ID of the managed instance where you want to update the role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The IAM role you want to assign or change.
         * </p>
         * 
         * @param iamRole
         *        The IAM role you want to assign or change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRole(String iamRole);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends SSMRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String iamRole;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateManagedInstanceRoleRequest model) {
            instanceId(model.instanceId);
            iamRole(model.iamRole);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getIamRole() {
            return iamRole;
        }

        @Override
        public final Builder iamRole(String iamRole) {
            this.iamRole = iamRole;
            return this;
        }

        public final void setIamRole(String iamRole) {
            this.iamRole = iamRole;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateManagedInstanceRoleRequest build() {
            return new UpdateManagedInstanceRoleRequest(this);
        }
    }
}
