/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ssm.model.AccountIdListCopier;
import software.amazon.awssdk.services.ssm.model.SSMResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeDocumentPermissionResponse
extends SSMResponse
implements ToCopyableBuilder<Builder, DescribeDocumentPermissionResponse> {
    private final List<String> accountIds;

    private DescribeDocumentPermissionResponse(BuilderImpl builder) {
        super(builder);
        this.accountIds = builder.accountIds;
    }

    public List<String> accountIds() {
        return this.accountIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDocumentPermissionResponse)) {
            return false;
        }
        DescribeDocumentPermissionResponse other = (DescribeDocumentPermissionResponse)((Object)obj);
        return Objects.equals(this.accountIds(), other.accountIds());
    }

    public String toString() {
        return ToString.builder((String)"DescribeDocumentPermissionResponse").add("AccountIds", this.accountIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountIds": {
                return Optional.of(clazz.cast(this.accountIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SSMResponse.BuilderImpl
    implements Builder {
        private List<String> accountIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDocumentPermissionResponse model) {
            this.accountIds(model.accountIds);
        }

        public final Collection<String> getAccountIds() {
            return this.accountIds;
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdListCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String ... accountIds) {
            this.accountIds(Arrays.asList(accountIds));
            return this;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdListCopier.copy(accountIds);
        }

        @Override
        public DescribeDocumentPermissionResponse build() {
            return new DescribeDocumentPermissionResponse(this);
        }
    }

    public static interface Builder
    extends SSMResponse.Builder,
    CopyableBuilder<Builder, DescribeDocumentPermissionResponse> {
        public Builder accountIds(Collection<String> var1);

        public Builder accountIds(String ... var1);
    }
}

