/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ssm.model.ParameterStringFilter;
import software.amazon.awssdk.services.ssm.model.ParameterStringFilterListCopier;
import software.amazon.awssdk.services.ssm.model.ParametersFilter;
import software.amazon.awssdk.services.ssm.model.ParametersFilterListCopier;
import software.amazon.awssdk.services.ssm.model.SSMRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeParametersRequest
extends SSMRequest
implements ToCopyableBuilder<Builder, DescribeParametersRequest> {
    private final List<ParametersFilter> filters;
    private final List<ParameterStringFilter> parameterFilters;
    private final Integer maxResults;
    private final String nextToken;

    private DescribeParametersRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.parameterFilters = builder.parameterFilters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public List<ParametersFilter> filters() {
        return this.filters;
    }

    public List<ParameterStringFilter> parameterFilters() {
        return this.parameterFilters;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterFilters());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeParametersRequest)) {
            return false;
        }
        DescribeParametersRequest other = (DescribeParametersRequest)((Object)obj);
        return Objects.equals(this.filters(), other.filters()) && Objects.equals(this.parameterFilters(), other.parameterFilters()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeParametersRequest").add("Filters", this.filters()).add("ParameterFilters", this.parameterFilters()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filters": {
                return Optional.of(clazz.cast(this.filters()));
            }
            case "ParameterFilters": {
                return Optional.of(clazz.cast(this.parameterFilters()));
            }
            case "MaxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SSMRequest.BuilderImpl
    implements Builder {
        private List<ParametersFilter> filters;
        private List<ParameterStringFilter> parameterFilters;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeParametersRequest model) {
            this.filters(model.filters);
            this.parameterFilters(model.parameterFilters);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final Collection<ParametersFilter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(ParametersFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<ParametersFilter> filters) {
            this.filters = ParametersFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(ParametersFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<ParametersFilter.BuilderImpl> filters) {
            this.filters = ParametersFilterListCopier.copyFromBuilder(filters);
        }

        public final Collection<ParameterStringFilter.Builder> getParameterFilters() {
            return this.parameterFilters != null ? (Collection)this.parameterFilters.stream().map(ParameterStringFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameterFilters(Collection<ParameterStringFilter> parameterFilters) {
            this.parameterFilters = ParameterStringFilterListCopier.copy(parameterFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterFilters(ParameterStringFilter ... parameterFilters) {
            this.parameterFilters(Arrays.asList(parameterFilters));
            return this;
        }

        public final void setParameterFilters(Collection<ParameterStringFilter.BuilderImpl> parameterFilters) {
            this.parameterFilters = ParameterStringFilterListCopier.copyFromBuilder(parameterFilters);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeParametersRequest build() {
            return new DescribeParametersRequest(this);
        }
    }

    public static interface Builder
    extends SSMRequest.Builder,
    CopyableBuilder<Builder, DescribeParametersRequest> {
        public Builder filters(Collection<ParametersFilter> var1);

        public Builder filters(ParametersFilter ... var1);

        public Builder parameterFilters(Collection<ParameterStringFilter> var1);

        public Builder parameterFilters(ParameterStringFilter ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

