/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.InventoryResultItem;
import software.amazon.awssdk.services.ssm.model.InventoryResultItemMapCopier;
import software.amazon.awssdk.services.ssm.transform.InventoryResultEntityMarshaller;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InventoryResultEntity
implements StructuredPojo,
ToCopyableBuilder<Builder, InventoryResultEntity> {
    private final String id;
    private final Map<String, InventoryResultItem> data;

    private InventoryResultEntity(BuilderImpl builder) {
        this.id = builder.id;
        this.data = builder.data;
    }

    public String id() {
        return this.id;
    }

    public Map<String, InventoryResultItem> data() {
        return this.data;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.data());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InventoryResultEntity)) {
            return false;
        }
        InventoryResultEntity other = (InventoryResultEntity)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.data(), other.data());
    }

    public String toString() {
        return ToString.builder((String)"InventoryResultEntity").add("Id", (Object)this.id()).add("Data", this.data()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "Data": {
                return Optional.of(clazz.cast(this.data()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InventoryResultEntityMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private Map<String, InventoryResultItem> data;

        private BuilderImpl() {
        }

        private BuilderImpl(InventoryResultEntity model) {
            this.id(model.id);
            this.data(model.data);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Map<String, InventoryResultItem.Builder> getData() {
            return this.data != null ? CollectionUtils.mapValues(this.data, InventoryResultItem::toBuilder) : null;
        }

        @Override
        public final Builder data(Map<String, InventoryResultItem> data) {
            this.data = InventoryResultItemMapCopier.copy(data);
            return this;
        }

        public final void setData(Map<String, InventoryResultItem.BuilderImpl> data) {
            this.data = InventoryResultItemMapCopier.copyFromBuilder(data);
        }

        public InventoryResultEntity build() {
            return new InventoryResultEntity(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InventoryResultEntity> {
        public Builder id(String var1);

        public Builder data(Map<String, InventoryResultItem> var1);
    }
}

