/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ssm.model.ComplianceResourceIdListCopier;
import software.amazon.awssdk.services.ssm.model.ComplianceResourceTypeListCopier;
import software.amazon.awssdk.services.ssm.model.ComplianceStringFilter;
import software.amazon.awssdk.services.ssm.model.ComplianceStringFilterListCopier;
import software.amazon.awssdk.services.ssm.model.SSMRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListComplianceItemsRequest
extends SSMRequest
implements ToCopyableBuilder<Builder, ListComplianceItemsRequest> {
    private final List<ComplianceStringFilter> filters;
    private final List<String> resourceIds;
    private final List<String> resourceTypes;
    private final String nextToken;
    private final Integer maxResults;

    private ListComplianceItemsRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.resourceIds = builder.resourceIds;
        this.resourceTypes = builder.resourceTypes;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public List<ComplianceStringFilter> filters() {
        return this.filters;
    }

    public List<String> resourceIds() {
        return this.resourceIds;
    }

    public List<String> resourceTypes() {
        return this.resourceTypes;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypes());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListComplianceItemsRequest)) {
            return false;
        }
        ListComplianceItemsRequest other = (ListComplianceItemsRequest)((Object)obj);
        return Objects.equals(this.filters(), other.filters()) && Objects.equals(this.resourceIds(), other.resourceIds()) && Objects.equals(this.resourceTypes(), other.resourceTypes()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public String toString() {
        return ToString.builder((String)"ListComplianceItemsRequest").add("Filters", this.filters()).add("ResourceIds", this.resourceIds()).add("ResourceTypes", this.resourceTypes()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filters": {
                return Optional.of(clazz.cast(this.filters()));
            }
            case "ResourceIds": {
                return Optional.of(clazz.cast(this.resourceIds()));
            }
            case "ResourceTypes": {
                return Optional.of(clazz.cast(this.resourceTypes()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SSMRequest.BuilderImpl
    implements Builder {
        private List<ComplianceStringFilter> filters;
        private List<String> resourceIds;
        private List<String> resourceTypes;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListComplianceItemsRequest model) {
            this.filters(model.filters);
            this.resourceIds(model.resourceIds);
            this.resourceTypes(model.resourceTypes);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final Collection<ComplianceStringFilter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(ComplianceStringFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<ComplianceStringFilter> filters) {
            this.filters = ComplianceStringFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(ComplianceStringFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<ComplianceStringFilter.BuilderImpl> filters) {
            this.filters = ComplianceStringFilterListCopier.copyFromBuilder(filters);
        }

        public final Collection<String> getResourceIds() {
            return this.resourceIds;
        }

        @Override
        public final Builder resourceIds(Collection<String> resourceIds) {
            this.resourceIds = ComplianceResourceIdListCopier.copy(resourceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIds(String ... resourceIds) {
            this.resourceIds(Arrays.asList(resourceIds));
            return this;
        }

        public final void setResourceIds(Collection<String> resourceIds) {
            this.resourceIds = ComplianceResourceIdListCopier.copy(resourceIds);
        }

        public final Collection<String> getResourceTypes() {
            return this.resourceTypes;
        }

        @Override
        public final Builder resourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ComplianceResourceTypeListCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(String ... resourceTypes) {
            this.resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ComplianceResourceTypeListCopier.copy(resourceTypes);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListComplianceItemsRequest build() {
            return new ListComplianceItemsRequest(this);
        }
    }

    public static interface Builder
    extends SSMRequest.Builder,
    CopyableBuilder<Builder, ListComplianceItemsRequest> {
        public Builder filters(Collection<ComplianceStringFilter> var1);

        public Builder filters(ComplianceStringFilter ... var1);

        public Builder resourceIds(Collection<String> var1);

        public Builder resourceIds(String ... var1);

        public Builder resourceTypes(Collection<String> var1);

        public Builder resourceTypes(String ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

