/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.PatchComplianceLevel;
import software.amazon.awssdk.services.ssm.model.PatchDeploymentStatus;
import software.amazon.awssdk.services.ssm.transform.PatchStatusMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PatchStatus
implements StructuredPojo,
ToCopyableBuilder<Builder, PatchStatus> {
    private final String deploymentStatus;
    private final String complianceLevel;
    private final Instant approvalDate;

    private PatchStatus(BuilderImpl builder) {
        this.deploymentStatus = builder.deploymentStatus;
        this.complianceLevel = builder.complianceLevel;
        this.approvalDate = builder.approvalDate;
    }

    public PatchDeploymentStatus deploymentStatus() {
        return PatchDeploymentStatus.fromValue(this.deploymentStatus);
    }

    public String deploymentStatusString() {
        return this.deploymentStatus;
    }

    public PatchComplianceLevel complianceLevel() {
        return PatchComplianceLevel.fromValue(this.complianceLevel);
    }

    public String complianceLevelString() {
        return this.complianceLevel;
    }

    public Instant approvalDate() {
        return this.approvalDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentStatusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceLevelString());
        hashCode = 31 * hashCode + Objects.hashCode(this.approvalDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PatchStatus)) {
            return false;
        }
        PatchStatus other = (PatchStatus)obj;
        return Objects.equals(this.deploymentStatusString(), other.deploymentStatusString()) && Objects.equals(this.complianceLevelString(), other.complianceLevelString()) && Objects.equals(this.approvalDate(), other.approvalDate());
    }

    public String toString() {
        return ToString.builder((String)"PatchStatus").add("DeploymentStatus", (Object)this.deploymentStatusString()).add("ComplianceLevel", (Object)this.complianceLevelString()).add("ApprovalDate", (Object)this.approvalDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeploymentStatus": {
                return Optional.of(clazz.cast(this.deploymentStatusString()));
            }
            case "ComplianceLevel": {
                return Optional.of(clazz.cast(this.complianceLevelString()));
            }
            case "ApprovalDate": {
                return Optional.of(clazz.cast(this.approvalDate()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PatchStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String deploymentStatus;
        private String complianceLevel;
        private Instant approvalDate;

        private BuilderImpl() {
        }

        private BuilderImpl(PatchStatus model) {
            this.deploymentStatus(model.deploymentStatus);
            this.complianceLevel(model.complianceLevel);
            this.approvalDate(model.approvalDate);
        }

        public final String getDeploymentStatus() {
            return this.deploymentStatus;
        }

        @Override
        public final Builder deploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
            return this;
        }

        @Override
        public final Builder deploymentStatus(PatchDeploymentStatus deploymentStatus) {
            this.deploymentStatus(deploymentStatus.toString());
            return this;
        }

        public final void setDeploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
        }

        public final String getComplianceLevel() {
            return this.complianceLevel;
        }

        @Override
        public final Builder complianceLevel(String complianceLevel) {
            this.complianceLevel = complianceLevel;
            return this;
        }

        @Override
        public final Builder complianceLevel(PatchComplianceLevel complianceLevel) {
            this.complianceLevel(complianceLevel.toString());
            return this;
        }

        public final void setComplianceLevel(String complianceLevel) {
            this.complianceLevel = complianceLevel;
        }

        public final Instant getApprovalDate() {
            return this.approvalDate;
        }

        @Override
        public final Builder approvalDate(Instant approvalDate) {
            this.approvalDate = approvalDate;
            return this;
        }

        public final void setApprovalDate(Instant approvalDate) {
            this.approvalDate = approvalDate;
        }

        public PatchStatus build() {
            return new PatchStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PatchStatus> {
        public Builder deploymentStatus(String var1);

        public Builder deploymentStatus(PatchDeploymentStatus var1);

        public Builder complianceLevel(String var1);

        public Builder complianceLevel(PatchComplianceLevel var1);

        public Builder approvalDate(Instant var1);
    }
}

